/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class CrossSeriesAggregationDescriptor
extends AggregationDescriptor {
    private final List<Expression> outputExpressions;
    private List<List<Expression>> groupedInputExpressions;
    private final int expressionNumOfOneInput;

    public CrossSeriesAggregationDescriptor(String aggregationFuncName, AggregationStep step, List<Expression> inputExpressions, int numberOfInput, Map<String, String> inputAttributes, List<Expression> outputExpressions) {
        super(aggregationFuncName, step, inputExpressions, inputAttributes);
        this.outputExpressions = outputExpressions;
        this.expressionNumOfOneInput = inputExpressions.size() / numberOfInput;
        this.initGroupedInputExpressions();
    }

    public CrossSeriesAggregationDescriptor(String aggregationFuncName, AggregationStep step, List<Expression> inputExpressions, Map<String, String> inputAttributes, List<Expression> outputExpressions) {
        super(aggregationFuncName, step, inputExpressions, inputAttributes);
        this.outputExpressions = outputExpressions;
        this.expressionNumOfOneInput = 1;
        this.initGroupedInputExpressions();
    }

    public CrossSeriesAggregationDescriptor(AggregationDescriptor aggregationDescriptor, List<Expression> outputExpressions, int expressionNumOfOneInput) {
        super(aggregationDescriptor);
        this.outputExpressions = outputExpressions;
        this.expressionNumOfOneInput = expressionNumOfOneInput;
        this.initGroupedInputExpressions();
    }

    public List<Expression> getOutputExpressions() {
        return this.outputExpressions;
    }

    @Override
    public String getParametersString() {
        if (this.parametersString == null) {
            StringBuilder builder;
            if (TAggregationType.COUNT_IF.equals((Object)this.aggregationType)) {
                builder = new StringBuilder(this.outputExpressions.get(0).getExpressionString());
                for (int i = 1; i < this.expressionNumOfOneInput; ++i) {
                    builder.append(", ").append(((Expression)this.inputExpressions.get(i)).getExpressionString());
                }
                this.appendAttributes(builder);
            } else {
                builder = this.getOutputExpressionsAsBuilder();
            }
            this.parametersString = builder.toString();
        }
        return this.parametersString;
    }

    @Override
    public List<List<String>> getInputColumnNamesList() {
        if (this.step.isInputRaw()) {
            List<String> inputColumnNames = "count_if".equalsIgnoreCase(this.aggregationFuncName) ? Collections.singletonList(((Expression)this.inputExpressions.get(0)).getExpressionString()) : this.inputExpressions.stream().map(Expression::getExpressionString).collect(Collectors.toList());
            return Collections.singletonList(inputColumnNames);
        }
        ArrayList<List<String>> inputColumnNamesList = new ArrayList<List<String>>();
        this.groupedInputExpressions.forEach(list -> inputColumnNamesList.add(this.getInputColumnNames((List<Expression>)list)));
        return inputColumnNamesList;
    }

    @Override
    public List<String> getInputExpressionsAsStringList() {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < this.inputExpressions.size(); i += this.expressionNumOfOneInput) {
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            for (int j = 0; j < this.expressionNumOfOneInput; ++j) {
                expressions.add((Expression)this.inputExpressions.get(i + j));
            }
            res.add(this.getInputString(expressions));
        }
        return res;
    }

    public Map<String, List<Expression>> getGroupedInputStringToExpressionsMap() {
        HashMap<String, List<Expression>> map = new HashMap<String, List<Expression>>();
        this.groupedInputExpressions.forEach(list -> map.put(this.getInputString((List<Expression>)list), (List<Expression>)list));
        return map;
    }

    public List<String> getGroupedInputExpressionStrings() {
        return this.groupedInputExpressions.stream().map(this::getInputString).collect(Collectors.toList());
    }

    public StringBuilder getOutputExpressionsAsBuilder() {
        StringBuilder builder = new StringBuilder(this.outputExpressions.get(0).getExpressionString());
        for (int i = 1; i < this.outputExpressions.size(); ++i) {
            builder.append(", ").append(this.outputExpressions.get(i).getExpressionString());
        }
        this.appendAttributes(builder);
        return builder;
    }

    private void initGroupedInputExpressions() {
        this.groupedInputExpressions = new ArrayList<List<Expression>>();
        for (int i = 0; i < this.inputExpressions.size(); i += this.expressionNumOfOneInput) {
            ArrayList<Expression> expressions = new ArrayList<Expression>(this.expressionNumOfOneInput);
            for (int j = 0; j < this.expressionNumOfOneInput; ++j) {
                expressions.add((Expression)this.inputExpressions.get(i + j));
            }
            this.groupedInputExpressions.add(expressions);
        }
    }

    private List<String> getInputColumnNames(List<Expression> expressions) {
        List<String> inputAggregationNames = this.getActualAggregationNames(this.step.isInputPartial());
        ArrayList<String> inputColumnNames = new ArrayList<String>();
        for (String funcName : inputAggregationNames) {
            inputColumnNames.add(funcName + "(" + this.getInputString(expressions) + ")");
        }
        return inputColumnNames;
    }

    @Override
    public void setInputExpressions(List<Expression> inputExpressions) {
        this.inputExpressions = inputExpressions;
        this.initGroupedInputExpressions();
    }

    @Override
    public CrossSeriesAggregationDescriptor deepClone() {
        return new CrossSeriesAggregationDescriptor(this, this.outputExpressions, this.expressionNumOfOneInput);
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.outputExpressions.size(), (ByteBuffer)byteBuffer);
        this.outputExpressions.forEach(x -> Expression.serialize(x, byteBuffer));
        ReadWriteIOUtils.write((int)this.expressionNumOfOneInput, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((int)this.outputExpressions.size(), (OutputStream)stream);
        for (Expression x : this.outputExpressions) {
            Expression.serialize(x, stream);
        }
        ReadWriteIOUtils.write((int)this.expressionNumOfOneInput, (OutputStream)stream);
    }

    public static CrossSeriesAggregationDescriptor deserialize(ByteBuffer byteBuffer) {
        AggregationDescriptor aggregationDescriptor = AggregationDescriptor.deserialize(byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Expression> outputExpressions = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            outputExpressions.add(Expression.deserialize(byteBuffer));
        }
        int expressionNumOfOneInput = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        return new CrossSeriesAggregationDescriptor(aggregationDescriptor, outputExpressions, expressionNumOfOneInput);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CrossSeriesAggregationDescriptor that = (CrossSeriesAggregationDescriptor)o;
        return Objects.equals(this.outputExpressions, that.outputExpressions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.outputExpressions);
    }

    public int getExpressionNumOfOneInput() {
        return this.expressionNumOfOneInput;
    }
}

