/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.exception.MemoryNotEnoughException;
import org.apache.iotdb.db.queryengine.execution.driver.DataDriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.DataNodeQueryContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.metric.QueryRelatedResourceMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanContext;
import org.apache.iotdb.db.queryengine.plan.planner.OperatorTreeGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.PipelineDriverFactory;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.utils.SetThreadName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalExecutionPlanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalExecutionPlanner.class);
    private static final long ALLOCATE_MEMORY_FOR_OPERATORS;
    private static final long MAX_REST_MEMORY_FOR_LOAD;
    private long freeMemoryForOperators = ALLOCATE_MEMORY_FOR_OPERATORS;

    public long getFreeMemoryForOperators() {
        return this.freeMemoryForOperators;
    }

    public static LocalExecutionPlanner getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public List<PipelineDriverFactory> plan(PlanNode plan, TypeProvider types, FragmentInstanceContext instanceContext, DataNodeQueryContext dataNodeQueryContext) throws MemoryNotEnoughException {
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(types, instanceContext, dataNodeQueryContext);
        Operator root = plan.accept(new OperatorTreeGenerator(), context);
        long estimatedMemorySize = this.checkMemory(root, instanceContext.getStateMachine());
        context.addPipelineDriverFactory(root, context.getDriverContext(), estimatedMemorySize);
        instanceContext.setSourcePaths(this.collectSourcePaths(context));
        context.getTimePartitions().ifPresent(instanceContext::setTimePartitions);
        context.setMaxBytesOneHandleCanReserve();
        return context.getPipelineDriverFactories();
    }

    public List<PipelineDriverFactory> plan(PlanNode plan, FragmentInstanceContext instanceContext, ISchemaRegion schemaRegion) throws MemoryNotEnoughException {
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(instanceContext, schemaRegion);
        Operator root = plan.accept(new OperatorTreeGenerator(), context);
        this.checkMemory(root, instanceContext.getStateMachine());
        context.addPipelineDriverFactory(root, context.getDriverContext(), 0L);
        context.setMaxBytesOneHandleCanReserve();
        return context.getPipelineDriverFactories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkMemory(Operator root, FragmentInstanceStateMachine stateMachine) throws MemoryNotEnoughException {
        if (!IoTDBDescriptor.getInstance().getConfig().isEnableQueryMemoryEstimation() && !IoTDBDescriptor.getInstance().getConfig().isQuotaEnable()) {
            return 0L;
        }
        long estimatedMemorySize = root.calculateMaxPeekMemoryWithCounter();
        QueryRelatedResourceMetricSet.getInstance().updateEstimatedMemory(estimatedMemorySize);
        LocalExecutionPlanner localExecutionPlanner = this;
        synchronized (localExecutionPlanner) {
            if (estimatedMemorySize > this.freeMemoryForOperators) {
                throw new MemoryNotEnoughException(String.format("There is not enough memory to execute current fragment instance, current remaining free memory is %dB, estimated memory usage for current fragment instance is %dB", this.freeMemoryForOperators, estimatedMemorySize));
            }
            this.freeMemoryForOperators -= estimatedMemorySize;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[ConsumeMemory] consume: {}, current remaining memory: {}", (Object)estimatedMemorySize, (Object)this.freeMemoryForOperators);
            }
        }
        stateMachine.addStateChangeListener(newState -> {
            if (newState.isDone()) {
                try (SetThreadName fragmentInstanceName = new SetThreadName(stateMachine.getFragmentInstanceId().getFullId());){
                    LocalExecutionPlanner localExecutionPlanner = this;
                    synchronized (localExecutionPlanner) {
                        this.freeMemoryForOperators += estimatedMemorySize;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("[ReleaseMemory] release: {}, current remaining memory: {}", (Object)estimatedMemorySize, (Object)this.freeMemoryForOperators);
                        }
                    }
                }
            }
        });
        return estimatedMemorySize;
    }

    private List<PartialPath> collectSourcePaths(LocalExecutionPlanContext context) {
        ArrayList<PartialPath> sourcePaths = new ArrayList<PartialPath>();
        context.getPipelineDriverFactories().forEach(pipeline -> {
            DataDriverContext dataDriverContext = (DataDriverContext)pipeline.getDriverContext();
            sourcePaths.addAll(dataDriverContext.getPaths());
            dataDriverContext.clearPaths();
        });
        return sourcePaths;
    }

    public synchronized boolean forceAllocateFreeMemoryForOperators(long memoryInBytes) {
        if (this.freeMemoryForOperators - memoryInBytes <= MAX_REST_MEMORY_FOR_LOAD) {
            return false;
        }
        this.freeMemoryForOperators -= memoryInBytes;
        return true;
    }

    public synchronized long tryAllocateFreeMemoryForOperators(long memoryInBytes) {
        if (this.freeMemoryForOperators - memoryInBytes <= MAX_REST_MEMORY_FOR_LOAD) {
            long result = this.freeMemoryForOperators - MAX_REST_MEMORY_FOR_LOAD;
            this.freeMemoryForOperators = MAX_REST_MEMORY_FOR_LOAD;
            return result;
        }
        this.freeMemoryForOperators -= memoryInBytes;
        return memoryInBytes;
    }

    public synchronized void releaseToFreeMemoryForOperators(long memoryInBytes) {
        this.freeMemoryForOperators += memoryInBytes;
    }

    public long getAllocateMemoryForOperators() {
        return ALLOCATE_MEMORY_FOR_OPERATORS;
    }

    static {
        IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
        ALLOCATE_MEMORY_FOR_OPERATORS = CONFIG.getAllocateMemoryForOperators();
        MAX_REST_MEMORY_FOR_LOAD = (long)((double)ALLOCATE_MEMORY_FOR_OPERATORS * (1.0 - CONFIG.getMaxAllocateMemoryRatioForLoad()));
    }

    private static class InstanceHolder {
        private static final LocalExecutionPlanner INSTANCE = new LocalExecutionPlanner();

        private InstanceHolder() {
        }
    }
}

