/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.other.GroupByTimeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.InExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate.ConvertPredicateToTimeFilterVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate.PredicateVisitor;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.filter.factory.ValueFilterApi;
import org.apache.iotdb.tsfile.read.filter.operator.ValueFilterOperators;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class ConvertPredicateToFilterVisitor
extends PredicateVisitor<Filter, Context> {
    private static final ConvertPredicateToTimeFilterVisitor timeFilterConvertor = new ConvertPredicateToTimeFilterVisitor();

    @Override
    public Filter visitInExpression(InExpression inExpression, Context context) {
        Expression operand = inExpression.getExpression();
        if (operand.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
            return (Filter)timeFilterConvertor.process(inExpression, null);
        }
        Preconditions.checkArgument((boolean)operand.getExpressionType().equals((Object)ExpressionType.TIMESERIES));
        LinkedHashSet<String> stringValues = inExpression.getValues();
        if (stringValues.size() == 1) {
            Expression rewrittenExpression = this.rewriteInExpressionToEqual(inExpression, context);
            return (Filter)this.process(rewrittenExpression, context);
        }
        PartialPath path = ((TimeSeriesOperand)operand).getPath();
        if (inExpression.isNotIn()) {
            return this.constructNotInFilter(path, stringValues, context);
        }
        return this.constructInFilter(path, stringValues, context);
    }

    private Expression rewriteInExpressionToEqual(InExpression inExpression, Context context) {
        LinkedHashSet<String> stringValues = inExpression.getValues();
        PartialPath path = ((TimeSeriesOperand)inExpression.getExpression()).getPath();
        if (inExpression.isNotIn()) {
            return new NonEqualExpression(inExpression.getExpression(), new ConstantOperand(context.getType(path), (String)stringValues.iterator().next()));
        }
        return new EqualToExpression(inExpression.getExpression(), new ConstantOperand(context.getType(path), (String)stringValues.iterator().next()));
    }

    private <T extends Comparable<T>> ValueFilterOperators.ValueNotIn<T> constructNotInFilter(PartialPath path, Set<String> stringValues, Context context) {
        int measurementIndex = context.getMeasurementIndex(path.getMeasurement());
        Set<T> values = this.constructInSet(stringValues, context.getType(path));
        return ValueFilterApi.notIn((int)measurementIndex, values);
    }

    private <T extends Comparable<T>> ValueFilterOperators.ValueIn<T> constructInFilter(PartialPath path, Set<String> stringValues, Context context) {
        int measurementIndex = context.getMeasurementIndex(path.getMeasurement());
        Set<T> values = this.constructInSet(stringValues, context.getType(path));
        return ValueFilterApi.in((int)measurementIndex, values);
    }

    private <T extends Comparable<T>> Set<T> constructInSet(Set<String> stringValues, TSDataType dataType) {
        HashSet<T> values = new HashSet<T>();
        for (String valueString : stringValues) {
            values.add(ConvertPredicateToFilterVisitor.getValue(valueString, dataType));
        }
        return values;
    }

    @Override
    public Filter visitIsNullExpression(IsNullExpression isNullExpression, Context context) {
        if (!isNullExpression.isNot()) {
            throw new IllegalArgumentException("IS NULL cannot be pushed down");
        }
        Expression operand = isNullExpression.getExpression();
        if (operand.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
            throw new UnsupportedOperationException("TIMESTAMP does not support IS NULL/IS NOT NULL");
        }
        Preconditions.checkArgument((boolean)operand.getExpressionType().equals((Object)ExpressionType.TIMESERIES));
        int measurementIndex = context.getMeasurementIndex(((TimeSeriesOperand)operand).getPath().getMeasurement());
        return ValueFilterApi.isNotNull((int)measurementIndex);
    }

    @Override
    public Filter visitLikeExpression(LikeExpression likeExpression, Context context) {
        Expression operand = likeExpression.getExpression();
        if (operand.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
            throw new UnsupportedOperationException("TIMESTAMP does not support LIKE/NOT LIKE");
        }
        Preconditions.checkArgument((boolean)operand.getExpressionType().equals((Object)ExpressionType.TIMESERIES));
        int measurementIndex = context.getMeasurementIndex(((TimeSeriesOperand)operand).getPath().getMeasurement());
        if (likeExpression.isNot()) {
            return ValueFilterApi.notLike((int)measurementIndex, (Pattern)likeExpression.getPattern());
        }
        return ValueFilterApi.like((int)measurementIndex, (Pattern)likeExpression.getPattern());
    }

    @Override
    public Filter visitRegularExpression(RegularExpression regularExpression, Context context) {
        Expression operand = regularExpression.getExpression();
        if (operand.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
            throw new UnsupportedOperationException("TIMESTAMP does not support REGEXP/NOT REGEXP");
        }
        Preconditions.checkArgument((boolean)operand.getExpressionType().equals((Object)ExpressionType.TIMESERIES));
        int measurementIndex = context.getMeasurementIndex(((TimeSeriesOperand)operand).getPath().getMeasurement());
        if (regularExpression.isNot()) {
            return ValueFilterApi.notRegexp((int)measurementIndex, (Pattern)regularExpression.getPattern());
        }
        return ValueFilterApi.regexp((int)measurementIndex, (Pattern)regularExpression.getPattern());
    }

    @Override
    public Filter visitLogicNotExpression(LogicNotExpression logicNotExpression, Context context) {
        throw new IllegalArgumentException("This predicate contains a not! Did you forget to run this predicate through PredicateRemoveNotRewriter? ");
    }

    @Override
    public Filter visitLogicAndExpression(LogicAndExpression logicAndExpression, Context context) {
        return FilterFactory.and((Filter)((Filter)this.process(logicAndExpression.getLeftExpression(), context)), (Filter)((Filter)this.process(logicAndExpression.getRightExpression(), context)));
    }

    @Override
    public Filter visitLogicOrExpression(LogicOrExpression logicOrExpression, Context context) {
        return FilterFactory.or((Filter)((Filter)this.process(logicOrExpression.getLeftExpression(), context)), (Filter)((Filter)this.process(logicOrExpression.getRightExpression(), context)));
    }

    @Override
    public Filter visitEqualToExpression(EqualToExpression equalToExpression, Context context) {
        return this.processCompareBinaryExpression(equalToExpression, context);
    }

    @Override
    public Filter visitNonEqualExpression(NonEqualExpression nonEqualExpression, Context context) {
        return this.processCompareBinaryExpression(nonEqualExpression, context);
    }

    @Override
    public Filter visitGreaterThanExpression(GreaterThanExpression greaterThanExpression, Context context) {
        return this.processCompareBinaryExpression(greaterThanExpression, context);
    }

    @Override
    public Filter visitGreaterEqualExpression(GreaterEqualExpression greaterEqualExpression, Context context) {
        return this.processCompareBinaryExpression(greaterEqualExpression, context);
    }

    @Override
    public Filter visitLessThanExpression(LessThanExpression lessThanExpression, Context context) {
        return this.processCompareBinaryExpression(lessThanExpression, context);
    }

    @Override
    public Filter visitLessEqualExpression(LessEqualExpression lessEqualExpression, Context context) {
        return this.processCompareBinaryExpression(lessEqualExpression, context);
    }

    private Filter processCompareBinaryExpression(CompareBinaryExpression comparisonExpression, Context context) {
        Expression leftExpression = comparisonExpression.getLeftExpression();
        Expression rightExpression = comparisonExpression.getRightExpression();
        if (leftExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP) || rightExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
            return (Filter)timeFilterConvertor.process(comparisonExpression, null);
        }
        ExpressionType expressionType = comparisonExpression.getExpressionType();
        if (rightExpression.getExpressionType().equals((Object)ExpressionType.CONSTANT)) {
            return this.constructCompareFilter(expressionType, leftExpression, rightExpression, context);
        }
        return this.constructCompareFilter(expressionType, rightExpression, leftExpression, context);
    }

    private <T extends Comparable<T>> Filter constructCompareFilter(ExpressionType expressionType, Expression timeseriesOperand, Expression constantOperand, Context context) {
        PartialPath path = ((TimeSeriesOperand)timeseriesOperand).getPath();
        int measurementIndex = context.getMeasurementIndex(path.getMeasurement());
        T value = ConvertPredicateToFilterVisitor.getValue(((ConstantOperand)constantOperand).getValueString(), context.getType(path));
        switch (expressionType) {
            case EQUAL_TO: {
                return ValueFilterApi.eq((int)measurementIndex, value);
            }
            case NON_EQUAL: {
                return ValueFilterApi.notEq((int)measurementIndex, value);
            }
            case GREATER_THAN: {
                return ValueFilterApi.gt((int)measurementIndex, value);
            }
            case GREATER_EQUAL: {
                return ValueFilterApi.gtEq((int)measurementIndex, value);
            }
            case LESS_THAN: {
                return ValueFilterApi.lt((int)measurementIndex, value);
            }
            case LESS_EQUAL: {
                return ValueFilterApi.ltEq((int)measurementIndex, value);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported expression type %s", new Object[]{expressionType}));
    }

    @Override
    public Filter visitBetweenExpression(BetweenExpression betweenExpression, Context context) {
        Expression firstExpression = betweenExpression.getFirstExpression();
        Expression secondExpression = betweenExpression.getSecondExpression();
        Expression thirdExpression = betweenExpression.getThirdExpression();
        if (firstExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP) || secondExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP) || thirdExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
            return (Filter)timeFilterConvertor.process(betweenExpression, null);
        }
        boolean isNot = betweenExpression.isNotBetween();
        if (firstExpression.getExpressionType().equals((Object)ExpressionType.TIMESERIES)) {
            return this.constructBetweenFilter(firstExpression, secondExpression, thirdExpression, isNot, context);
        }
        if (secondExpression.getExpressionType().equals((Object)ExpressionType.TIMESERIES)) {
            return isNot ? this.constructCompareFilter(ExpressionType.GREATER_THAN, secondExpression, firstExpression, context) : this.constructCompareFilter(ExpressionType.LESS_EQUAL, secondExpression, firstExpression, context);
        }
        return isNot ? this.constructCompareFilter(ExpressionType.LESS_THAN, thirdExpression, firstExpression, context) : this.constructCompareFilter(ExpressionType.GREATER_EQUAL, thirdExpression, firstExpression, context);
    }

    private <T extends Comparable<T>> Filter constructBetweenFilter(Expression timeseriesOperand, Expression minValueConstantOperand, Expression maxValueConstantOperand, boolean isNot, Context context) {
        T maxValue;
        PartialPath path = ((TimeSeriesOperand)timeseriesOperand).getPath();
        int measurementIndex = context.getMeasurementIndex(path.getMeasurement());
        TSDataType dataType = context.getType(path);
        T minValue = ConvertPredicateToFilterVisitor.getValue(((ConstantOperand)minValueConstantOperand).getValueString(), dataType);
        if (minValue == (maxValue = ConvertPredicateToFilterVisitor.getValue(((ConstantOperand)maxValueConstantOperand).getValueString(), dataType))) {
            return isNot ? ValueFilterApi.notEq((int)measurementIndex, minValue) : ValueFilterApi.eq((int)measurementIndex, minValue);
        }
        return isNot ? ValueFilterApi.notBetween((int)measurementIndex, minValue, maxValue) : ValueFilterApi.between((int)measurementIndex, minValue, maxValue);
    }

    public static <T extends Comparable<T>> T getValue(String valueString, TSDataType dataType) {
        try {
            switch (dataType) {
                case INT32: {
                    return (T)Integer.valueOf(valueString);
                }
                case INT64: {
                    return (T)Long.valueOf(valueString);
                }
                case FLOAT: {
                    return (T)Float.valueOf(valueString);
                }
                case DOUBLE: {
                    return (T)Double.valueOf(valueString);
                }
                case BOOLEAN: {
                    if (valueString.equalsIgnoreCase("true")) {
                        return (T)Boolean.TRUE;
                    }
                    if (valueString.equalsIgnoreCase("false")) {
                        return (T)Boolean.FALSE;
                    }
                    throw new IllegalArgumentException(String.format("\"%s\" cannot be cast to [%s]", valueString, dataType));
                }
                case TEXT: {
                    return (T)new Binary(valueString, TSFileConfig.STRING_CHARSET);
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported data type %s", dataType));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("\"%s\" cannot be cast to [%s]", valueString, dataType));
        }
    }

    @Override
    public Filter visitGroupByTimeExpression(GroupByTimeExpression groupByTimeExpression, Context context) {
        throw new IllegalArgumentException("GroupByTime filter cannot exist in value filter.");
    }

    public static class Context {
        private final List<String> allMeasurements;
        private final boolean isBuildPlanUseTemplate;
        private final TypeProvider typeProvider;
        private Map<String, IMeasurementSchema> schemaMap;

        public Context(List<String> allMeasurements, boolean isBuildPlanUseTemplate, TypeProvider typeProvider) {
            this.allMeasurements = allMeasurements;
            this.isBuildPlanUseTemplate = isBuildPlanUseTemplate;
            this.typeProvider = typeProvider;
            if (isBuildPlanUseTemplate) {
                this.schemaMap = typeProvider.getTemplatedInfo().getSchemaMap();
            }
        }

        public int getMeasurementIndex(String measurement) {
            int measurementIndex = this.allMeasurements.indexOf(measurement);
            if (measurementIndex == -1) {
                throw new IllegalArgumentException(String.format("Measurement %s does not exist", measurement));
            }
            return measurementIndex;
        }

        public TSDataType getType(PartialPath path) {
            if (this.isBuildPlanUseTemplate) {
                return this.schemaMap.get(path.getFullPath()).getType();
            }
            return this.typeProvider.getType(path.getFullPath());
        }
    }
}

