/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.multi.builtin.helper;

import java.util.Map;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.multi.builtin.BuiltInScalarFunctionHelper;
import org.apache.iotdb.db.queryengine.plan.parser.ASTVisitor;
import org.apache.iotdb.db.queryengine.transformation.api.LayerPointReader;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.RoundFunctionColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.scalar.RoundFunctionTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.type.TypeFactory;

public class RoundFunctionHelper
implements BuiltInScalarFunctionHelper {
    @Override
    public void checkBuiltInScalarFunctionInputSize(FunctionExpression functionExpression) throws SemanticException {
        ASTVisitor.checkFunctionExpressionInputSize(functionExpression.getExpressionString(), functionExpression.getExpressions().size(), 1);
    }

    @Override
    public void checkBuiltInScalarFunctionInputDataType(TSDataType tsDataType) throws SemanticException {
        if (tsDataType.isNumeric()) {
            return;
        }
        throw new SemanticException("Input series of Scalar function [ROUND] only supports numeric data types [INT32, INT64, FLOAT, DOUBLE]");
    }

    @Override
    public TSDataType getBuiltInScalarFunctionReturnType(FunctionExpression functionExpression) {
        return TSDataType.DOUBLE;
    }

    @Override
    public ColumnTransformer getBuiltInScalarFunctionColumnTransformer(FunctionExpression expression, ColumnTransformer columnTransformer) {
        return new RoundFunctionColumnTransformer(TypeFactory.getType((TSDataType)this.getBuiltInScalarFunctionReturnType(expression)), columnTransformer, Integer.parseInt(expression.getFunctionAttributes().getOrDefault("PLACES", "0")));
    }

    @Override
    public Transformer getBuiltInScalarFunctionTransformer(FunctionExpression expression, LayerPointReader layerPointReader) {
        return new RoundFunctionTransformer(layerPointReader, this.getBuiltInScalarFunctionReturnType(expression), Integer.parseInt(expression.getFunctionAttributes().getOrDefault("PLACES", "0")));
    }

    @Override
    public void appendFunctionAttributes(boolean hasExpression, StringBuilder builder, Map<String, String> functionAttributes) {
        builder.append(",").append(functionAttributes.get("PLACES"));
    }
}

