/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.leaf;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ConstantOperand
extends LeafOperand {
    public static final ConstantOperand FALSE = new ConstantOperand(TSDataType.BOOLEAN, "false");
    public static final ConstantOperand TRUE = new ConstantOperand(TSDataType.BOOLEAN, "true");
    private final String valueString;
    private final TSDataType dataType;

    public ConstantOperand(TSDataType dataType, String valueString) {
        this.dataType = Objects.requireNonNull(dataType);
        this.valueString = dataType.equals((Object)TSDataType.BOOLEAN) ? Objects.requireNonNull(valueString).toLowerCase() : Objects.requireNonNull(valueString);
    }

    public ConstantOperand(ByteBuffer byteBuffer) {
        this.dataType = TSDataType.deserializeFrom((ByteBuffer)byteBuffer);
        this.valueString = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitConstantOperand(this, context);
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public String getValueString() {
        return this.valueString;
    }

    public boolean isNegativeNumber() {
        return !this.dataType.equals((Object)TSDataType.TEXT) && !this.dataType.equals((Object)TSDataType.BOOLEAN) && Double.parseDouble(this.valueString) < 0.0;
    }

    @Override
    public boolean isConstantOperandInternal() {
        return true;
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
    }

    @Override
    public String getExpressionStringInternal() {
        return this.dataType.equals((Object)TSDataType.TEXT) ? String.format("\"%s\"", this.valueString) : this.valueString;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.CONSTANT;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        this.dataType.serializeTo(byteBuffer);
        ReadWriteIOUtils.write((String)this.valueString, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        this.dataType.serializeTo(stream);
        ReadWriteIOUtils.write((String)this.valueString, (OutputStream)stream);
    }
}

