/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.KilledByOthersException;
import org.apache.iotdb.db.exception.query.QueryTimeoutRuntimeException;
import org.apache.iotdb.db.queryengine.common.DataNodeEndPoints;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.execution.QueryState;
import org.apache.iotdb.db.queryengine.execution.QueryStateMachine;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.db.queryengine.execution.exchange.source.ISourceHandle;
import org.apache.iotdb.db.queryengine.execution.exchange.source.SourceHandle;
import org.apache.iotdb.db.queryengine.metric.QueryExecutionMetricSet;
import org.apache.iotdb.db.queryengine.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.execution.memory.MemorySourceHandle;
import org.apache.iotdb.db.queryengine.plan.planner.IPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.queryengine.plan.scheduler.IScheduler;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecution
implements IQueryExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryExecution.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final int MAX_RETRY_COUNT = 3;
    private static final long RETRY_INTERVAL_IN_MS = 2000L;
    private int retryCount = 0;
    private final MPPQueryContext context;
    private IScheduler scheduler;
    private final QueryStateMachine stateMachine;
    private final IPlanner planner;
    private IAnalysis analysis;
    private LogicalQueryPlan logicalPlan;
    private DistributedQueryPlan distributedPlan;
    private ISourceHandle resultHandle;
    private final AtomicBoolean resultHandleCleanUp;
    private final AtomicBoolean stopped;
    private long totalExecutionTime = 0L;
    private static final QueryExecutionMetricSet QUERY_EXECUTION_METRIC_SET = QueryExecutionMetricSet.getInstance();
    private static final QueryPlanCostMetricSet QUERY_PLAN_COST_METRIC_SET = QueryPlanCostMetricSet.getInstance();
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();

    public QueryExecution(IPlanner planner, MPPQueryContext context, ExecutorService executor) {
        this.context = context;
        this.planner = planner;
        this.analysis = this.analyze(context);
        this.stateMachine = new QueryStateMachine(context.getQueryId(), executor);
        this.stateMachine.addStateChangeListener(state -> {
            try (SetThreadName queryName = new SetThreadName(context.getQueryId().getId());){
                if (!state.isDone()) {
                    return;
                }
                if (state == QueryState.FAILED || state == QueryState.ABORTED || state == QueryState.CANCELED) {
                    LOGGER.debug("[ReleaseQueryResource] state is: {}", (Object)state);
                    Throwable cause = this.stateMachine.getFailureException();
                    this.releaseResource(cause);
                }
                this.stop(null);
            }
        });
        this.stopped = new AtomicBoolean(false);
        this.resultHandleCleanUp = new AtomicBoolean(false);
    }

    @Override
    public void start() {
        long startTime = System.nanoTime();
        if (this.skipExecute()) {
            LOGGER.debug("[SkipExecute]");
            if (this.context.getQueryType() == QueryType.WRITE && this.analysis.isFailed()) {
                this.stateMachine.transitionToFailed(this.analysis.getFailStatus());
            } else {
                this.constructResultForMemorySource();
                this.stateMachine.transitionToRunning();
            }
            return;
        }
        this.checkTimeOutForQuery();
        this.doLogicalPlan();
        this.doDistributedPlan();
        this.context.setTimeOut(this.context.getTimeOut() - (System.currentTimeMillis() - this.context.getStartTime()));
        this.stateMachine.transitionToPlanned();
        if (this.context.getQueryType() == QueryType.READ) {
            this.initResultHandle();
        }
        PERFORMANCE_OVERVIEW_METRICS.recordPlanCost(System.nanoTime() - startTime);
        this.schedule();
        this.logicalPlan.clearUselessMemory();
        if (this.context.getQueryType() == QueryType.WRITE && this.analysis.isFailed()) {
            this.stateMachine.transitionToFailed(this.analysis.getFailStatus());
        }
    }

    private void checkTimeOutForQuery() {
        long currentTime;
        if (this.isQuery() && (currentTime = System.currentTimeMillis()) - this.context.getStartTime() >= this.context.getTimeOut()) {
            throw new QueryTimeoutRuntimeException(this.context.getStartTime(), currentTime, this.context.getTimeOut());
        }
    }

    private ExecutionResult retry() {
        if (this.retryCount >= 3) {
            LOGGER.warn("[ReachMaxRetryCount]");
            this.stateMachine.transitionToFailed();
            return this.getStatus();
        }
        LOGGER.warn("error when executing query. {}", (Object)this.stateMachine.getFailureMessage());
        this.stopAndCleanup(this.stateMachine.getFailureException());
        LOGGER.info("[WaitBeforeRetry] wait {}ms.", (Object)2000L);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            LOGGER.warn("interrupted when waiting retry");
            Thread.currentThread().interrupt();
        }
        ++this.retryCount;
        LOGGER.info("[Retry] retry count is: {}", (Object)this.retryCount);
        this.stateMachine.transitionToQueued();
        this.planner.invalidatePartitionCache();
        this.context.prepareForRetry();
        this.stopped.compareAndSet(true, false);
        this.resultHandleCleanUp.compareAndSet(true, false);
        this.analysis = this.analyze(this.context);
        this.start();
        return this.getStatus();
    }

    private boolean skipExecute() {
        return this.analysis.canSkipExecute(this.context);
    }

    private void constructResultForMemorySource() {
        TsBlock tsBlock = this.analysis.constructResultForMemorySource(this.context);
        this.resultHandle = new MemorySourceHandle(tsBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAnalysis analyze(MPPQueryContext context) {
        IAnalysis result;
        long startTime = System.nanoTime();
        try {
            result = this.planner.analyze(context);
        }
        finally {
            long analyzeCost = System.nanoTime() - startTime;
            context.setAnalyzeCost(analyzeCost);
            PERFORMANCE_OVERVIEW_METRICS.recordAnalyzeCost(analyzeCost);
        }
        return result;
    }

    private void schedule() {
        long startTime = System.nanoTime();
        this.scheduler = this.planner.doSchedule(this.analysis, this.distributedPlan, this.context, this.stateMachine);
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleCost(System.nanoTime() - startTime);
    }

    public void doLogicalPlan() {
        this.logicalPlan = this.planner.doLogicalPlan(this.analysis, this.context);
        if (this.isQuery() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("logical plan is: \n {}", (Object)PlanNodeUtil.nodeToString(this.logicalPlan.getRootNode()));
        }
        this.checkTimeOutForQuery();
    }

    public void doDistributedPlan() {
        long startTime = System.nanoTime();
        this.distributedPlan = this.planner.doDistributionPlan(this.analysis, this.logicalPlan);
        if (this.analysis.isQuery()) {
            long distributionPlanCost = System.nanoTime() - startTime;
            this.context.setDistributionPlanCost(distributionPlanCost);
            QUERY_PLAN_COST_METRIC_SET.recordPlanCost("distribution_planner", distributionPlanCost);
        }
        if (this.analysis.needSetHighestPriority()) {
            this.distributedPlan.getInstances().forEach(instance -> instance.setHighestPriority(true));
        }
        if (this.isQuery() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("distribution plan done. Fragment instance count is {}, details is: \n {}", (Object)this.distributedPlan.getInstances().size(), (Object)this.printFragmentInstances(this.distributedPlan.getInstances()));
        }
        this.checkTimeOutForQuery();
    }

    private String printFragmentInstances(List<FragmentInstance> instances) {
        StringBuilder ret = new StringBuilder();
        for (FragmentInstance instance : instances) {
            ret.append(System.lineSeparator()).append(instance);
        }
        return ret.toString();
    }

    @Override
    public void stop(Throwable t) {
        if (this.stopped.compareAndSet(false, true) && this.scheduler != null) {
            this.scheduler.stop(t);
        }
    }

    @Override
    public void stopAndCleanup() {
        this.stop(null);
        this.releaseResource();
    }

    @Override
    public void cancel() {
        this.stateMachine.transitionToCanceled((Throwable)((Object)new KilledByOthersException()), new TSStatus(TSStatusCode.QUERY_WAS_KILLED.getStatusCode()).setMessage("Query was killed by others"));
    }

    private void releaseResource() {
        if (this.resultHandle != null) {
            this.resultHandle.close();
            this.cleanUpResultHandle();
        }
    }

    private void cleanUpResultHandle() {
        if (this.resultHandleCleanUp.compareAndSet(false, true) && this.resultHandle instanceof SourceHandle) {
            TFragmentInstanceId fragmentInstanceId = this.resultHandle.getLocalFragmentInstanceId();
            MPPDataExchangeService.getInstance().getMPPDataExchangeManager().deRegisterFragmentInstanceFromMemoryPool(fragmentInstanceId.queryId, FragmentInstanceId.createFragmentInstanceIdFromTFragmentInstanceId(fragmentInstanceId), true);
        }
    }

    @Override
    public void stopAndCleanup(Throwable t) {
        this.stop(t);
        this.releaseResource(t);
    }

    private void releaseResource(Throwable t) {
        if (this.resultHandle != null) {
            if (t != null) {
                this.resultHandle.abort(t);
            } else {
                this.resultHandle.close();
            }
            this.cleanUpResultHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Optional<T> getResult(ISourceHandleSupplier<T> dataSupplier) throws IoTDBException {
        Preconditions.checkArgument((this.resultHandle != null ? 1 : 0) != 0, (Object)"ResultHandle in Coordinator should be init firstly.");
        while (true) {
            try {
                block13: {
                    T res;
                    do {
                        if (this.resultHandle.isAborted()) {
                            LOGGER.warn("[ResultHandleAborted]");
                            this.stateMachine.transitionToAborted();
                            if (this.stateMachine.getFailureStatus() != null) {
                                throw new IoTDBException(this.stateMachine.getFailureStatus().getMessage(), this.stateMachine.getFailureStatus().code);
                            }
                            throw new IoTDBException(this.stateMachine.getFailureMessage(), TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
                        }
                        if (this.resultHandle.isFinished()) {
                            LOGGER.debug("[ResultHandleFinished]");
                            this.stateMachine.transitionToFinished();
                            return Optional.empty();
                        }
                        long startTime = System.nanoTime();
                        try {
                            ListenableFuture<?> blocked = this.resultHandle.isBlocked();
                            blocked.get();
                        }
                        finally {
                            QUERY_EXECUTION_METRIC_SET.recordExecutionCost("wait_for_result", System.nanoTime() - startTime);
                        }
                        if (this.resultHandle.isFinished()) break block13;
                    } while ((res = dataSupplier.get()) == null);
                    return Optional.of(res);
                }
                return Optional.empty();
            }
            catch (CancellationException | ExecutionException e) {
                this.dealWithException(e.getCause() != null ? e.getCause() : e);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.dealWithException(e);
                continue;
            }
            catch (Throwable t) {
                this.dealWithException(t);
                continue;
            }
            break;
        }
    }

    private void dealWithException(Throwable t) throws IoTDBException {
        this.stateMachine.transitionToFailed(t);
        if (this.stateMachine.getFailureStatus() != null) {
            throw new IoTDBException(this.stateMachine.getFailureStatus().getMessage(), this.stateMachine.getFailureStatus().code);
        }
        if (this.stateMachine.getFailureException() != null) {
            Throwable rootCause = this.stateMachine.getFailureException();
            throw new IoTDBException(rootCause, TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
        }
        Throwables.throwIfUnchecked((Throwable)t);
        throw new IoTDBException(t, TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode());
    }

    @Override
    public Optional<TsBlock> getBatchResult() throws IoTDBException {
        return this.getResult(this::getDeserializedTsBlock);
    }

    private TsBlock getDeserializedTsBlock() {
        return this.resultHandle.receive();
    }

    @Override
    public Optional<ByteBuffer> getByteBufferBatchResult() throws IoTDBException {
        return this.getResult(this::getSerializedTsBlock);
    }

    private ByteBuffer getSerializedTsBlock() throws IoTDBException {
        return this.resultHandle.getSerializedTsBlock();
    }

    @Override
    public boolean hasNextResult() {
        return this.resultHandle != null && !this.resultHandle.isFinished();
    }

    @Override
    public int getOutputValueColumnCount() {
        return this.analysis.getRespDatasetHeader().getOutputValueColumnCount();
    }

    @Override
    public DatasetHeader getDatasetHeader() {
        return this.analysis.getRespDatasetHeader();
    }

    @Override
    public ExecutionResult getStatus() {
        try {
            if (this.stateMachine.getState() == QueryState.FINISHED) {
                return this.getExecutionResult(QueryState.FINISHED);
            }
            SettableFuture future = SettableFuture.create();
            this.stateMachine.addStateChangeListener(state -> {
                if (state == QueryState.RUNNING || state.isDone() || state == QueryState.PENDING_RETRY) {
                    future.set((Object)state);
                }
            });
            QueryState state2 = (QueryState)((Object)future.get());
            if (state2 == QueryState.PENDING_RETRY) {
                return this.retry();
            }
            return this.getExecutionResult(state2);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new ExecutionResult(this.context.getQueryId(), this.stateMachine.getFailureStatus() == null ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)this.stateMachine.getFailureMessage()) : this.stateMachine.getFailureStatus());
        }
        catch (ExecutionException e) {
            return new ExecutionResult(this.context.getQueryId(), this.stateMachine.getFailureStatus() == null ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)this.stateMachine.getFailureMessage()) : this.stateMachine.getFailureStatus());
        }
    }

    private void initResultHandle() {
        TEndPoint upstreamEndPoint = this.context.getResultNodeContext().getUpStreamEndpoint();
        this.resultHandle = DataNodeEndPoints.isSameNode(upstreamEndPoint) ? MPPDataExchangeService.getInstance().getMPPDataExchangeManager().createLocalSourceHandleForFragment(this.context.getResultNodeContext().getVirtualFragmentInstanceId().toThrift(), this.context.getResultNodeContext().getVirtualResultNodeId().getId(), this.context.getResultNodeContext().getUpStreamPlanNodeId().getId(), this.context.getResultNodeContext().getUpStreamFragmentInstanceId().toThrift(), 0, this.stateMachine::transitionToFailed) : MPPDataExchangeService.getInstance().getMPPDataExchangeManager().createSourceHandle(this.context.getResultNodeContext().getVirtualFragmentInstanceId().toThrift(), this.context.getResultNodeContext().getVirtualResultNodeId().getId(), 0, upstreamEndPoint, this.context.getResultNodeContext().getUpStreamFragmentInstanceId().toThrift(), this.stateMachine::transitionToFailed);
    }

    private ExecutionResult getExecutionResult(QueryState state) {
        TSStatusCode statusCode = this.context.getQueryType() == QueryType.WRITE && this.analysis.isFailed() ? (state == QueryState.FINISHED ? TSStatusCode.SUCCESS_STATUS : TSStatusCode.WRITE_PROCESS_ERROR) : (state == QueryState.FINISHED || state == QueryState.RUNNING ? TSStatusCode.SUCCESS_STATUS : TSStatusCode.EXECUTE_STATEMENT_ERROR);
        TSStatus tsstatus = RpcUtils.getStatus((TSStatusCode)statusCode, (String)(statusCode == TSStatusCode.SUCCESS_STATUS ? "" : this.stateMachine.getFailureMessage()));
        if (state.isDone() && this.stateMachine.getFailureStatus() != null) {
            tsstatus = this.stateMachine.getFailureStatus();
        }
        if (!CONFIG.isEnable13DataInsertAdapt() || IoTDBConstant.ClientVersion.V_1_0.equals((Object)this.context.getSession().getVersion())) {
            this.planner.setRedirectInfo(this.analysis, CONFIG.getAddressAndPort(), tsstatus, statusCode);
        }
        return new ExecutionResult(this.context.getQueryId(), tsstatus);
    }

    public DistributedQueryPlan getDistributedPlan() {
        return this.distributedPlan;
    }

    @Override
    public boolean isQuery() {
        return this.context.getQueryType() == QueryType.READ;
    }

    @Override
    public String getQueryId() {
        return this.context.getQueryId().getId();
    }

    @Override
    public long getStartExecutionTime() {
        return this.context.getStartTime();
    }

    @Override
    public void recordExecutionTime(long executionTime) {
        this.totalExecutionTime += executionTime;
    }

    @Override
    public long getTotalExecutionTime() {
        return this.totalExecutionTime;
    }

    @Override
    public Optional<String> getExecuteSQL() {
        return Optional.ofNullable(this.context.getSql());
    }

    @Override
    public String getStatementType() {
        return this.analysis.getStatementType();
    }

    public MPPQueryContext getContext() {
        return this.context;
    }

    public String toString() {
        return String.format("QueryExecution[%s]", this.context.getQueryId());
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.planner.getScheduledExecutorService();
    }

    @FunctionalInterface
    static interface ISourceHandleSupplier<T> {
        public T get() throws IoTDBException;
    }
}

