/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window;

import org.apache.iotdb.db.queryengine.execution.operator.window.IWindow;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public class TimeWindow
implements IWindow {
    private TimeRange curTimeRange;

    public TimeWindow(TimeRange curTimeRange) {
        this.curTimeRange = curTimeRange;
    }

    public TimeRange getCurTimeRange() {
        return this.curTimeRange;
    }

    public long getCurMinTime() {
        return this.curTimeRange.getMin();
    }

    public long getCurMaxTime() {
        return this.curTimeRange.getMax();
    }

    @Override
    public Column getControlColumn(TsBlock tsBlock) {
        return tsBlock.getTimeColumn();
    }

    @Override
    public boolean satisfy(Column column, int index) {
        long curTime = column.getLong(index);
        return curTime <= this.getCurMaxTime() && curTime >= this.getCurMinTime();
    }

    @Override
    public void mergeOnePoint(Column[] controlTimeAndValueColumn, int index) {
    }

    @Override
    public boolean contains(Column column) {
        TimeColumn timeColumn = (TimeColumn)column;
        long minTime = Math.min(timeColumn.getStartTime(), timeColumn.getEndTime());
        long maxTime = Math.max(timeColumn.getStartTime(), timeColumn.getEndTime());
        return this.curTimeRange.contains(minTime, maxTime);
    }

    public void update(TimeRange curTimeRange) {
        this.curTimeRange = curTimeRange;
    }
}

