/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractSeriesScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;

public class SeriesScanOperator
extends AbstractSeriesScanOperator {
    public SeriesScanOperator(OperatorContext context, PlanNodeId sourceId, PartialPath seriesPath, Ordering scanOrder, SeriesScanOptions seriesScanOptions) {
        this.sourceId = sourceId;
        this.operatorContext = context;
        this.seriesScanUtil = new SeriesScanUtil(seriesPath, scanOrder, seriesScanOptions, context.getInstanceContext());
        this.maxReturnSize = Math.min(this.maxReturnSize, (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte());
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(this.maxReturnSize, (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() * 3L);
    }

    @Override
    protected void buildResult(TsBlock tsBlock) {
        int size = tsBlock.getPositionCount();
        TimeColumnBuilder timeColumnBuilder = this.resultTsBlockBuilder.getTimeColumnBuilder();
        TimeColumn timeColumn = tsBlock.getTimeColumn();
        ColumnBuilder columnBuilder = this.resultTsBlockBuilder.getColumnBuilder(0);
        Column column = tsBlock.getColumn(0);
        if (column.mayHaveNull()) {
            for (int i = 0; i < size; ++i) {
                timeColumnBuilder.writeLong(timeColumn.getLong(i));
                if (column.isNull(i)) {
                    columnBuilder.appendNull();
                } else {
                    columnBuilder.write(column, i);
                }
                this.resultTsBlockBuilder.declarePosition();
            }
        } else {
            for (int i = 0; i < size; ++i) {
                timeColumnBuilder.writeLong(timeColumn.getLong(i));
                columnBuilder.write(column, i);
                this.resultTsBlockBuilder.declarePosition();
            }
        }
    }
}

