/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema.source;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.runtime.SchemaExecutionException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterFactory;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.ViewType;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.SchemaRegionReadPlanFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class LogicalViewSchemaSource
implements ISchemaSource<ITimeSeriesSchemaInfo> {
    private final PartialPath pathPattern;
    private final PathPatternTree scope;
    private final long limit;
    private final long offset;
    private final SchemaFilter schemaFilter;

    LogicalViewSchemaSource(PartialPath pathPattern, long limit, long offset, SchemaFilter schemaFilter, PathPatternTree scope) {
        this.pathPattern = pathPattern;
        this.scope = scope;
        this.limit = limit;
        this.offset = offset;
        this.schemaFilter = schemaFilter;
    }

    @Override
    public ISchemaReader<ITimeSeriesSchemaInfo> getSchemaReader(ISchemaRegion schemaRegion) {
        try {
            return schemaRegion.getTimeSeriesReader(SchemaRegionReadPlanFactory.getShowTimeSeriesPlan(this.pathPattern, Collections.emptyMap(), this.limit, this.offset, false, SchemaFilterFactory.and((SchemaFilter)this.schemaFilter, (SchemaFilter)SchemaFilterFactory.createViewTypeFilter((ViewType)ViewType.VIEW)), true, this.scope));
        }
        catch (MetadataException e) {
            throw new SchemaExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<ColumnHeader> getInfoQueryColumnHeaders() {
        return ColumnHeaderConstant.showLogicalViewColumnHeaders;
    }

    @Override
    public void transformToTsBlockColumns(ITimeSeriesSchemaInfo series, TsBlockBuilder builder, String database) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.writeNullableText(0, series.getFullPath());
        builder.writeNullableText(1, database);
        builder.writeNullableText(2, series.getSchema().getType().toString());
        builder.writeNullableText(3, this.mapToString(series.getTags()));
        builder.writeNullableText(4, this.mapToString(series.getAttributes()));
        builder.writeNullableText(5, ViewType.VIEW.name());
        builder.writeNullableText(6, ((LogicalViewSchema)series.getSchema()).getExpression().toString());
        builder.declarePosition();
    }

    @Override
    public boolean hasSchemaStatistic(ISchemaRegion schemaRegion) {
        return false;
    }

    @Override
    public long getSchemaStatistic(ISchemaRegion schemaRegion) {
        return 0L;
    }

    private String mapToString(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        String content = map.entrySet().stream().map(e -> "\"" + (String)e.getKey() + "\":\"" + (String)e.getValue() + "\"").collect(Collectors.joining(","));
        return "{" + content + "}";
    }
}

