/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.last;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class LastQueryTransformOperator
implements ProcessOperator {
    private String viewPath;
    private String dataType;
    private final OperatorContext operatorContext;
    private final Operator child;
    private TsBlockBuilder tsBlockBuilder;

    public LastQueryTransformOperator(String viewPath, String dataType, OperatorContext operatorContext, Operator child) {
        this.viewPath = viewPath;
        this.dataType = dataType;
        this.operatorContext = operatorContext;
        this.child = child;
        this.tsBlockBuilder = LastQueryUtil.createTsBlockBuilder(1);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.tsBlockBuilder.isFull()) {
            TsBlock tsBlock = this.child.nextWithTimer();
            if (tsBlock == null) {
                return null;
            }
            if (!tsBlock.isEmpty()) {
                if (tsBlock.getColumn(1).isNull(0)) {
                    return null;
                }
                LastQueryUtil.appendLastValue(this.tsBlockBuilder, tsBlock.getColumn(0).getLong(0), this.viewPath, tsBlock.getColumn(1).getTsPrimitiveType(0).getStringValue(), this.dataType);
            }
        } else {
            this.child.close();
        }
        TsBlock res = this.tsBlockBuilder.build();
        this.tsBlockBuilder.reset();
        return res;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNext();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(this.child.calculateMaxPeekMemory(), this.child.calculateRetainedSizeAfterCallingNext());
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public void close() throws Exception {
        if (this.child != null) {
            this.child.close();
        }
        this.tsBlockBuilder = null;
    }
}

