/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.last;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.driver.DataDriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.DataNodeQueryContext;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeSchemaCache;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public abstract class AbstractUpdateLastCacheOperator
implements ProcessOperator {
    protected static final TsBlock LAST_QUERY_EMPTY_TSBLOCK = new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.TEXT, (Object)TSDataType.TEXT, (Object)TSDataType.TEXT)).build();
    protected OperatorContext operatorContext;
    protected final DataNodeQueryContext dataNodeQueryContext;
    protected Operator child;
    protected DataNodeSchemaCache lastCache;
    protected final boolean needUpdateCache;
    protected final boolean needUpdateNullEntry;
    protected TsBlockBuilder tsBlockBuilder;
    protected String databaseName;

    protected AbstractUpdateLastCacheOperator(OperatorContext operatorContext, Operator child, DataNodeSchemaCache dataNodeSchemaCache, boolean needUpdateCache, boolean needUpdateNullEntry) {
        this.operatorContext = operatorContext;
        this.child = child;
        this.lastCache = dataNodeSchemaCache;
        this.needUpdateCache = needUpdateCache;
        this.needUpdateNullEntry = needUpdateNullEntry;
        this.tsBlockBuilder = LastQueryUtil.createTsBlockBuilder(1);
        this.dataNodeQueryContext = operatorContext.getDriverContext().getFragmentInstanceContext().getDataNodeQueryContext();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    protected String getDatabaseName() {
        if (this.databaseName == null) {
            this.databaseName = ((DataDriverContext)this.operatorContext.getDriverContext()).getDataRegion().getDatabaseName();
        }
        return this.databaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mayUpdateLastCache(long time, @Nullable TsPrimitiveType value, MeasurementPath fullPath) {
        if (!this.needUpdateCache) {
            return;
        }
        try {
            this.dataNodeQueryContext.lock();
            Pair<AtomicInteger, TimeValuePair> seriesScanInfo = this.dataNodeQueryContext.getSeriesScanInfo((PartialPath)fullPath);
            if (seriesScanInfo == null) {
                return;
            }
            if (seriesScanInfo.right == null || time > ((TimeValuePair)seriesScanInfo.right).getTimestamp()) {
                seriesScanInfo.right = new TimeValuePair(time, value);
            }
            if (((AtomicInteger)seriesScanInfo.left).decrementAndGet() == 0) {
                this.lastCache.updateLastCache(this.getDatabaseName(), fullPath, (TimeValuePair)seriesScanInfo.right, false, (Long)Long.MIN_VALUE);
            }
        }
        finally {
            this.dataNodeQueryContext.unLock();
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNextWithTimer();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.child.isFinished();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemory();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }
}

