/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.load;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.queryengine.execution.load.ChunkData;
import org.apache.iotdb.db.queryengine.execution.load.DeletionData;
import org.apache.iotdb.db.queryengine.execution.load.TsFileData;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadTsFilePieceNode;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.flush.MemTableFlushTask;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileManager.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final String MESSAGE_WRITER_MANAGER_HAS_BEEN_CLOSED = "%s TsFileWriterManager has been closed.";
    private static final String MESSAGE_DELETE_FAIL = "failed to delete {}.";
    private final File loadDir;
    private final Map<String, TsFileWriterManager> uuid2WriterManager = new ConcurrentHashMap<String, TsFileWriterManager>();
    private final Map<String, CleanupTask> uuid2CleanupTask = new ConcurrentHashMap<String, CleanupTask>();
    private final PriorityBlockingQueue<CleanupTask> cleanupTaskQueue = new PriorityBlockingQueue();

    public LoadTsFileManager() {
        this.loadDir = SystemFileFactory.INSTANCE.getFile(CONFIG.getLoadTsFileDir());
        this.registerCleanupTaskExecutor();
        this.recover();
    }

    private void registerCleanupTaskExecutor() {
        PipeAgent.runtime().registerPeriodicalJob("LoadTsFileManager#cleanupTasks", this::cleanupTasks, CONFIG.getLoadCleanupTaskExecutionDelayTimeSeconds() >> 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupTasks() {
        while (!this.cleanupTaskQueue.isEmpty()) {
            Map<String, CleanupTask> map = this.uuid2CleanupTask;
            synchronized (map) {
                if (this.cleanupTaskQueue.isEmpty()) {
                    continue;
                }
                CleanupTask cleanupTask = this.cleanupTaskQueue.peek();
                if (cleanupTask.scheduledTime <= System.currentTimeMillis()) {
                    if (cleanupTask.isLoadTaskRunning) {
                        this.cleanupTaskQueue.poll();
                        cleanupTask.resetScheduledTime();
                        this.cleanupTaskQueue.add(cleanupTask);
                        continue;
                    }
                } else {
                    long waitTimeInMs = cleanupTask.scheduledTime - System.currentTimeMillis();
                    LOGGER.info("Next load cleanup task {} is not ready to run, wait for at least {} ms ({}s).", new Object[]{cleanupTask.uuid, waitTimeInMs, (double)waitTimeInMs / 1000.0});
                    return;
                }
                cleanupTask.run();
                this.uuid2CleanupTask.remove(cleanupTask.uuid);
                this.cleanupTaskQueue.poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover() {
        if (!this.loadDir.exists()) {
            return;
        }
        File[] files = this.loadDir.listFiles();
        if (files == null) {
            return;
        }
        for (File taskDir : files) {
            String uuid = taskDir.getName();
            TsFileWriterManager writerManager = new TsFileWriterManager(taskDir);
            this.uuid2WriterManager.put(uuid, writerManager);
            writerManager.close();
            Map<String, CleanupTask> map = this.uuid2CleanupTask;
            synchronized (map) {
                CleanupTask cleanupTask = new CleanupTask(uuid, CONFIG.getLoadCleanupTaskExecutionDelayTimeSeconds() * 1000L);
                this.uuid2CleanupTask.put(uuid, cleanupTask);
                this.cleanupTaskQueue.add(cleanupTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDataRegion(DataRegion dataRegion, LoadTsFilePieceNode pieceNode, String uuid) throws IOException {
        if (!this.uuid2WriterManager.containsKey(uuid)) {
            Map<String, CleanupTask> map = this.uuid2CleanupTask;
            synchronized (map) {
                CleanupTask cleanupTask = new CleanupTask(uuid, CONFIG.getLoadCleanupTaskExecutionDelayTimeSeconds() * 1000L);
                this.uuid2CleanupTask.put(uuid, cleanupTask);
                this.cleanupTaskQueue.add(cleanupTask);
            }
        }
        Optional<CleanupTask> cleanupTask = Optional.of(this.uuid2CleanupTask.get(uuid));
        cleanupTask.ifPresent(CleanupTask::markLoadTaskRunning);
        try {
            TsFileWriterManager writerManager = this.uuid2WriterManager.computeIfAbsent(uuid, o -> new TsFileWriterManager(SystemFileFactory.INSTANCE.getFile(this.loadDir, uuid)));
            for (TsFileData tsFileData : pieceNode.getAllTsFileData()) {
                if (!tsFileData.isModification()) {
                    ChunkData chunkData = (ChunkData)tsFileData;
                    writerManager.write(new DataPartitionInfo(dataRegion, chunkData.getTimePartitionSlot()), chunkData);
                    continue;
                }
                writerManager.writeDeletion(dataRegion, (DeletionData)tsFileData);
            }
        }
        finally {
            cleanupTask.ifPresent(CleanupTask::markLoadTaskNotRunning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadAll(String uuid, boolean isGeneratedByPipe, ProgressIndex progressIndex) throws IOException, LoadFileException {
        if (!this.uuid2WriterManager.containsKey(uuid)) {
            return false;
        }
        Optional<CleanupTask> cleanupTask = Optional.of(this.uuid2CleanupTask.get(uuid));
        cleanupTask.ifPresent(CleanupTask::markLoadTaskRunning);
        try {
            this.uuid2WriterManager.get(uuid).loadAll(isGeneratedByPipe, progressIndex);
        }
        finally {
            cleanupTask.ifPresent(CleanupTask::markLoadTaskNotRunning);
        }
        this.clean(uuid);
        return true;
    }

    public boolean deleteAll(String uuid) {
        if (!this.uuid2WriterManager.containsKey(uuid)) {
            return false;
        }
        this.clean(uuid);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean(String uuid) {
        Map<String, CleanupTask> map = this.uuid2CleanupTask;
        synchronized (map) {
            CleanupTask cleanupTask = this.uuid2CleanupTask.get(uuid);
            if (cleanupTask != null) {
                cleanupTask.cancel();
            }
        }
        this.forceCloseWriterManager(uuid);
    }

    private void forceCloseWriterManager(String uuid) {
        Path loadDirPath;
        TsFileWriterManager writerManager = this.uuid2WriterManager.remove(uuid);
        if (Objects.nonNull(writerManager)) {
            writerManager.close();
        }
        if (!Files.exists(loadDirPath = this.loadDir.toPath(), new LinkOption[0])) {
            return;
        }
        try {
            Files.deleteIfExists(loadDirPath);
            LOGGER.info("Load dir {} was deleted.", (Object)loadDirPath);
        }
        catch (DirectoryNotEmptyException e) {
            LOGGER.info("Load dir {} is not empty, skip deleting.", (Object)loadDirPath);
        }
        catch (IOException e) {
            LOGGER.info(MESSAGE_DELETE_FAIL, (Object)loadDirPath);
        }
    }

    private static class DataPartitionInfo {
        private final DataRegion dataRegion;
        private final TTimePartitionSlot timePartitionSlot;

        private DataPartitionInfo(DataRegion dataRegion, TTimePartitionSlot timePartitionSlot) {
            this.dataRegion = dataRegion;
            this.timePartitionSlot = timePartitionSlot;
        }

        public DataRegion getDataRegion() {
            return this.dataRegion;
        }

        public String toString() {
            return String.join((CharSequence)"-", this.dataRegion.getDatabaseName(), this.dataRegion.getDataRegionId(), Long.toString(this.timePartitionSlot.getStartTime()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataPartitionInfo that = (DataPartitionInfo)o;
            return Objects.equals(this.dataRegion, that.dataRegion) && this.timePartitionSlot.getStartTime() == that.timePartitionSlot.getStartTime();
        }

        public int hashCode() {
            return Objects.hash(this.dataRegion, this.timePartitionSlot.getStartTime());
        }
    }

    private class CleanupTask
    implements Runnable,
    Comparable<CleanupTask> {
        private final String uuid;
        private final long delayInMs;
        private long scheduledTime;
        private volatile boolean isLoadTaskRunning = false;
        private volatile boolean isCanceled = false;

        private CleanupTask(String uuid, long delayInMs) {
            this.uuid = uuid;
            this.delayInMs = delayInMs;
            this.resetScheduledTime();
        }

        public void markLoadTaskRunning() {
            this.isLoadTaskRunning = true;
            this.resetScheduledTime();
        }

        public void markLoadTaskNotRunning() {
            this.isLoadTaskRunning = false;
            this.resetScheduledTime();
        }

        public void resetScheduledTime() {
            this.scheduledTime = System.currentTimeMillis() + this.delayInMs;
        }

        public void cancel() {
            this.isCanceled = true;
        }

        @Override
        public void run() {
            if (this.isCanceled) {
                LOGGER.info("Load cleanup task {} is canceled.", (Object)this.uuid);
            } else {
                LOGGER.info("Load cleanup task {} starts.", (Object)this.uuid);
                try {
                    LoadTsFileManager.this.forceCloseWriterManager(this.uuid);
                }
                catch (Exception e) {
                    LOGGER.warn("Load cleanup task {} error.", (Object)this.uuid, (Object)e);
                }
            }
        }

        @Override
        public int compareTo(CleanupTask that) {
            return Long.compare(this.scheduledTime, that.scheduledTime);
        }
    }

    private static class TsFileWriterManager {
        private final File taskDir;
        private Map<DataPartitionInfo, TsFileIOWriter> dataPartition2Writer;
        private Map<DataPartitionInfo, String> dataPartition2LastDevice;
        private Map<DataPartitionInfo, ModificationFile> dataPartition2ModificationFile;
        private boolean isClosed;

        private TsFileWriterManager(File taskDir) {
            this.taskDir = taskDir;
            this.dataPartition2Writer = new HashMap<DataPartitionInfo, TsFileIOWriter>();
            this.dataPartition2LastDevice = new HashMap<DataPartitionInfo, String>();
            this.dataPartition2ModificationFile = new HashMap<DataPartitionInfo, ModificationFile>();
            this.isClosed = false;
            this.clearDir(taskDir);
        }

        private void clearDir(File dir) {
            if (dir.exists()) {
                FileUtils.deleteFileOrDirectory((File)dir);
            }
            if (dir.mkdirs()) {
                LOGGER.info("Load TsFile dir {} is created.", (Object)dir.getPath());
            }
        }

        private void write(DataPartitionInfo partitionInfo, ChunkData chunkData) throws IOException {
            if (this.isClosed) {
                throw new IOException(String.format(LoadTsFileManager.MESSAGE_WRITER_MANAGER_HAS_BEEN_CLOSED, this.taskDir));
            }
            if (!this.dataPartition2Writer.containsKey(partitionInfo)) {
                File newTsFile = SystemFileFactory.INSTANCE.getFile(this.taskDir, partitionInfo.toString() + ".tsfile");
                if (!newTsFile.createNewFile()) {
                    LOGGER.error("Can not create TsFile {} for writing.", (Object)newTsFile.getPath());
                    return;
                }
                this.dataPartition2Writer.put(partitionInfo, new TsFileIOWriter(newTsFile));
            }
            TsFileIOWriter writer = this.dataPartition2Writer.get(partitionInfo);
            if (!chunkData.getDevice().equals(this.dataPartition2LastDevice.getOrDefault(partitionInfo, ""))) {
                if (this.dataPartition2LastDevice.containsKey(partitionInfo)) {
                    writer.endChunkGroup();
                }
                writer.startChunkGroup((IDeviceID)new PlainDeviceID(chunkData.getDevice()));
                this.dataPartition2LastDevice.put(partitionInfo, chunkData.getDevice());
            }
            chunkData.writeToFileWriter(writer);
        }

        private void writeDeletion(DataRegion dataRegion, DeletionData deletionData) throws IOException {
            if (this.isClosed) {
                throw new IOException(String.format(LoadTsFileManager.MESSAGE_WRITER_MANAGER_HAS_BEEN_CLOSED, this.taskDir));
            }
            for (Map.Entry<DataPartitionInfo, TsFileIOWriter> entry : this.dataPartition2Writer.entrySet()) {
                DataPartitionInfo partitionInfo = entry.getKey();
                if (!partitionInfo.getDataRegion().equals(dataRegion)) continue;
                TsFileIOWriter writer = entry.getValue();
                if (!this.dataPartition2ModificationFile.containsKey(partitionInfo)) {
                    File newModificationFile = SystemFileFactory.INSTANCE.getFile(writer.getFile().getAbsolutePath() + ".mods");
                    if (!newModificationFile.createNewFile()) {
                        LOGGER.error("Can not create ModificationFile {} for writing.", (Object)newModificationFile.getPath());
                        return;
                    }
                    this.dataPartition2ModificationFile.put(partitionInfo, new ModificationFile(newModificationFile.getAbsolutePath()));
                }
                ModificationFile modificationFile = this.dataPartition2ModificationFile.get(partitionInfo);
                writer.flush();
                deletionData.writeToModificationFile(modificationFile, writer.getFile().length());
            }
        }

        private void loadAll(boolean isGeneratedByPipe, ProgressIndex progressIndex) throws IOException, LoadFileException {
            if (this.isClosed) {
                throw new IOException(String.format(LoadTsFileManager.MESSAGE_WRITER_MANAGER_HAS_BEEN_CLOSED, this.taskDir));
            }
            for (Map.Entry<DataPartitionInfo, ModificationFile> entry : this.dataPartition2ModificationFile.entrySet()) {
                entry.getValue().close();
            }
            for (Map.Entry<DataPartitionInfo, ModificationFile> entry : this.dataPartition2Writer.entrySet()) {
                TsFileIOWriter writer = (TsFileIOWriter)entry.getValue();
                if (writer.isWritingChunkGroup()) {
                    writer.endChunkGroup();
                }
                writer.endFile();
                DataRegion dataRegion = entry.getKey().getDataRegion();
                dataRegion.loadNewTsFile(this.generateResource(writer, progressIndex), true, isGeneratedByPipe);
                dataRegion.getNonSystemDatabaseName().ifPresent(databaseName -> {
                    long writePointCount = this.getTsFileWritePointCount(writer);
                    MemTableFlushTask.recordFlushPointsMetricInternal(writePointCount, databaseName, dataRegion.getDataRegionId());
                    MetricService.getInstance().count(writePointCount, Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), Metric.POINTS_IN.toString(), Tag.DATABASE.toString(), databaseName, Tag.REGION.toString(), dataRegion.getDataRegionId()});
                });
            }
        }

        private TsFileResource generateResource(TsFileIOWriter writer, ProgressIndex progressIndex) throws IOException {
            TsFileResource tsFileResource = TsFileResourceUtils.generateTsFileResource(writer);
            tsFileResource.setProgressIndex(progressIndex);
            tsFileResource.serialize();
            return tsFileResource;
        }

        private long getTsFileWritePointCount(TsFileIOWriter writer) {
            return writer.getChunkGroupMetadataList().stream().flatMap(chunkGroupMetadata -> chunkGroupMetadata.getChunkMetadataList().stream()).mapToLong(chunkMetadata -> chunkMetadata.getStatistics().getCount()).sum();
        }

        private void close() {
            if (this.isClosed) {
                return;
            }
            if (this.dataPartition2Writer != null) {
                for (Map.Entry<DataPartitionInfo, Object> entry : this.dataPartition2Writer.entrySet()) {
                    try {
                        Path writerPath;
                        TsFileIOWriter writer = (TsFileIOWriter)entry.getValue();
                        if (writer.canWrite()) {
                            writer.close();
                        }
                        if (!Files.exists(writerPath = writer.getFile().toPath(), new LinkOption[0])) continue;
                        Files.delete(writerPath);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Close TsFileIOWriter {} error.", (Object)((TsFileIOWriter)entry.getValue()).getFile().getPath(), (Object)e);
                    }
                }
            }
            if (this.dataPartition2ModificationFile != null) {
                for (Map.Entry<DataPartitionInfo, Object> entry : this.dataPartition2ModificationFile.entrySet()) {
                    try {
                        ModificationFile modificationFile = (ModificationFile)entry.getValue();
                        modificationFile.close();
                        Path modificationFilePath = new File(modificationFile.getFilePath()).toPath();
                        if (!Files.exists(modificationFilePath, new LinkOption[0])) continue;
                        Files.delete(modificationFilePath);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Close ModificationFile {} error.", (Object)((ModificationFile)entry.getValue()).getFilePath(), (Object)e);
                    }
                }
            }
            try {
                Files.delete(this.taskDir.toPath());
            }
            catch (DirectoryNotEmptyException e) {
                LOGGER.info("Task dir {} is not empty, skip deleting.", (Object)this.taskDir.getPath());
            }
            catch (IOException e) {
                LOGGER.warn(LoadTsFileManager.MESSAGE_DELETE_FAIL, (Object)this.taskDir.getPath(), (Object)e);
            }
            this.dataPartition2Writer = null;
            this.dataPartition2LastDevice = null;
            this.dataPartition2ModificationFile = null;
            this.isClosed = true;
        }
    }
}

