/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public abstract class MaxMinByBaseAccumulator
implements Accumulator {
    private final TSDataType xDataType;
    private final TSDataType yDataType;
    private final TsPrimitiveType yExtremeValue;
    private final TsPrimitiveType xResult;
    private boolean xNull = true;
    private boolean initResult;
    private long yTimeStamp = Long.MAX_VALUE;
    private static final String UNSUPPORTED_TYPE_MESSAGE = "Unsupported data type in MaxBy/MinBy: %s";

    protected MaxMinByBaseAccumulator(TSDataType xDataType, TSDataType yDataType) {
        this.xDataType = xDataType;
        this.yDataType = yDataType;
        this.xResult = TsPrimitiveType.getByType((TSDataType)xDataType);
        this.yExtremeValue = TsPrimitiveType.getByType((TSDataType)yDataType);
    }

    @Override
    public void addInput(Column[] column, BitMap bitMap) {
        Preconditions.checkArgument((column.length == 3 ? 1 : 0) != 0, (Object)"Length of input Column[] for MaxBy/MinBy should be 3");
        switch (this.yDataType) {
            case INT32: {
                this.addIntInput(column, bitMap);
                return;
            }
            case INT64: {
                this.addLongInput(column, bitMap);
                return;
            }
            case FLOAT: {
                this.addFloatInput(column, bitMap);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(column, bitMap);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_TYPE_MESSAGE, this.yDataType));
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of MaxBy/MinBy should be 1");
        if (partialResult[0].isNull(0)) {
            return;
        }
        byte[] bytes = partialResult[0].getBinary(0).getValues();
        this.updateFromBytesIntermediateInput(bytes);
    }

    @Override
    public void addStatistics(Statistics statistics) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void setFinal(Column finalResult) {
        if (finalResult.isNull(0)) {
            return;
        }
        this.initResult = true;
        this.updateX(finalResult, 0);
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 1 ? 1 : 0) != 0, (Object)"partialResult of MaxValue should be 1");
        if (!this.initResult) {
            columnBuilders[0].appendNull();
            return;
        }
        columnBuilders[0].writeBinary(new Binary(this.serialize()));
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        this.writeX(columnBuilder);
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.xNull = true;
        this.xResult.reset();
        this.yExtremeValue.reset();
        this.yTimeStamp = Long.MAX_VALUE;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.TEXT};
    }

    @Override
    public TSDataType getFinalType() {
        return this.xDataType;
    }

    private void addIntInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[2].isNull(i)) continue;
            this.updateIntResult(column[0].getLong(i), column[2].getInt(i), column[1], i);
        }
    }

    private void updateIntResult(long time, int yValue, Column xColumn, int xIndex) {
        if (!this.initResult || this.check(yValue, this.yExtremeValue.getInt()) || yValue == this.yExtremeValue.getInt() && time < this.yTimeStamp) {
            this.initResult = true;
            this.yTimeStamp = time;
            this.yExtremeValue.setInt(yValue);
            this.updateX(xColumn, xIndex);
        }
    }

    private void addLongInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[2].isNull(i)) continue;
            this.updateLongResult(column[0].getLong(i), column[2].getLong(i), column[1], i);
        }
    }

    private void updateLongResult(long time, long yValue, Column xColumn, int xIndex) {
        if (!this.initResult || this.check(yValue, this.yExtremeValue.getLong()) || yValue == this.yExtremeValue.getLong() && time < this.yTimeStamp) {
            this.initResult = true;
            this.yTimeStamp = time;
            this.yExtremeValue.setLong(yValue);
            this.updateX(xColumn, xIndex);
        }
    }

    private void addFloatInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[2].isNull(i)) continue;
            this.updateFloatResult(column[0].getLong(i), column[2].getFloat(i), column[1], i);
        }
    }

    private void updateFloatResult(long time, float yValue, Column xColumn, int xIndex) {
        if (!this.initResult || this.check(yValue, this.yExtremeValue.getFloat()) || yValue == this.yExtremeValue.getFloat() && time < this.yTimeStamp) {
            this.initResult = true;
            this.yTimeStamp = time;
            this.yExtremeValue.setFloat(yValue);
            this.updateX(xColumn, xIndex);
        }
    }

    private void addDoubleInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[2].isNull(i)) continue;
            this.updateDoubleResult(column[0].getLong(i), column[2].getDouble(i), column[1], i);
        }
    }

    private void updateDoubleResult(long time, double yValue, Column xColumn, int xIndex) {
        if (!this.initResult || this.check(yValue, this.yExtremeValue.getDouble()) || yValue == this.yExtremeValue.getDouble() && time < this.yTimeStamp) {
            this.initResult = true;
            this.yTimeStamp = time;
            this.yExtremeValue.setDouble(yValue);
            this.updateX(xColumn, xIndex);
        }
    }

    private void writeX(ColumnBuilder columnBuilder) {
        if (this.xNull) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.xDataType) {
            case INT32: {
                columnBuilder.writeInt(this.xResult.getInt());
                break;
            }
            case INT64: {
                columnBuilder.writeLong(this.xResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.xResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.xResult.getDouble());
                break;
            }
            case TEXT: {
                columnBuilder.writeBinary(this.xResult.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.xResult.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_TYPE_MESSAGE, this.xDataType));
            }
        }
    }

    private void updateX(Column xColumn, int xIndex) {
        if (xColumn.isNull(xIndex)) {
            this.xNull = true;
        } else {
            this.xNull = false;
            switch (this.xDataType) {
                case INT32: {
                    this.xResult.setInt(xColumn.getInt(xIndex));
                    break;
                }
                case INT64: {
                    this.xResult.setLong(xColumn.getLong(xIndex));
                    break;
                }
                case FLOAT: {
                    this.xResult.setFloat(xColumn.getFloat(xIndex));
                    break;
                }
                case DOUBLE: {
                    this.xResult.setDouble(xColumn.getDouble(xIndex));
                    break;
                }
                case TEXT: {
                    this.xResult.setBinary(xColumn.getBinary(xIndex));
                    break;
                }
                case BOOLEAN: {
                    this.xResult.setBoolean(xColumn.getBoolean(xIndex));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_TYPE_MESSAGE, this.xDataType));
                }
            }
        }
    }

    private byte[] serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(this.yTimeStamp);
            this.writeIntermediateToStream(this.yDataType, this.yExtremeValue, dataOutputStream);
            dataOutputStream.writeBoolean(this.xNull);
            if (!this.xNull) {
                this.writeIntermediateToStream(this.xDataType, this.xResult, dataOutputStream);
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Failed to serialize intermediate result for MaxByAccumulator.", e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void writeIntermediateToStream(TSDataType dataType, TsPrimitiveType value, DataOutputStream dataOutputStream) throws IOException {
        switch (dataType) {
            case INT32: {
                dataOutputStream.writeInt(value.getInt());
                break;
            }
            case INT64: {
                dataOutputStream.writeLong(value.getLong());
                break;
            }
            case FLOAT: {
                dataOutputStream.writeFloat(value.getFloat());
                break;
            }
            case DOUBLE: {
                dataOutputStream.writeDouble(value.getDouble());
                break;
            }
            case TEXT: {
                dataOutputStream.writeBytes(value.getBinary().toString());
                break;
            }
            case BOOLEAN: {
                dataOutputStream.writeBoolean(value.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_TYPE_MESSAGE, dataType));
            }
        }
    }

    private void updateFromBytesIntermediateInput(byte[] bytes) {
        long time = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)0);
        int offset = 8;
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(this.xDataType));
        ColumnBuilder columnBuilder = builder.getValueColumnBuilders()[0];
        switch (this.yDataType) {
            case INT32: {
                int intMaxVal = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, offset += 4, columnBuilder);
                this.updateIntResult(time, intMaxVal, columnBuilder.build(), 0);
                break;
            }
            case INT64: {
                long longMaxVal = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, offset += 8, columnBuilder);
                this.updateLongResult(time, longMaxVal, columnBuilder.build(), 0);
                break;
            }
            case FLOAT: {
                float floatMaxVal = BytesUtils.bytesToFloat((byte[])bytes, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, offset += 4, columnBuilder);
                this.updateFloatResult(time, floatMaxVal, columnBuilder.build(), 0);
                break;
            }
            case DOUBLE: {
                double doubleMaxVal = BytesUtils.bytesToDouble((byte[])bytes, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, offset += 8, columnBuilder);
                this.updateDoubleResult(time, doubleMaxVal, columnBuilder.build(), 0);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_TYPE_MESSAGE, this.yDataType));
            }
        }
    }

    private void readXFromBytesIntermediateInput(byte[] bytes, int offset, ColumnBuilder columnBuilder) {
        boolean isXNull = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
        ++offset;
        if (isXNull) {
            columnBuilder.appendNull();
        } else {
            switch (this.xDataType) {
                case INT32: {
                    columnBuilder.writeInt(BytesUtils.bytesToInt((byte[])bytes, (int)offset));
                    break;
                }
                case INT64: {
                    columnBuilder.writeLong(BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)offset));
                    break;
                }
                case FLOAT: {
                    columnBuilder.writeFloat(BytesUtils.bytesToFloat((byte[])bytes, (int)offset));
                    break;
                }
                case DOUBLE: {
                    columnBuilder.writeDouble(BytesUtils.bytesToDouble((byte[])bytes, (int)offset));
                    break;
                }
                case TEXT: {
                    columnBuilder.writeBinary(new Binary(BytesUtils.subBytes((byte[])bytes, (int)offset, (int)(bytes.length - offset))));
                    break;
                }
                case BOOLEAN: {
                    columnBuilder.writeBoolean(BytesUtils.bytesToBool((byte[])bytes, (int)offset));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format(UNSUPPORTED_TYPE_MESSAGE, this.xDataType));
                }
            }
        }
    }

    protected abstract boolean check(int var1, int var2);

    protected abstract boolean check(long var1, long var3);

    protected abstract boolean check(float var1, float var2);

    protected abstract boolean check(double var1, double var3);
}

