/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import org.apache.iotdb.db.queryengine.execution.aggregation.FirstValueAccumulator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.utils.BitMap;

public class FirstValueDescAccumulator
extends FirstValueAccumulator {
    public FirstValueDescAccumulator(TSDataType seriesDataType) {
        super(seriesDataType);
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    protected void addIntInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateIntFirstValue(column[1].getInt(i), column[0].getLong(i));
        }
    }

    @Override
    protected void addLongInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateLongFirstValue(column[1].getLong(i), column[0].getLong(i));
        }
    }

    @Override
    protected void addFloatInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateFloatFirstValue(column[1].getFloat(i), column[0].getLong(i));
        }
    }

    @Override
    protected void addDoubleInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateDoubleFirstValue(column[1].getDouble(i), column[0].getLong(i));
        }
    }

    @Override
    protected void addBooleanInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateBooleanFirstValue(column[1].getBoolean(i), column[0].getLong(i));
        }
    }

    @Override
    protected void addBinaryInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateBinaryFirstValue(column[1].getBinary(i), column[0].getLong(i));
        }
    }
}

