/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v2.handler;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.protocol.rest.utils.InsertRowDataUtils;
import org.apache.iotdb.db.protocol.rest.v2.model.InsertRecordsRequest;
import org.apache.iotdb.db.protocol.rest.v2.model.InsertTabletRequest;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeDevicePathCache;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;

public class StatementConstructionHandler {
    private StatementConstructionHandler() {
    }

    public static InsertTabletStatement constructInsertTabletStatement(InsertTabletRequest insertTabletRequest) throws MetadataException, WriteProcessRejectException {
        TimestampPrecisionUtils.checkTimestampPrecision((Long)insertTabletRequest.getTimestamps().get(insertTabletRequest.getTimestamps().size() - 1));
        InsertTabletStatement insertStatement = new InsertTabletStatement();
        insertStatement.setDevicePath(DataNodeDevicePathCache.getInstance().getPartialPath(insertTabletRequest.getDevice()));
        insertStatement.setMeasurements(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)insertTabletRequest.getMeasurements()).toArray(new String[0]));
        List rawData = insertTabletRequest.getValues();
        List rawDataType = insertTabletRequest.getDataTypes();
        int rowSize = insertTabletRequest.getTimestamps().size();
        int columnSize = rawDataType.size();
        Object[] columns = new Object[columnSize];
        BitMap[] bitMaps = new BitMap[columnSize];
        TSDataType[] dataTypes = new TSDataType[columnSize];
        for (int i = 0; i < columnSize; ++i) {
            dataTypes[i] = TSDataType.valueOf((String)((String)rawDataType.get(i)).toUpperCase(Locale.ROOT));
        }
        block9: for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
            bitMaps[columnIndex] = new BitMap(rowSize);
            switch (dataTypes[columnIndex]) {
                case BOOLEAN: {
                    boolean[] booleanValues = new boolean[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object data = ((List)rawData.get(columnIndex)).get(rowIndex);
                        if (data == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        booleanValues[rowIndex] = "1".equals(data.toString()) ? true : ("0".equals(data.toString()) ? false : (Boolean)data);
                    }
                    columns[columnIndex] = booleanValues;
                    continue block9;
                }
                case INT32: {
                    int[] intValues = new int[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object object = ((List)rawData.get(columnIndex)).get(rowIndex);
                        if (object == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        if (object instanceof Integer) {
                            intValues[rowIndex] = (Integer)object;
                            continue;
                        }
                        throw new WriteProcessRejectException("unsupported data type: " + object.getClass().toString());
                    }
                    columns[columnIndex] = intValues;
                    continue block9;
                }
                case INT64: {
                    long[] longValues = new long[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object object = ((List)rawData.get(columnIndex)).get(rowIndex);
                        if (object == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        if (object instanceof Integer) {
                            longValues[rowIndex] = ((Integer)object).intValue();
                            continue;
                        }
                        if (object instanceof Long) {
                            longValues[rowIndex] = (Long)object;
                            continue;
                        }
                        throw new WriteProcessRejectException("unsupported data type: " + object.getClass().toString());
                    }
                    columns[columnIndex] = longValues;
                    continue block9;
                }
                case FLOAT: {
                    float[] floatValues = new float[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        Object data = ((List)rawData.get(columnIndex)).get(rowIndex);
                        if (data == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        floatValues[rowIndex] = Float.parseFloat(String.valueOf(data));
                    }
                    columns[columnIndex] = floatValues;
                    continue block9;
                }
                case DOUBLE: {
                    double[] doubleValues = new double[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        if (((List)rawData.get(columnIndex)).get(rowIndex) == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            continue;
                        }
                        doubleValues[rowIndex] = Double.parseDouble(String.valueOf(((List)rawData.get(columnIndex)).get(rowIndex)));
                    }
                    columns[columnIndex] = doubleValues;
                    continue block9;
                }
                case TEXT: {
                    Binary[] binaryValues = new Binary[rowSize];
                    for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
                        if (((List)rawData.get(columnIndex)).get(rowIndex) == null) {
                            bitMaps[columnIndex].mark(rowIndex);
                            binaryValues[rowIndex] = new Binary("".getBytes(StandardCharsets.UTF_8));
                            continue;
                        }
                        binaryValues[rowIndex] = new Binary(((List)rawData.get(columnIndex)).get(rowIndex).toString().getBytes(StandardCharsets.UTF_8));
                    }
                    columns[columnIndex] = binaryValues;
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Invalid input: " + (String)rawDataType.get(columnIndex));
                }
            }
        }
        insertStatement.setTimes(insertTabletRequest.getTimestamps().stream().mapToLong(Long::longValue).toArray());
        insertStatement.setColumns(columns);
        insertStatement.setBitMaps(bitMaps);
        insertStatement.setRowCount(insertTabletRequest.getTimestamps().size());
        insertStatement.setDataTypes(dataTypes);
        insertStatement.setAligned(insertTabletRequest.getIsAligned());
        return insertStatement;
    }

    public static InsertRowsStatement createInsertRowsStatement(InsertRecordsRequest insertRecordsRequest) throws MetadataException, IoTDBConnectionException {
        int i;
        InsertRowsStatement insertStatement = new InsertRowsStatement();
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        ArrayList<List<TSDataType>> dataTypesList = new ArrayList<List<TSDataType>>();
        for (i = 0; i < insertRecordsRequest.getDataTypesList().size(); ++i) {
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            for (int c = 0; c < ((List)insertRecordsRequest.getDataTypesList().get(i)).size(); ++c) {
                dataTypes.add(TSDataType.valueOf((String)((String)((List)insertRecordsRequest.getDataTypesList().get(i)).get(c)).toUpperCase(Locale.ROOT)));
            }
            dataTypesList.add(dataTypes);
        }
        InsertRowDataUtils.filterNullValueAndMeasurement(insertRecordsRequest.getDevices(), insertRecordsRequest.getTimestamps(), insertRecordsRequest.getMeasurementsList(), insertRecordsRequest.getValuesList(), dataTypesList);
        for (i = 0; i < insertRecordsRequest.getDevices().size(); ++i) {
            InsertRowStatement statement = new InsertRowStatement();
            statement.setDevicePath(DataNodeDevicePathCache.getInstance().getPartialPath((String)insertRecordsRequest.getDevices().get(i)));
            statement.setMeasurements(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)((List)insertRecordsRequest.getMeasurementsList().get(i))).toArray(new String[0]));
            TimestampPrecisionUtils.checkTimestampPrecision((Long)insertRecordsRequest.getTimestamps().get(i));
            statement.setTime((Long)insertRecordsRequest.getTimestamps().get(i));
            statement.setDataTypes(((List)dataTypesList.get(i)).toArray(new TSDataType[0]));
            HashMap<Integer, Object> dataTypeMismatchInfo = new HashMap<Integer, Object>();
            List<Object> values = InsertRowDataUtils.reGenValues((List)dataTypesList.get(i), (List)insertRecordsRequest.getValuesList().get(i), dataTypeMismatchInfo);
            statement.setValues(values.toArray());
            statement.setAligned(insertRecordsRequest.getIsAligned());
            if (statement.isEmpty()) continue;
            if (!dataTypeMismatchInfo.isEmpty()) {
                for (Map.Entry entry : dataTypeMismatchInfo.entrySet()) {
                    int index = (Integer)entry.getKey();
                    String measurement = statement.getMeasurements()[index];
                    TSDataType dataType = statement.getDataTypes()[index];
                    statement.markFailedMeasurement(index, (Exception)((Object)new DataTypeMismatchException((String)insertRecordsRequest.getDevices().get(i), statement.getMeasurements()[index], statement.getDataTypes()[index], statement.getTime(), entry.getValue())));
                    statement.getDataTypes()[index] = dataType;
                    statement.getMeasurements()[index] = measurement;
                }
            }
            insertRowStatementList.add(statement);
        }
        insertStatement.setInsertRowStatementList(insertRowStatementList);
        return insertStatement;
    }
}

