/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.log;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipeLogStatus {
    private final Logger logger;
    private final int maxAverageScale;
    private final int maxLogInterval;
    private final AtomicLong currentRounds = new AtomicLong(0L);

    PipeLogStatus(Class<?> logClass, int maxAverageScale, int maxLogInterval) {
        this.logger = LoggerFactory.getLogger(logClass);
        this.maxAverageScale = maxAverageScale;
        this.maxLogInterval = maxLogInterval;
    }

    synchronized Optional<Logger> schedule(int scale) {
        if (this.currentRounds.incrementAndGet() >= (long)Math.min((int)Math.ceil((double)scale / (double)this.maxAverageScale), this.maxLogInterval)) {
            this.currentRounds.set(0L);
            return Optional.of(this.logger);
        }
        return Optional.empty();
    }
}

