/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.downsampling.sdt;

import java.util.Objects;
import org.apache.iotdb.db.pipe.processor.downsampling.sdt.SwingingDoorTrendingSamplingProcessor;

public class SwingingDoorTrendingFilter<T> {
    private final SwingingDoorTrendingSamplingProcessor processor;
    private double upperDoor;
    private double lowerDoor;
    private long lastReadTimestamp;
    private T lastReadValue;
    private long lastStoredTimestamp;
    private T lastStoredValue;

    public SwingingDoorTrendingFilter(SwingingDoorTrendingSamplingProcessor processor, long firstTimestamp, T firstValue) {
        this.processor = processor;
        this.init(firstTimestamp, firstValue);
    }

    private void init(long firstTimestamp, T firstValue) {
        this.upperDoor = Double.MIN_VALUE;
        this.lowerDoor = Double.MAX_VALUE;
        this.lastReadTimestamp = firstTimestamp;
        this.lastReadValue = firstValue;
        this.lastStoredTimestamp = firstTimestamp;
        this.lastStoredValue = firstValue;
    }

    public boolean filter(long timestamp, T value) {
        try {
            return this.tryFilter(timestamp, value);
        }
        catch (Exception e) {
            this.init(timestamp, value);
            return true;
        }
    }

    private boolean tryFilter(long timestamp, T value) {
        double currentLowerSlope;
        double lastStoredDoubleValue;
        long timeDiff = timestamp - this.lastStoredTimestamp;
        long absTimeDiff = Math.abs(timeDiff);
        if (absTimeDiff <= this.processor.getCompressionMinTimeInterval()) {
            return false;
        }
        if (absTimeDiff >= this.processor.getCompressionMaxTimeInterval()) {
            this.reset(timestamp, value);
            return true;
        }
        if (value instanceof Boolean || value instanceof String) {
            if (Objects.equals(this.lastStoredValue, value)) {
                return false;
            }
            this.reset(timestamp, value);
            return true;
        }
        double doubleValue = Double.parseDouble(value.toString());
        double valueDiff = doubleValue - (lastStoredDoubleValue = Double.parseDouble(this.lastStoredValue.toString()));
        double currentUpperSlope = (valueDiff - this.processor.getCompressionDeviation()) / (double)timeDiff;
        if (currentUpperSlope > this.upperDoor) {
            this.upperDoor = currentUpperSlope;
        }
        if ((currentLowerSlope = (valueDiff + this.processor.getCompressionDeviation()) / (double)timeDiff) < this.lowerDoor) {
            this.lowerDoor = currentLowerSlope;
        }
        if (this.upperDoor > this.lowerDoor) {
            this.lastStoredTimestamp = this.lastReadTimestamp;
            this.lastStoredValue = this.lastReadValue;
            this.upperDoor = currentUpperSlope;
            this.lowerDoor = currentLowerSlope;
            this.lastReadValue = value;
            this.lastReadTimestamp = timestamp;
            return true;
        }
        this.lastReadValue = value;
        this.lastReadTimestamp = timestamp;
        return false;
    }

    private void reset(long timestamp, T value) {
        this.upperDoor = Double.MIN_VALUE;
        this.lowerDoor = Double.MAX_VALUE;
        this.lastStoredTimestamp = timestamp;
        this.lastStoredValue = value;
    }
}

