/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.aggregate.window.processor;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.pipe.processor.aggregate.window.datastructure.TimeSeriesWindow;
import org.apache.iotdb.db.pipe.processor.aggregate.window.datastructure.WindowOutput;
import org.apache.iotdb.db.pipe.processor.aggregate.window.datastructure.WindowState;
import org.apache.iotdb.db.pipe.processor.aggregate.window.processor.AbstractSimpleTimeWindowingProcessor;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.tsfile.utils.Pair;

public class TumblingWindowingProcessor
extends AbstractSimpleTimeWindowingProcessor {
    private long slidingBoundaryTime;
    private long slidingInterval;

    public void validate(PipeParameterValidator validator) throws Exception {
        PipeParameters parameters = validator.getParameters();
        validator.validate(args -> (Long)args > 0L, String.format("The parameter %s must be greater than 0", "processor.sliding.seconds"), (Object)parameters.getLongOrDefault("processor.sliding.seconds", 120L));
    }

    public void customize(PipeParameters parameters, PipeProcessorRuntimeConfiguration configuration) throws Exception {
        this.slidingBoundaryTime = parameters.hasAnyAttributes(new String[]{"processor.sliding.boundary-time"}) ? DateTimeUtils.convertTimestampOrDatetimeStrToLongWithDefaultZone(parameters.getString("processor.sliding.boundary-time")) : 0L;
        this.slidingInterval = TimestampPrecisionUtils.convertToCurrPrecision(parameters.getLongOrDefault("processor.sliding.seconds", 120L), TimeUnit.SECONDS);
    }

    @Override
    public Set<TimeSeriesWindow> mayAddWindow(List<TimeSeriesWindow> windowList, long timeStamp) {
        long lastTime = windowList.isEmpty() ? this.slidingBoundaryTime : windowList.get(windowList.size() - 1).getTimestamp();
        if (timeStamp >= (windowList.isEmpty() ? lastTime : lastTime + this.slidingInterval)) {
            TimeSeriesWindow window = new TimeSeriesWindow(this, null);
            window.setTimestamp((timeStamp - lastTime) / this.slidingInterval * this.slidingInterval + lastTime);
            windowList.add(window);
            return Collections.singleton(window);
        }
        return Collections.emptySet();
    }

    @Override
    public Pair<WindowState, WindowOutput> updateAndMaySetWindowState(TimeSeriesWindow window, long timeStamp) {
        if (timeStamp < window.getTimestamp()) {
            return new Pair((Object)WindowState.IGNORE_VALUE, null);
        }
        if (timeStamp >= window.getTimestamp() + this.slidingInterval) {
            return new Pair((Object)WindowState.EMIT_AND_PURGE_WITHOUT_COMPUTE, (Object)new WindowOutput().setTimestamp(window.getTimestamp()).setProgressTime(window.getTimestamp() + this.slidingInterval));
        }
        return new Pair((Object)WindowState.COMPUTE, null);
    }

    @Override
    public WindowOutput forceOutput(TimeSeriesWindow window) {
        return new WindowOutput().setTimestamp(window.getTimestamp()).setProgressTime(window.getTimestamp() + this.slidingInterval);
    }
}

