/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.aggregate;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.iotdb.db.pipe.processor.aggregate.operator.aggregatedresult.AggregatedResultOperator;
import org.apache.iotdb.db.pipe.processor.aggregate.operator.intermediateresult.IntermediateResultOperator;
import org.apache.iotdb.db.pipe.processor.aggregate.window.datastructure.TimeSeriesWindow;
import org.apache.iotdb.db.pipe.processor.aggregate.window.datastructure.WindowOutput;
import org.apache.iotdb.db.pipe.processor.aggregate.window.datastructure.WindowState;
import org.apache.iotdb.db.pipe.processor.aggregate.window.processor.AbstractWindowingProcessor;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TimeSeriesRuntimeState {
    private final Map<String, AggregatedResultOperator> aggregatorOutputName2OperatorMap;
    private final Map<String, Supplier<IntermediateResultOperator>> intermediateResultName2OperatorSupplierMap;
    private final Map<String, String> systemParameters;
    private final AbstractWindowingProcessor windowingProcessor;
    private long lastStateReportPhysicalTime;
    private long lastReportTimeStamp = Long.MIN_VALUE;
    private final List<TimeSeriesWindow> currentOpeningWindows = new ArrayList<TimeSeriesWindow>();
    private final List<WindowOutput> outputList = new ArrayList<WindowOutput>();

    public TimeSeriesRuntimeState(Map<String, AggregatedResultOperator> aggregatorOutputName2OperatorMap, Map<String, Supplier<IntermediateResultOperator>> intermediateResultName2OperatorSupplierMap, Map<String, String> systemParameters, AbstractWindowingProcessor windowingProcessor) {
        this.aggregatorOutputName2OperatorMap = aggregatorOutputName2OperatorMap;
        this.intermediateResultName2OperatorSupplierMap = intermediateResultName2OperatorSupplierMap;
        this.systemParameters = systemParameters;
        this.windowingProcessor = windowingProcessor;
    }

    public Pair<List<WindowOutput>, Pair<Long, ByteBuffer>> updateWindows(long timestamp, boolean value, long outputMinReportIntervalMilliseconds) throws IOException {
        Pair output = null;
        if (timestamp <= this.lastReportTimeStamp) {
            return null;
        }
        Set<TimeSeriesWindow> addedWindows = this.windowingProcessor.mayAddWindow(this.currentOpeningWindows, timestamp, value);
        if (Objects.nonNull(addedWindows)) {
            addedWindows.forEach(window -> window.initWindow(this.intermediateResultName2OperatorSupplierMap, this.aggregatorOutputName2OperatorMap, this.systemParameters));
        }
        Iterator<TimeSeriesWindow> windowIterator = this.currentOpeningWindows.iterator();
        while (windowIterator.hasNext()) {
            TimeSeriesWindow window2 = windowIterator.next();
            Pair<WindowState, WindowOutput> stateWindowOutputPair = window2.updateIntermediateResult(timestamp, value);
            if (Objects.isNull(stateWindowOutputPair)) continue;
            if (((WindowState)((Object)stateWindowOutputPair.getLeft())).isEmit() && Objects.nonNull(stateWindowOutputPair.getRight())) {
                this.outputList.add((WindowOutput)stateWindowOutputPair.getRight());
                this.lastReportTimeStamp = Math.max(this.lastReportTimeStamp, ((WindowOutput)stateWindowOutputPair.getRight()).getProgressTime());
            }
            if (!((WindowState)((Object)stateWindowOutputPair.getLeft())).isPurge()) continue;
            windowIterator.remove();
        }
        if (!this.outputList.isEmpty()) {
            output = new Pair(new ArrayList<WindowOutput>(this.outputList), this.getTimestampWindowBufferPair(outputMinReportIntervalMilliseconds));
            this.outputList.clear();
        }
        return output;
    }

    public Pair<List<WindowOutput>, Pair<Long, ByteBuffer>> updateWindows(long timestamp, int value, long outputMinReportIntervalMilliseconds) throws IOException {
        Pair output = null;
        if (timestamp <= this.lastReportTimeStamp) {
            return null;
        }
        Set<TimeSeriesWindow> addedWindows = this.windowingProcessor.mayAddWindow(this.currentOpeningWindows, timestamp, value);
        if (Objects.nonNull(addedWindows)) {
            addedWindows.forEach(window -> window.initWindow(this.intermediateResultName2OperatorSupplierMap, this.aggregatorOutputName2OperatorMap, this.systemParameters));
        }
        Iterator<TimeSeriesWindow> windowIterator = this.currentOpeningWindows.iterator();
        while (windowIterator.hasNext()) {
            TimeSeriesWindow window2 = windowIterator.next();
            Pair<WindowState, WindowOutput> stateWindowOutputPair = window2.updateIntermediateResult(timestamp, value);
            if (Objects.isNull(stateWindowOutputPair)) continue;
            if (((WindowState)((Object)stateWindowOutputPair.getLeft())).isEmit() && Objects.nonNull(stateWindowOutputPair.getRight())) {
                this.outputList.add((WindowOutput)stateWindowOutputPair.getRight());
                this.lastReportTimeStamp = Math.max(this.lastReportTimeStamp, ((WindowOutput)stateWindowOutputPair.getRight()).getProgressTime());
            }
            if (!((WindowState)((Object)stateWindowOutputPair.getLeft())).isPurge()) continue;
            windowIterator.remove();
        }
        if (!this.outputList.isEmpty()) {
            output = new Pair(new ArrayList<WindowOutput>(this.outputList), this.getTimestampWindowBufferPair(outputMinReportIntervalMilliseconds));
            this.outputList.clear();
        }
        return output;
    }

    public Pair<List<WindowOutput>, Pair<Long, ByteBuffer>> updateWindows(long timestamp, long value, long outputMinReportIntervalMilliseconds) throws IOException {
        Pair output = null;
        if (timestamp <= this.lastReportTimeStamp) {
            return null;
        }
        Set<TimeSeriesWindow> addedWindows = this.windowingProcessor.mayAddWindow(this.currentOpeningWindows, timestamp, value);
        if (Objects.nonNull(addedWindows)) {
            addedWindows.forEach(window -> window.initWindow(this.intermediateResultName2OperatorSupplierMap, this.aggregatorOutputName2OperatorMap, this.systemParameters));
        }
        Iterator<TimeSeriesWindow> windowIterator = this.currentOpeningWindows.iterator();
        while (windowIterator.hasNext()) {
            TimeSeriesWindow window2 = windowIterator.next();
            Pair<WindowState, WindowOutput> stateWindowOutputPair = window2.updateIntermediateResult(timestamp, value);
            if (Objects.isNull(stateWindowOutputPair)) continue;
            if (((WindowState)((Object)stateWindowOutputPair.getLeft())).isEmit() && Objects.nonNull(stateWindowOutputPair.getRight())) {
                this.outputList.add((WindowOutput)stateWindowOutputPair.getRight());
                this.lastReportTimeStamp = Math.max(this.lastReportTimeStamp, ((WindowOutput)stateWindowOutputPair.getRight()).getProgressTime());
            }
            if (!((WindowState)((Object)stateWindowOutputPair.getLeft())).isPurge()) continue;
            windowIterator.remove();
        }
        if (!this.outputList.isEmpty()) {
            output = new Pair(new ArrayList<WindowOutput>(this.outputList), this.getTimestampWindowBufferPair(outputMinReportIntervalMilliseconds));
            this.outputList.clear();
        }
        return output;
    }

    public Pair<List<WindowOutput>, Pair<Long, ByteBuffer>> updateWindows(long timestamp, float value, long outputMinReportIntervalMilliseconds) throws IOException {
        Pair output = null;
        if (timestamp <= this.lastReportTimeStamp) {
            return null;
        }
        Set<TimeSeriesWindow> addedWindows = this.windowingProcessor.mayAddWindow(this.currentOpeningWindows, timestamp, value);
        if (Objects.nonNull(addedWindows)) {
            addedWindows.forEach(window -> window.initWindow(this.intermediateResultName2OperatorSupplierMap, this.aggregatorOutputName2OperatorMap, this.systemParameters));
        }
        Iterator<TimeSeriesWindow> windowIterator = this.currentOpeningWindows.iterator();
        while (windowIterator.hasNext()) {
            TimeSeriesWindow window2 = windowIterator.next();
            Pair<WindowState, WindowOutput> stateWindowOutputPair = window2.updateIntermediateResult(timestamp, value);
            if (Objects.isNull(stateWindowOutputPair)) continue;
            if (((WindowState)((Object)stateWindowOutputPair.getLeft())).isEmit() && Objects.nonNull(stateWindowOutputPair.getRight())) {
                this.outputList.add((WindowOutput)stateWindowOutputPair.getRight());
                this.lastReportTimeStamp = Math.max(this.lastReportTimeStamp, ((WindowOutput)stateWindowOutputPair.getRight()).getProgressTime());
            }
            if (!((WindowState)((Object)stateWindowOutputPair.getLeft())).isPurge()) continue;
            windowIterator.remove();
        }
        if (!this.outputList.isEmpty()) {
            output = new Pair(new ArrayList<WindowOutput>(this.outputList), this.getTimestampWindowBufferPair(outputMinReportIntervalMilliseconds));
            this.outputList.clear();
        }
        return output;
    }

    public Pair<List<WindowOutput>, Pair<Long, ByteBuffer>> updateWindows(long timestamp, double value, long outputMinReportIntervalMilliseconds) throws IOException {
        Pair output = null;
        if (timestamp <= this.lastReportTimeStamp) {
            return null;
        }
        Set<TimeSeriesWindow> addedWindows = this.windowingProcessor.mayAddWindow(this.currentOpeningWindows, timestamp, value);
        if (Objects.nonNull(addedWindows)) {
            addedWindows.forEach(window -> window.initWindow(this.intermediateResultName2OperatorSupplierMap, this.aggregatorOutputName2OperatorMap, this.systemParameters));
        }
        Iterator<TimeSeriesWindow> windowIterator = this.currentOpeningWindows.iterator();
        while (windowIterator.hasNext()) {
            TimeSeriesWindow window2 = windowIterator.next();
            Pair<WindowState, WindowOutput> stateWindowOutputPair = window2.updateIntermediateResult(timestamp, value);
            if (Objects.isNull(stateWindowOutputPair)) continue;
            if (((WindowState)((Object)stateWindowOutputPair.getLeft())).isEmit() && Objects.nonNull(stateWindowOutputPair.getRight())) {
                this.outputList.add((WindowOutput)stateWindowOutputPair.getRight());
                this.lastReportTimeStamp = Math.max(this.lastReportTimeStamp, ((WindowOutput)stateWindowOutputPair.getRight()).getProgressTime());
            }
            if (!((WindowState)((Object)stateWindowOutputPair.getLeft())).isPurge()) continue;
            windowIterator.remove();
        }
        if (!this.outputList.isEmpty()) {
            output = new Pair(new ArrayList<WindowOutput>(this.outputList), this.getTimestampWindowBufferPair(outputMinReportIntervalMilliseconds));
            this.outputList.clear();
        }
        return output;
    }

    public Pair<List<WindowOutput>, Pair<Long, ByteBuffer>> updateWindows(long timestamp, String value, long outputMinReportIntervalMilliseconds) throws IOException {
        Pair output = null;
        if (timestamp <= this.lastReportTimeStamp) {
            return null;
        }
        Set<TimeSeriesWindow> addedWindows = this.windowingProcessor.mayAddWindow(this.currentOpeningWindows, timestamp, value);
        if (Objects.nonNull(addedWindows)) {
            addedWindows.forEach(window -> window.initWindow(this.intermediateResultName2OperatorSupplierMap, this.aggregatorOutputName2OperatorMap, this.systemParameters));
        }
        Iterator<TimeSeriesWindow> windowIterator = this.currentOpeningWindows.iterator();
        while (windowIterator.hasNext()) {
            TimeSeriesWindow window2 = windowIterator.next();
            Pair<WindowState, WindowOutput> stateWindowOutputPair = window2.updateIntermediateResult(timestamp, value);
            if (Objects.isNull(stateWindowOutputPair)) continue;
            if (((WindowState)((Object)stateWindowOutputPair.getLeft())).isEmit() && Objects.nonNull(stateWindowOutputPair.getRight())) {
                this.outputList.add((WindowOutput)stateWindowOutputPair.getRight());
                this.lastReportTimeStamp = Math.max(this.lastReportTimeStamp, ((WindowOutput)stateWindowOutputPair.getRight()).getProgressTime());
            }
            if (!((WindowState)((Object)stateWindowOutputPair.getLeft())).isPurge()) continue;
            windowIterator.remove();
        }
        if (!this.outputList.isEmpty()) {
            output = new Pair(new ArrayList<WindowOutput>(this.outputList), this.getTimestampWindowBufferPair(outputMinReportIntervalMilliseconds));
            this.outputList.clear();
        }
        return output;
    }

    public List<WindowOutput> forceOutput() {
        return this.currentOpeningWindows.stream().map(TimeSeriesWindow::forceOutput).collect(Collectors.toList());
    }

    private Pair<Long, ByteBuffer> getTimestampWindowBufferPair(long outputMinReportIntervalMilliseconds) throws IOException {
        if (this.currentOpeningWindows.isEmpty()) {
            return new Pair((Object)this.lastReportTimeStamp, null);
        }
        if (System.currentTimeMillis() - this.lastStateReportPhysicalTime < outputMinReportIntervalMilliseconds) {
            return null;
        }
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            Pair pair;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((int)this.currentOpeningWindows.size(), (OutputStream)outputStream);
                for (TimeSeriesWindow window : this.currentOpeningWindows) {
                    window.serialize(outputStream);
                }
                this.lastStateReportPhysicalTime = System.currentTimeMillis();
                pair = new Pair((Object)this.lastReportTimeStamp, (Object)ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size()));
            }
            return pair;
        }
    }

    public void restoreTimestampAndWindows(Pair<Long, ByteBuffer> timestampWindowBufferPair) throws IOException {
        if ((Long)timestampWindowBufferPair.getLeft() <= this.lastReportTimeStamp) {
            return;
        }
        this.lastReportTimeStamp = (Long)timestampWindowBufferPair.getLeft();
        ByteBuffer buffer = (ByteBuffer)timestampWindowBufferPair.getRight();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        for (int i = 0; i < size; ++i) {
            TimeSeriesWindow currentWindow = new TimeSeriesWindow(this.windowingProcessor, null);
            currentWindow.initWindow(this.intermediateResultName2OperatorSupplierMap, this.aggregatorOutputName2OperatorMap, this.systemParameters);
            currentWindow.deserialize(buffer);
            this.currentOpeningWindows.add(currentWindow);
        }
    }
}

