/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.schemaregion;

import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.pipe.datastructure.queue.listening.AbstractPipeListeningQueue;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.PipeSnapshotEvent;
import org.apache.iotdb.commons.pipe.extractor.IoTDBNonDataRegionExtractor;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionSnapshotEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.extractor.schemaregion.SchemaRegionListeningFilter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeOperateSchemaQueueNode;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class IoTDBSchemaRegionExtractor
extends IoTDBNonDataRegionExtractor {
    private SchemaRegionId schemaRegionId;
    private Set<PlanNodeType> listenedTypeSet = new HashSet<PlanNodeType>();

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        if (IoTDBDescriptor.getInstance().getConfig().getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.simple.SimpleConsensus")) {
            throw new PipeException("IoTDBSchemaRegionExtractor does not transferring events under simple consensus");
        }
        super.customize(parameters, configuration);
        this.schemaRegionId = new SchemaRegionId(this.regionId);
        this.listenedTypeSet = SchemaRegionListeningFilter.parseListeningPlanTypeSet(parameters);
    }

    public void start() throws Exception {
        if (!PipeAgent.runtime().isSchemaLeaderReady(this.schemaRegionId) || this.hasBeenStarted.get() || this.hasBeenClosed.get()) {
            return;
        }
        if (PipeAgent.runtime().increaseAndGetSchemaListenerReferenceCount(this.schemaRegionId) == 1) {
            SchemaRegionConsensusImpl.getInstance().write((ConsensusGroupId)this.schemaRegionId, (IConsensusRequest)new PipeOperateSchemaQueueNode(new PlanNodeId(""), true));
        }
        super.start();
    }

    protected boolean needTransferSnapshot() {
        return PipeSchemaRegionSnapshotEvent.needTransferSnapshot(this.listenedTypeSet);
    }

    protected void triggerSnapshot() {
        try {
            SchemaRegionConsensusImpl.getInstance().triggerSnapshot((ConsensusGroupId)this.schemaRegionId, true);
        }
        catch (ConsensusException e) {
            throw new PipeException("Exception encountered when triggering schema region snapshot.", (Throwable)e);
        }
    }

    public synchronized EnrichedEvent supply() throws Exception {
        return PipeAgent.runtime().isSchemaLeaderReady(this.schemaRegionId) ? super.supply() : null;
    }

    protected long getMaxBlockingTimeMs() {
        return 0L;
    }

    protected AbstractPipeListeningQueue getListeningQueue() {
        return PipeAgent.runtime().schemaListener(this.schemaRegionId);
    }

    protected boolean isTypeListened(Event event) {
        PlanNode planNode = ((PipeSchemaRegionWritePlanEvent)event).getPlanNode();
        return this.listenedTypeSet.contains((Object)(planNode.getType() == PlanNodeType.ALTER_TIME_SERIES && ((AlterTimeSeriesNode)planNode).isAlterView() ? PlanNodeType.ALTER_LOGICAL_VIEW : planNode.getType()));
    }

    protected void confineHistoricalEventTransferTypes(PipeSnapshotEvent event) {
        ((PipeSchemaRegionSnapshotEvent)event).confineTransferredTypes(this.listenedTypeSet);
    }

    public synchronized void close() throws Exception {
        if (this.hasBeenClosed.get()) {
            return;
        }
        this.hasBeenClosed.set(true);
        if (!this.hasBeenStarted.get()) {
            return;
        }
        super.close();
        if (!this.listenedTypeSet.isEmpty()) {
            PipeAgent.runtime().decreaseAndGetSchemaListenerReferenceCount(this.schemaRegionId);
        }
    }
}

