/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.TabletInsertionDataContainer;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryHandler;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeInsertNodeTabletInsertionEvent
extends EnrichedEvent
implements TabletInsertionEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeInsertNodeTabletInsertionEvent.class);
    private final WALEntryHandler walEntryHandler;
    private final boolean isAligned;
    private final boolean isGeneratedByPipe;
    private List<TabletInsertionDataContainer> dataContainers;
    private ProgressIndex progressIndex;

    public PipeInsertNodeTabletInsertionEvent(WALEntryHandler walEntryHandler, ProgressIndex progressIndex, boolean isAligned, boolean isGeneratedByPipe) {
        this(walEntryHandler, progressIndex, isAligned, isGeneratedByPipe, null, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    private PipeInsertNodeTabletInsertionEvent(WALEntryHandler walEntryHandler, ProgressIndex progressIndex, boolean isAligned, boolean isGeneratedByPipe, String pipeName, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        super(pipeName, pipeTaskMeta, pattern, startTime, endTime);
        this.walEntryHandler = walEntryHandler;
        this.progressIndex = progressIndex;
        this.isAligned = isAligned;
        this.isGeneratedByPipe = isGeneratedByPipe;
    }

    public InsertNode getInsertNode() throws WALPipeException {
        return this.walEntryHandler.getInsertNode();
    }

    public ByteBuffer getByteBuffer() throws WALPipeException {
        return this.walEntryHandler.getByteBuffer();
    }

    public InsertNode getInsertNodeViaCacheIfPossible() {
        return this.walEntryHandler.getInsertNodeViaCacheIfPossible();
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        try {
            PipeResourceManager.wal().pin(this.walEntryHandler);
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Increase reference count for memtable %d error. Holder Message: %s", this.walEntryHandler.getMemTableId(), holderMessage), (Throwable)e);
            return false;
        }
    }

    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        try {
            PipeResourceManager.wal().unpin(this.walEntryHandler);
            if (this.dataContainers != null) {
                this.dataContainers.clear();
                this.dataContainers = null;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Decrease reference count for memtable %d error. Holder Message: %s", this.walEntryHandler.getMemTableId(), holderMessage), (Throwable)e);
            return false;
        }
    }

    public void bindProgressIndex(ProgressIndex progressIndex) {
        this.progressIndex = progressIndex;
    }

    public ProgressIndex getProgressIndex() {
        return this.progressIndex == null ? MinimumProgressIndex.INSTANCE : this.progressIndex;
    }

    public PipeInsertNodeTabletInsertionEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        return new PipeInsertNodeTabletInsertionEvent(this.walEntryHandler, this.progressIndex, this.isAligned, this.isGeneratedByPipe, pipeName, pipeTaskMeta, pattern, startTime, endTime);
    }

    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        try {
            InsertNode insertNode = this.getInsertNode();
            if (insertNode instanceof InsertRowNode) {
                long timestamp = ((InsertRowNode)insertNode).getTime();
                return this.startTime <= timestamp && timestamp <= this.endTime;
            }
            if (insertNode instanceof InsertTabletNode) {
                long[] timestamps = ((InsertTabletNode)insertNode).getTimes();
                if (Objects.isNull(timestamps) || timestamps.length == 0) {
                    return false;
                }
                return this.startTime <= timestamps[timestamps.length - 1] && timestamps[0] <= this.endTime;
            }
            if (insertNode instanceof InsertRowsNode) {
                for (InsertRowNode node : ((InsertRowsNode)insertNode).getInsertRowNodeList()) {
                    long timestamp = node.getTime();
                    if (this.startTime > timestamp || timestamp > this.endTime) continue;
                    return true;
                }
                return false;
            }
            throw new UnSupportedDataTypeException(String.format("InsertNode type %s is not supported.", insertNode.getClass().getName()));
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when determining the event time of PipeInsertNodeTabletInsertionEvent({}) overlaps with the time range: [{}, {}]. Returning true to ensure data integrity.", new Object[]{this, this.startTime, this.endTime, e});
            return true;
        }
    }

    public Iterable<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> consumer) {
        return this.initDataContainers().stream().map(tabletInsertionDataContainer -> tabletInsertionDataContainer.processRowByRow(consumer)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Iterable<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> consumer) {
        return this.initDataContainers().stream().map(tabletInsertionDataContainer -> tabletInsertionDataContainer.processTablet(consumer)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public List<Tablet> convertToTablets() {
        return this.initDataContainers().stream().map(TabletInsertionDataContainer::convertToTablet).collect(Collectors.toList());
    }

    private List<TabletInsertionDataContainer> initDataContainers() {
        try {
            if (this.dataContainers != null) {
                return this.dataContainers;
            }
            this.dataContainers = new ArrayList<TabletInsertionDataContainer>();
            InsertNode node = this.getInsertNode();
            switch (node.getType()) {
                case INSERT_ROW: 
                case INSERT_TABLET: {
                    this.dataContainers.add(new TabletInsertionDataContainer(this.pipeTaskMeta, this, node, this.pipePattern));
                    break;
                }
                case INSERT_ROWS: {
                    for (InsertRowNode insertRowNode : ((InsertRowsNode)node).getInsertRowNodeList()) {
                        this.dataContainers.add(new TabletInsertionDataContainer(this.pipeTaskMeta, this, insertRowNode, this.pipePattern));
                    }
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException("Unsupported node type " + (Object)((Object)node.getType()));
                }
            }
            int size = this.dataContainers.size();
            if (size > 0) {
                this.dataContainers.get(size - 1).markAsNeedToReport();
            }
            return this.dataContainers;
        }
        catch (Exception e) {
            throw new PipeException("Initialize data container error.", (Throwable)e);
        }
    }

    public long count() {
        long count = 0L;
        for (Tablet covertedTablet : this.convertToTablets()) {
            count += (long)covertedTablet.rowSize * (long)covertedTablet.getSchemas().size();
        }
        return count;
    }

    public boolean shouldParsePattern() {
        InsertNode node = this.getInsertNodeViaCacheIfPossible();
        return super.shouldParsePattern() && Objects.nonNull(this.pipePattern) && (Objects.isNull(node) || (node.getType() == PlanNodeType.INSERT_ROWS ? ((InsertRowsNode)node).getInsertRowNodeList().stream().anyMatch(insertRowNode -> !this.pipePattern.coversDevice(insertRowNode.getDevicePath().getFullPath())) : !this.pipePattern.coversDevice(node.getDevicePath().getFullPath())));
    }

    public List<PipeRawTabletInsertionEvent> toRawTabletInsertionEvents() {
        List<PipeRawTabletInsertionEvent> events = this.convertToTablets().stream().map(tablet -> new PipeRawTabletInsertionEvent((Tablet)tablet, this.isAligned, this.pipeName, this.pipeTaskMeta, this, false)).filter(event -> !event.hasNoNeedParsingAndIsEmpty()).collect(Collectors.toList());
        int size = events.size();
        if (size > 0) {
            events.get(size - 1).markAsNeedToReport();
        }
        return events;
    }

    public String toString() {
        return String.format("PipeInsertNodeTabletInsertionEvent{walEntryHandler=%s, progressIndex=%s, isAligned=%s, isGeneratedByPipe=%s, dataContainers=%s}", this.walEntryHandler, this.progressIndex, this.isAligned, this.isGeneratedByPipe, this.dataContainers) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeInsertNodeTabletInsertionEvent{walEntryHandler=%s, progressIndex=%s, isAligned=%s, isGeneratedByPipe=%s}", this.walEntryHandler, this.progressIndex, this.isAligned, this.isGeneratedByPipe) + " - " + super.coreReportMessage();
    }
}

