/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.row;

import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.pipe.event.common.row.PipeBinaryTransformer;
import org.apache.iotdb.db.pipe.event.common.row.PipeDataTypeTransformer;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.apache.iotdb.pipe.api.type.Binary;
import org.apache.iotdb.pipe.api.type.Type;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class PipeRow
implements Row {
    protected final int rowIndex;
    protected final String deviceId;
    protected final boolean isAligned;
    protected final MeasurementSchema[] measurementSchemaList;
    protected final long[] timestampColumn;
    protected final TSDataType[] valueColumnTypes;
    protected final Object[] valueColumns;
    protected final BitMap[] bitMaps;
    protected final String[] columnNameStringList;

    public PipeRow(int rowIndex, String deviceId, boolean isAligned, MeasurementSchema[] measurementSchemaList, long[] timestampColumn, TSDataType[] valueColumnTypes, Object[] valueColumns, BitMap[] bitMaps, String[] columnNameStringList) {
        this.rowIndex = rowIndex;
        this.deviceId = deviceId;
        this.isAligned = isAligned;
        this.measurementSchemaList = measurementSchemaList;
        this.timestampColumn = timestampColumn;
        this.valueColumnTypes = valueColumnTypes;
        this.valueColumns = valueColumns;
        this.bitMaps = bitMaps;
        this.columnNameStringList = columnNameStringList;
    }

    public long getTime() {
        return this.timestampColumn[this.rowIndex];
    }

    public int getInt(int columnIndex) {
        return ((int[])this.valueColumns[columnIndex])[this.rowIndex];
    }

    public long getLong(int columnIndex) {
        return ((long[])this.valueColumns[columnIndex])[this.rowIndex];
    }

    public float getFloat(int columnIndex) {
        return ((float[])this.valueColumns[columnIndex])[this.rowIndex];
    }

    public double getDouble(int columnIndex) {
        return ((double[])this.valueColumns[columnIndex])[this.rowIndex];
    }

    public boolean getBoolean(int columnIndex) {
        return ((boolean[])this.valueColumns[columnIndex])[this.rowIndex];
    }

    public Binary getBinary(int columnIndex) {
        return PipeBinaryTransformer.transformToPipeBinary(((org.apache.iotdb.tsfile.utils.Binary[])this.valueColumns[columnIndex])[this.rowIndex]);
    }

    public String getString(int columnIndex) {
        org.apache.iotdb.tsfile.utils.Binary binary = ((org.apache.iotdb.tsfile.utils.Binary[])this.valueColumns[columnIndex])[this.rowIndex];
        return binary == null ? null : binary.getStringValue(TSFileConfig.STRING_CHARSET);
    }

    public Object getObject(int columnIndex) {
        switch (this.getDataType(columnIndex)) {
            case INT32: {
                return this.getInt(columnIndex);
            }
            case INT64: {
                return this.getLong(columnIndex);
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            case DOUBLE: {
                return this.getDouble(columnIndex);
            }
            case BOOLEAN: {
                return this.getBoolean(columnIndex);
            }
            case TEXT: {
                return this.getBinary(columnIndex);
            }
        }
        throw new UnsupportedOperationException(String.format("unsupported data type %s for column %s", this.getDataType(columnIndex), this.columnNameStringList[columnIndex]));
    }

    public Type getDataType(int columnIndex) {
        return PipeDataTypeTransformer.transformToPipeDataType(this.valueColumnTypes[columnIndex]);
    }

    public boolean isNull(int columnIndex) {
        return this.bitMaps[columnIndex].isMarked(this.rowIndex);
    }

    public int size() {
        return this.valueColumns.length;
    }

    public int getColumnIndex(Path columnName) throws PipeParameterNotValidException {
        for (int i = 0; i < this.columnNameStringList.length; ++i) {
            if (!this.columnNameStringList[i].equals(columnName.getFullPath())) continue;
            return i;
        }
        throw new PipeParameterNotValidException(String.format("column %s not found", columnName.getFullPath()));
    }

    public String getColumnName(int columnIndex) {
        return this.columnNameStringList[columnIndex];
    }

    public List<Type> getColumnTypes() {
        return PipeDataTypeTransformer.transformToPipeDataTypeList(Arrays.asList(this.valueColumnTypes));
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public MeasurementSchema[] getMeasurementSchemaList() {
        return this.measurementSchemaList;
    }
}

