/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.airgap;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.connector.protocol.IoTDBAirGapConnector;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferDataNodeHandshakeV1Req;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferDataNodeHandshakeV2Req;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferPlanNodeReq;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBDataNodeAirGapConnector
extends IoTDBAirGapConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataNodeAirGapConnector.class);

    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        PipeConfig pipeConfig = PipeConfig.getInstance();
        LinkedHashSet givenNodeUrls = this.parseNodeUrls(validator.getParameters());
        validator.validate(empty -> {
            try {
                return !pipeConfig.getPipeAirGapReceiverEnabled() || !NodeUrlUtils.containsLocalAddress(givenNodeUrls.stream().filter(tEndPoint -> tEndPoint.getPort() == pipeConfig.getPipeAirGapReceiverPort()).map(TEndPoint::getIp).collect(Collectors.toList()));
            }
            catch (UnknownHostException e) {
                LOGGER.warn("Unknown host when checking pipe sink IP.", (Throwable)e);
                return false;
            }
        }, String.format("One of the endpoints %s of the receivers is pointing back to the air gap receiver %s on sender itself, or unknown host when checking pipe sink IP.", givenNodeUrls, new TEndPoint(IoTDBDescriptor.getInstance().getConfig().getRpcAddress(), pipeConfig.getPipeAirGapReceiverPort())), new Object[0]);
    }

    protected boolean mayNeedHandshakeWhenFail() {
        return false;
    }

    protected byte[] generateHandShakeV1Payload() throws IOException {
        return PipeTransferDataNodeHandshakeV1Req.toTPipeTransferBytes(CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
    }

    protected byte[] generateHandShakeV2Payload() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("clusterID", IoTDBDescriptor.getInstance().getConfig().getClusterId());
        params.put("timestampPrecision", CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
        return PipeTransferDataNodeHandshakeV2Req.toTPipeTransferBytes(params);
    }

    protected void doTransferWrapper(Socket socket, PipeSchemaRegionWritePlanEvent pipeSchemaRegionWritePlanEvent) throws PipeException, IOException {
        try {
            if (!pipeSchemaRegionWritePlanEvent.increaseReferenceCount(IoTDBDataNodeAirGapConnector.class.getName())) {
                return;
            }
            this.doTransfer(socket, pipeSchemaRegionWritePlanEvent);
        }
        finally {
            pipeSchemaRegionWritePlanEvent.decreaseReferenceCount(IoTDBDataNodeAirGapConnector.class.getName(), false);
        }
    }

    private void doTransfer(Socket socket, PipeSchemaRegionWritePlanEvent pipeSchemaRegionWritePlanEvent) throws PipeException, IOException {
        if (!this.send(socket, PipeTransferPlanNodeReq.toTPipeTransferBytes(pipeSchemaRegionWritePlanEvent.getPlanNode()))) {
            String errorMessage = String.format("Transfer data node write plan %s error. Socket: %s.", new Object[]{pipeSchemaRegionWritePlanEvent.getPlanNode().getType(), socket});
            this.receiverStatusHandler.handle(new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(errorMessage), errorMessage, pipeSchemaRegionWritePlanEvent.toString());
        }
    }
}

