/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.IoTDBConnectorRequestVersion;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferPlanNodeReq
extends TPipeTransferReq {
    private transient PlanNode planNode;

    private PipeTransferPlanNodeReq() {
    }

    public PlanNode getPlanNode() {
        return this.planNode;
    }

    public static PipeTransferPlanNodeReq toTPipeTransferReq(PlanNode planNode) {
        PipeTransferPlanNodeReq req = new PipeTransferPlanNodeReq();
        req.planNode = planNode;
        req.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        req.type = PipeRequestType.TRANSFER_SCHEMA_PLAN.getType();
        req.body = planNode.serializeToByteBuffer();
        return req;
    }

    public static PipeTransferPlanNodeReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferPlanNodeReq planNodeReq = new PipeTransferPlanNodeReq();
        planNodeReq.planNode = PlanNodeType.deserialize(transferReq.body);
        planNodeReq.version = transferReq.version;
        planNodeReq.type = transferReq.type;
        planNodeReq.body = transferReq.body;
        return planNodeReq;
    }

    public static byte[] toTPipeTransferBytes(PlanNode planNode) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_SCHEMA_PLAN.getType(), (OutputStream)outputStream);
                byArray = BytesUtils.concatByteArray((byte[])byteArrayOutputStream.toByteArray(), (byte[])planNode.serializeToByteBuffer().array());
            }
            return byArray;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferPlanNodeReq that = (PipeTransferPlanNodeReq)((Object)obj);
        return this.planNode.equals(that.planNode) && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.planNode, this.version, this.type, this.body);
    }
}

