/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.ReferenceCountedObject;

public interface RaftClientAsynchronousProtocol {
    default public CompletableFuture<RaftClientReply> submitClientRequestAsync(RaftClientRequest request) throws IOException {
        return this.submitClientRequestAsync(ReferenceCountedObject.wrap(request));
    }

    default public CompletableFuture<RaftClientReply> submitClientRequestAsync(ReferenceCountedObject<RaftClientRequest> requestRef) {
        try {
            return this.submitClientRequestAsync(requestRef.retain()).whenComplete((r, e) -> requestRef.release());
        }
        catch (Exception e2) {
            requestRef.release();
            return JavaUtils.completeExceptionally(e2);
        }
    }
}

