/*
 * Decompiled with CFR 0.152.
 */
package com.github.ggalmazor.ltdownsampling;

import com.github.ggalmazor.ltdownsampling.Point;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.List;

class Area<T extends Point>
implements Comparable<Area<T>> {
    private final T generator;
    private final BigDecimal value;

    private Area(T generator, BigDecimal value) {
        this.generator = generator;
        this.value = value;
    }

    static <U extends Point> Area<U> ofTriangle(Point a, U b, Point c) {
        List<BigDecimal> addends = Arrays.asList(a.getX().multiply(b.getY().subtract(c.getY())), b.getX().multiply(c.getY().subtract(a.getY())), c.getX().multiply(a.getY().subtract(b.getY())));
        BigDecimal sum = addends.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal half = sum.divide(BigDecimal.valueOf(2L), MathContext.UNLIMITED);
        BigDecimal value = half.abs();
        return new Area<U>(b, value);
    }

    T getGenerator() {
        return this.generator;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public int compareTo(Area<T> o) {
        return this.value.compareTo(o.value);
    }
}

