/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import io.micrometer.context.ContextSnapshot;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CorePublisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.ContextPropagation;
import reactor.core.publisher.ContextPropagationSupport;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.OptimizableOperator;
import reactor.core.publisher.SourceProducer;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class FluxSource<I>
extends Flux<I>
implements SourceProducer<I>,
OptimizableOperator<I, I> {
    final Publisher<? extends I> source;
    @Nullable
    final OptimizableOperator<?, I> optimizableOperator;

    FluxSource(Publisher<? extends I> source) {
        OptimizableOperator optimSource;
        this.source = Objects.requireNonNull(source);
        this.optimizableOperator = source instanceof OptimizableOperator ? (optimSource = (OptimizableOperator)source) : null;
    }

    @Override
    public void subscribe(CoreSubscriber<? super I> actual) {
        if (ContextPropagationSupport.shouldPropagateContextToThreadLocals()) {
            this.source.subscribe(new FluxSourceRestoringThreadLocalsSubscriber<I>(actual));
        } else {
            this.source.subscribe(actual);
        }
    }

    @Override
    public final CorePublisher<? extends I> source() {
        return this;
    }

    @Override
    public final OptimizableOperator<?, ? extends I> nextOptimizableSource() {
        return this.optimizableOperator;
    }

    @Override
    public CoreSubscriber<? super I> subscribeOrReturn(CoreSubscriber<? super I> actual) {
        return actual;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.from(this.source).scanUnsafe(key);
        }
        return null;
    }

    static final class FluxSourceRestoringThreadLocalsSubscriber<T>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerConsumer<T> {
        final CoreSubscriber<? super T> actual;
        final Fuseable.ConditionalSubscriber<? super T> actualConditional;
        Subscription s;

        FluxSourceRestoringThreadLocalsSubscriber(CoreSubscriber<? super T> actual) {
            this.actual = actual;
            this.actualConditional = actual instanceof Fuseable.ConditionalSubscriber ? (Fuseable.ConditionalSubscriber)actual : null;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual;
            }
            return null;
        }

        @Override
        public Context currentContext() {
            return this.actual.currentContext();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onSubscribe(s2);
            }
        }

        @Override
        public void onNext(T t2) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onNext(t2);
            }
        }

        @Override
        public boolean tryOnNext(T t2) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                if (this.actualConditional != null) {
                    boolean bl = this.actualConditional.tryOnNext(t2);
                    return bl;
                }
                this.actual.onNext(t2);
                boolean bl = true;
                return bl;
            }
        }

        @Override
        public void onError(Throwable t2) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onComplete();
            }
        }
    }
}

