/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.InternalFluxOperator;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;
import reactor.util.Logger;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

final class FluxBufferTimeout<T, C extends Collection<? super T>>
extends InternalFluxOperator<T, C> {
    final int batchSize;
    final Supplier<C> bufferSupplier;
    final Scheduler timer;
    final long timespan;
    final TimeUnit unit;
    final boolean fairBackpressure;

    FluxBufferTimeout(Flux<T> source, int maxSize, long timespan, TimeUnit unit, Scheduler timer, Supplier<C> bufferSupplier, boolean fairBackpressure) {
        super(source);
        if (timespan <= 0L) {
            throw new IllegalArgumentException("Timeout period must be strictly positive");
        }
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be strictly positive");
        }
        this.timer = Objects.requireNonNull(timer, "Timer");
        this.timespan = timespan;
        this.unit = Objects.requireNonNull(unit, "unit");
        this.batchSize = maxSize;
        this.bufferSupplier = Objects.requireNonNull(bufferSupplier, "bufferSupplier");
        this.fairBackpressure = fairBackpressure;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super C> actual) {
        if (this.fairBackpressure) {
            return new BufferTimeoutWithBackpressureSubscriber(actual, this.batchSize, this.timespan, this.unit, this.timer.createWorker(), this.bufferSupplier, null);
        }
        return new BufferTimeoutSubscriber(Operators.serialize(actual), this.batchSize, this.timespan, this.unit, this.timer.createWorker(), this.bufferSupplier);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_ON) {
            return this.timer;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.ASYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class BufferTimeoutSubscriber<T, C extends Collection<? super T>>
    implements InnerOperator<T, C> {
        final CoreSubscriber<? super C> actual;
        static final int NOT_TERMINATED = 0;
        static final int TERMINATED_WITH_SUCCESS = 1;
        static final int TERMINATED_WITH_ERROR = 2;
        static final int TERMINATED_WITH_CANCEL = 3;
        final int batchSize;
        final long timespan;
        final TimeUnit unit;
        final Scheduler.Worker timer;
        final Runnable flushTask;
        protected Subscription subscription;
        volatile int terminated = 0;
        static final AtomicIntegerFieldUpdater<BufferTimeoutSubscriber> TERMINATED = AtomicIntegerFieldUpdater.newUpdater(BufferTimeoutSubscriber.class, "terminated");
        volatile long requested;
        static final AtomicLongFieldUpdater<BufferTimeoutSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(BufferTimeoutSubscriber.class, "requested");
        volatile long outstanding;
        static final AtomicLongFieldUpdater<BufferTimeoutSubscriber> OUTSTANDING = AtomicLongFieldUpdater.newUpdater(BufferTimeoutSubscriber.class, "outstanding");
        volatile int index = 0;
        static final AtomicIntegerFieldUpdater<BufferTimeoutSubscriber> INDEX = AtomicIntegerFieldUpdater.newUpdater(BufferTimeoutSubscriber.class, "index");
        volatile Disposable timespanRegistration;
        final Supplier<C> bufferSupplier;
        volatile C values;

        BufferTimeoutSubscriber(CoreSubscriber<? super C> actual, int maxSize, long timespan, TimeUnit unit, Scheduler.Worker timer, Supplier<C> bufferSupplier) {
            this.actual = actual;
            this.timespan = timespan;
            this.unit = unit;
            this.timer = timer;
            this.flushTask = () -> {
                if (this.terminated == 0) {
                    int index;
                    do {
                        if ((index = this.index) != 0) continue;
                        return;
                    } while (!INDEX.compareAndSet(this, index, 0));
                    this.flushCallback(null);
                }
            };
            this.batchSize = maxSize;
            this.bufferSupplier = bufferSupplier;
        }

        protected void doOnSubscribe() {
            this.values = (Collection)this.bufferSupplier.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void nextCallback(T value) {
            BufferTimeoutSubscriber bufferTimeoutSubscriber = this;
            synchronized (bufferTimeoutSubscriber) {
                if (OUTSTANDING.decrementAndGet(this) < 0L) {
                    this.actual.onError(Exceptions.failWithOverflow("Unrequested element received"));
                    Context ctx = this.actual.currentContext();
                    Operators.onDiscard(value, ctx);
                    Operators.onDiscardMultiple(this.values, ctx);
                    return;
                }
                Object v = this.values;
                if (v == null) {
                    this.values = v = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
                }
                v.add(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void flushCallback(@Nullable T ev) {
            C v;
            boolean flush2 = false;
            BufferTimeoutSubscriber bufferTimeoutSubscriber = this;
            synchronized (bufferTimeoutSubscriber) {
                v = this.values;
                if (v != null && !v.isEmpty()) {
                    this.values = (Collection)this.bufferSupplier.get();
                    flush2 = true;
                }
            }
            if (flush2) {
                long r = this.requested;
                if (r != 0L) {
                    if (r != Long.MAX_VALUE) {
                        do {
                            long next;
                            if (!REQUESTED.compareAndSet(this, r, next = r - 1L)) continue;
                            this.actual.onNext(v);
                            return;
                        } while ((r = this.requested) > 0L);
                    } else {
                        this.actual.onNext(v);
                        return;
                    }
                }
                this.cancel();
                this.actual.onError(Exceptions.failWithOverflow("Could not emit buffer due to lack of requests"));
                Operators.onDiscardMultiple(v, this.actual.currentContext());
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.subscription;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.terminated == 3;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.terminated == 2 || this.terminated == 1;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.CAPACITY) {
                return this.batchSize;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.batchSize - this.index;
            }
            if (key == Scannable.Attr.RUN_ON) {
                return this.timer;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.ASYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public void onNext(T value) {
            int index;
            while (!INDEX.compareAndSet(this, (index = this.index + 1) - 1, index)) {
            }
            if (index == 1) {
                try {
                    this.timespanRegistration = this.timer.schedule(this.flushTask, this.timespan, this.unit);
                }
                catch (RejectedExecutionException ree) {
                    Context ctx = this.actual.currentContext();
                    this.onError(Operators.onRejectedExecution(ree, this.subscription, null, value, ctx));
                    Operators.onDiscard(value, ctx);
                    return;
                }
            }
            this.nextCallback(value);
            if (this.index % this.batchSize == 0) {
                this.index = 0;
                if (this.timespanRegistration != null) {
                    this.timespanRegistration.dispose();
                    this.timespanRegistration = null;
                }
                this.flushCallback(value);
            }
        }

        void checkedComplete() {
            try {
                this.flushCallback(null);
            }
            finally {
                this.actual.onComplete();
            }
        }

        final boolean isCompleted() {
            return this.terminated == 1;
        }

        final boolean isFailed() {
            return this.terminated == 2;
        }

        @Override
        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.addCap(REQUESTED, this, n);
                if (this.terminated != 0) {
                    return;
                }
                if (this.batchSize == Integer.MAX_VALUE || n == Long.MAX_VALUE) {
                    this.requestMore(Long.MAX_VALUE);
                } else {
                    long requestLimit = Operators.multiplyCap(this.requested, this.batchSize);
                    if (requestLimit > this.outstanding) {
                        this.requestMore(requestLimit - this.outstanding);
                    }
                }
            }
        }

        final void requestMore(long n) {
            Subscription s2 = this.subscription;
            if (s2 != null) {
                Operators.addCap(OUTSTANDING, this, n);
                s2.request(n);
            }
        }

        @Override
        public CoreSubscriber<? super C> actual() {
            return this.actual;
        }

        @Override
        public void onComplete() {
            if (TERMINATED.compareAndSet(this, 0, 1)) {
                this.timer.dispose();
                this.checkedComplete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable throwable) {
            if (TERMINATED.compareAndSet(this, 0, 2)) {
                this.timer.dispose();
                Context ctx = this.actual.currentContext();
                BufferTimeoutSubscriber bufferTimeoutSubscriber = this;
                synchronized (bufferTimeoutSubscriber) {
                    C v = this.values;
                    if (v != null) {
                        Operators.onDiscardMultiple(v, ctx);
                        v.clear();
                        this.values = null;
                    }
                }
                this.actual.onError(throwable);
            }
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.subscription, s2)) {
                this.subscription = s2;
                this.doOnSubscribe();
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void cancel() {
            if (TERMINATED.compareAndSet(this, 0, 3)) {
                C v;
                this.timer.dispose();
                Subscription s2 = this.subscription;
                if (s2 != null) {
                    this.subscription = null;
                    s2.cancel();
                }
                if ((v = this.values) != null) {
                    Operators.onDiscardMultiple(v, this.actual.currentContext());
                    v.clear();
                }
            }
        }
    }

    static final class BufferTimeoutWithBackpressureSubscriber<T, C extends Collection<? super T>>
    implements InnerOperator<T, C> {
        @Nullable
        final Logger logger;
        final CoreSubscriber<? super C> actual;
        final int batchSize;
        final int prefetch;
        final long timeSpan;
        final TimeUnit unit;
        final Scheduler.Worker timer;
        final Supplier<C> bufferSupplier;
        volatile long requested;
        private AtomicLongFieldUpdater<BufferTimeoutWithBackpressureSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(BufferTimeoutWithBackpressureSubscriber.class, "requested");
        volatile int index;
        private AtomicIntegerFieldUpdater<BufferTimeoutWithBackpressureSubscriber> INDEX = AtomicIntegerFieldUpdater.newUpdater(BufferTimeoutWithBackpressureSubscriber.class, "index");
        volatile long outstanding;
        private AtomicLongFieldUpdater<BufferTimeoutWithBackpressureSubscriber> OUTSTANDING = AtomicLongFieldUpdater.newUpdater(BufferTimeoutWithBackpressureSubscriber.class, "outstanding");
        volatile int wip;
        private AtomicIntegerFieldUpdater<BufferTimeoutWithBackpressureSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(BufferTimeoutWithBackpressureSubscriber.class, "wip");
        private volatile int terminated = 0;
        private AtomicIntegerFieldUpdater<BufferTimeoutWithBackpressureSubscriber> TERMINATED = AtomicIntegerFieldUpdater.newUpdater(BufferTimeoutWithBackpressureSubscriber.class, "terminated");
        static final int NOT_TERMINATED = 0;
        static final int TERMINATED_WITH_SUCCESS = 1;
        static final int TERMINATED_WITH_ERROR = 2;
        static final int TERMINATED_WITH_CANCEL = 3;
        @Nullable
        private Subscription subscription;
        private Queue<T> queue;
        @Nullable
        Throwable error;
        boolean completed;
        Disposable currentTimeoutTask;

        public BufferTimeoutWithBackpressureSubscriber(CoreSubscriber<? super C> actual, int batchSize, long timeSpan, TimeUnit unit, Scheduler.Worker timer, Supplier<C> bufferSupplier, @Nullable Logger logger) {
            this.actual = actual;
            this.batchSize = batchSize;
            this.timeSpan = timeSpan;
            this.unit = unit;
            this.timer = timer;
            this.bufferSupplier = bufferSupplier;
            this.logger = logger;
            this.prefetch = batchSize << 2;
            this.queue = Queues.get(this.prefetch).get();
        }

        private void trace(Logger logger, String msg) {
            logger.trace(String.format("[%s][%s]", Thread.currentThread().getId(), msg));
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.subscription, s2)) {
                this.subscription = s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.logger != null) {
                this.trace(this.logger, "onNext: " + t2);
            }
            if (this.terminated == 0) {
                int index;
                if (!this.queue.offer(t2)) {
                    Throwable error;
                    Context ctx = this.currentContext();
                    this.error = error = Operators.onOperatorError(this.subscription, Exceptions.failWithOverflow("Queue is full: Reactive Streams source doesn't respect backpressure"), t2, this.actual.currentContext());
                    if (!this.TERMINATED.compareAndSet(this, 0, 2)) {
                        Operators.onErrorDropped(error, ctx);
                        return;
                    }
                    Operators.onDiscard(t2, ctx);
                    this.drain();
                    return;
                }
                boolean shouldDrain = false;
                while (!this.INDEX.compareAndSet(this, index = this.index, index + 1)) {
                }
                if (index == 0) {
                    try {
                        if (this.logger != null) {
                            this.trace(this.logger, "timerStart");
                        }
                        this.currentTimeoutTask = this.timer.schedule(this::bufferTimedOut, this.timeSpan, this.unit);
                    }
                    catch (RejectedExecutionException ree) {
                        if (this.logger != null) {
                            this.trace(this.logger, "Timer rejected for " + t2);
                        }
                        Context ctx = this.actual.currentContext();
                        RuntimeException error = Operators.onRejectedExecution(ree, this.subscription, null, t2, ctx);
                        this.error = error;
                        if (!this.TERMINATED.compareAndSet(this, 0, 2)) {
                            Operators.onDiscard(t2, ctx);
                            Operators.onErrorDropped(error, ctx);
                            return;
                        }
                        if (this.logger != null) {
                            this.trace(this.logger, "Discarding upon timer rejection" + t2);
                        }
                        Operators.onDiscard(t2, ctx);
                        this.drain();
                        return;
                    }
                }
                if ((index + 1) % this.batchSize == 0) {
                    shouldDrain = true;
                }
                if (shouldDrain) {
                    if (this.currentTimeoutTask != null) {
                        this.currentTimeoutTask.dispose();
                    }
                    this.index = 0;
                    this.drain();
                }
            } else {
                if (this.logger != null) {
                    this.trace(this.logger, "Discarding onNext: " + t2);
                }
                Operators.onDiscard(t2, this.currentContext());
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.currentTimeoutTask != null) {
                this.currentTimeoutTask.dispose();
            }
            this.timer.dispose();
            if (!this.TERMINATED.compareAndSet(this, 0, 2)) {
                Operators.onErrorDropped(t2, this.currentContext());
                return;
            }
            this.error = t2;
            this.drain();
        }

        @Override
        public void onComplete() {
            if (this.currentTimeoutTask != null) {
                this.currentTimeoutTask.dispose();
            }
            this.timer.dispose();
            if (this.TERMINATED.compareAndSet(this, 0, 1)) {
                this.drain();
            }
        }

        @Override
        public CoreSubscriber<? super C> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            if (Operators.validate(n)) {
                if (this.queue.isEmpty() && this.terminated != 0) {
                    return;
                }
                if (Operators.addCap(this.REQUESTED, this, n) == 0L) {
                    this.drain();
                }
                if (this.batchSize == Integer.MAX_VALUE || n == Long.MAX_VALUE) {
                    this.requestMore(Long.MAX_VALUE);
                } else {
                    long requestLimit = this.prefetch;
                    if (requestLimit > this.outstanding) {
                        if (this.logger != null) {
                            this.trace(this.logger, "requestMore: " + (requestLimit - this.outstanding) + ", outstanding: " + this.outstanding);
                        }
                        this.requestMore(requestLimit - this.outstanding);
                    }
                }
            }
        }

        private void requestMore(long n) {
            Subscription s2 = this.subscription;
            if (s2 != null) {
                Operators.addCap(this.OUTSTANDING, this, n);
                s2.request(n);
            }
        }

        @Override
        public void cancel() {
            if (this.logger != null) {
                this.trace(this.logger, "cancel");
            }
            if (this.TERMINATED.compareAndSet(this, 0, 3) && this.subscription != null) {
                this.subscription.cancel();
            }
            if (this.currentTimeoutTask != null) {
                this.currentTimeoutTask.dispose();
            }
            this.timer.dispose();
            this.drain();
        }

        void bufferTimedOut() {
            if (this.logger != null) {
                this.trace(this.logger, "timerFire");
            }
            this.index = 0;
            this.drain();
        }

        private void drain() {
            block12: {
                int wip;
                if (this.WIP.getAndIncrement(this) != 0) break block12;
                do {
                    wip = this.wip;
                    if (this.logger != null) {
                        this.trace(this.logger, "drain. wip: " + wip);
                    }
                    if (this.terminated == 0) {
                        while (this.flushABuffer()) {
                        }
                    } else {
                        if (this.completed) {
                            if (this.logger != null) {
                                this.trace(this.logger, "Discarding entire queue of " + this.queue.size());
                            }
                            Operators.onDiscardQueueWithClear(this.queue, this.currentContext(), null);
                            return;
                        }
                        if (this.terminated == 3) {
                            if (this.logger != null) {
                                this.trace(this.logger, "Discarding entire queue of " + this.queue.size());
                            }
                            Operators.onDiscardQueueWithClear(this.queue, this.currentContext(), null);
                            return;
                        }
                        while (this.flushABuffer()) {
                        }
                        if (this.queue.isEmpty()) {
                            this.completed = true;
                            if (this.error != null) {
                                this.actual.onError(this.error);
                                continue;
                            }
                            this.actual.onComplete();
                            continue;
                        }
                        if (this.logger == null) continue;
                        this.trace(this.logger, "Queue not empty after termination");
                    }
                } while (!this.WIP.compareAndSet(this, wip, 0));
            }
        }

        boolean flushABuffer() {
            long requested = this.requested;
            if (requested != 0L) {
                T element = this.queue.poll();
                if (element == null) {
                    return false;
                }
                Collection buffer = (Collection)this.bufferSupplier.get();
                int i = 0;
                do {
                    buffer.add(element);
                } while (++i < this.batchSize && (element = this.queue.poll()) != null);
                if (requested != Long.MAX_VALUE) {
                    requested = this.REQUESTED.decrementAndGet(this);
                }
                if (this.logger != null) {
                    this.trace(this.logger, "flush: " + buffer + ", now requested: " + requested);
                }
                this.actual.onNext(buffer);
                if (requested != Long.MAX_VALUE) {
                    int replenishMark;
                    if (this.logger != null) {
                        this.trace(this.logger, "outstanding(" + this.outstanding + ") -= " + i);
                    }
                    long remaining = this.OUTSTANDING.addAndGet(this, -i);
                    if (this.terminated == 0 && remaining < (long)(replenishMark = this.prefetch >> 1)) {
                        if (this.logger != null) {
                            this.trace(this.logger, "replenish: " + ((long)this.prefetch - remaining) + ", outstanding: " + this.outstanding);
                        }
                        this.requestMore((long)this.prefetch - remaining);
                    }
                    if (requested <= 0L) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.subscription;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.terminated == 3;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.terminated == 2 || this.terminated == 1;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.CAPACITY) {
                return this.prefetch;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.queue.size();
            }
            if (key == Scannable.Attr.RUN_ON) {
                return this.timer;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.ASYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }
    }
}

