/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.DisableStatisticsTimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.basic.OperatorType;
import org.apache.iotdb.tsfile.read.filter.basic.TimeFilter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public final class TimeFilterOperators {
    private static final String OPERATOR_TO_STRING_FORMAT = "time %s %s";

    private TimeFilterOperators() {
    }

    public static final class TimeNotIn
    extends TimeColumnSetFilter {
        public TimeNotIn(Set<Long> candidates) {
            super(candidates);
        }

        public TimeNotIn(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return !this.candidates.contains(time);
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            return Collections.singletonList(new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE));
        }

        @Override
        public Filter reverse() {
            return new TimeIn(this.candidates);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.TIME_NOT_IN;
        }
    }

    public static final class TimeIn
    extends TimeColumnSetFilter {
        public TimeIn(Set<Long> candidates) {
            super(candidates);
        }

        public TimeIn(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return this.candidates.contains(time);
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            ArrayList<TimeRange> res = new ArrayList<TimeRange>();
            Iterator iterator = this.candidates.iterator();
            while (iterator.hasNext()) {
                long time = (Long)iterator.next();
                res.add(new TimeRange(time, time));
            }
            return res;
        }

        @Override
        public Filter reverse() {
            return new TimeNotIn(this.candidates);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.TIME_IN;
        }
    }

    static abstract class TimeColumnSetFilter
    extends DisableStatisticsTimeFilter {
        protected final Set<Long> candidates;

        protected TimeColumnSetFilter(Set<Long> candidates) {
            this.candidates = Objects.requireNonNull(candidates, "candidates cannot be null");
        }

        protected TimeColumnSetFilter(ByteBuffer buffer) {
            this.candidates = ReadWriteIOUtils.readLongSet(buffer);
        }

        @Override
        public void serialize(DataOutputStream outputStream) throws IOException {
            super.serialize(outputStream);
            ReadWriteIOUtils.writeLongSet(this.candidates, outputStream);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeColumnSetFilter that = (TimeColumnSetFilter)o;
            return this.candidates.equals(that.candidates);
        }

        public int hashCode() {
            return Objects.hash(this.candidates);
        }

        public String toString() {
            return String.format(TimeFilterOperators.OPERATOR_TO_STRING_FORMAT, this.getOperatorType().getSymbol(), this.candidates);
        }
    }

    public static final class TimeNotBetweenAnd
    extends TimeColumnRangeFilter {
        public TimeNotBetweenAnd(Long min2, Long max) {
            super(min2, max);
        }

        public TimeNotBetweenAnd(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return time < this.min || time > this.max;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return startTime < this.min || endTime > this.max;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return startTime > this.max || endTime < this.min;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            ArrayList<TimeRange> res = new ArrayList<TimeRange>();
            if (this.min != Long.MIN_VALUE) {
                res.add(new TimeRange(Long.MIN_VALUE, this.min - 1L));
            }
            if (this.max != Long.MAX_VALUE) {
                res.add(new TimeRange(this.max + 1L, Long.MAX_VALUE));
            }
            return res;
        }

        @Override
        public Filter reverse() {
            return new TimeBetweenAnd(this.min, this.max);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.TIME_NOT_BETWEEN_AND;
        }
    }

    public static final class TimeBetweenAnd
    extends TimeColumnRangeFilter {
        public TimeBetweenAnd(long min2, long max) {
            super(min2, max);
        }

        public TimeBetweenAnd(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return time >= this.min && time <= this.max;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return startTime <= this.max && endTime >= this.min;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return startTime >= this.min && endTime <= this.max;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            return Collections.singletonList(new TimeRange(this.min, this.max));
        }

        @Override
        public Filter reverse() {
            return new TimeNotBetweenAnd((Long)this.min, (Long)this.max);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.TIME_BETWEEN_AND;
        }
    }

    static abstract class TimeColumnRangeFilter
    extends TimeFilter {
        protected final long min;
        protected final long max;

        protected TimeColumnRangeFilter(long min2, long max) {
            this.min = min2;
            this.max = max;
        }

        protected TimeColumnRangeFilter(ByteBuffer buffer) {
            this.min = ReadWriteIOUtils.readLong(buffer);
            this.max = ReadWriteIOUtils.readLong(buffer);
        }

        @Override
        public void serialize(DataOutputStream outputStream) throws IOException {
            super.serialize(outputStream);
            ReadWriteIOUtils.write(this.min, (OutputStream)outputStream);
            ReadWriteIOUtils.write(this.max, (OutputStream)outputStream);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeColumnRangeFilter that = (TimeColumnRangeFilter)o;
            return this.min == that.min && this.max == that.max;
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max);
        }

        public String toString() {
            return String.format("time %s %s AND %s", this.getOperatorType().getSymbol(), this.min, this.max);
        }
    }

    public static final class TimeGtEq
    extends TimeColumnCompareFilter {
        public TimeGtEq(long constant) {
            super(constant);
        }

        public TimeGtEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return time >= this.constant;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return this.constant <= endTime;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return startTime >= this.constant;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            return Collections.singletonList(new TimeRange(this.constant, Long.MAX_VALUE));
        }

        @Override
        public Filter reverse() {
            return new TimeLt(this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.TIME_GTEQ;
        }
    }

    public static final class TimeGt
    extends TimeColumnCompareFilter {
        public TimeGt(long constant) {
            super(constant);
        }

        public TimeGt(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return time > this.constant;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return this.constant < endTime;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return startTime > this.constant;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            long left = this.constant;
            if (left != Long.MAX_VALUE) {
                return Collections.singletonList(new TimeRange(left + 1L, Long.MAX_VALUE));
            }
            return Collections.emptyList();
        }

        @Override
        public Filter reverse() {
            return new TimeLtEq(this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.TIME_GT;
        }
    }

    public static final class TimeLtEq
    extends TimeColumnCompareFilter {
        public TimeLtEq(long constant) {
            super(constant);
        }

        public TimeLtEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return time <= this.constant;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return this.constant >= startTime;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return endTime <= this.constant;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            return Collections.singletonList(new TimeRange(Long.MIN_VALUE, this.constant));
        }

        @Override
        public Filter reverse() {
            return new TimeGt(this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.TIME_LTEQ;
        }
    }

    public static final class TimeLt
    extends TimeColumnCompareFilter {
        public TimeLt(long constant) {
            super(constant);
        }

        public TimeLt(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return time < this.constant;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return startTime < this.constant;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return endTime < this.constant;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            long right = this.constant;
            if (right != Long.MIN_VALUE) {
                return Collections.singletonList(new TimeRange(Long.MIN_VALUE, right - 1L));
            }
            return Collections.emptyList();
        }

        @Override
        public Filter reverse() {
            return new TimeGtEq(this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.TIME_LT;
        }
    }

    public static final class TimeNotEq
    extends TimeColumnCompareFilter {
        public TimeNotEq(long constant) {
            super(constant);
        }

        public TimeNotEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return this.constant != time;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return this.constant != startTime || this.constant != endTime;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return this.constant < startTime || this.constant > endTime;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            long time = this.constant;
            if (time == Long.MIN_VALUE) {
                return Collections.singletonList(new TimeRange(time + 1L, Long.MAX_VALUE));
            }
            if (time == Long.MAX_VALUE) {
                return Collections.singletonList(new TimeRange(Long.MIN_VALUE, time - 1L));
            }
            return Arrays.asList(new TimeRange(Long.MIN_VALUE, time - 1L), new TimeRange(time + 1L, Long.MAX_VALUE));
        }

        @Override
        public Filter reverse() {
            return new TimeEq(this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.TIME_NEQ;
        }
    }

    public static final class TimeEq
    extends TimeColumnCompareFilter {
        public TimeEq(long constant) {
            super(constant);
        }

        public TimeEq(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public boolean timeSatisfy(long time) {
            return this.constant == time;
        }

        @Override
        public boolean satisfyStartEndTime(long startTime, long endTime) {
            return this.constant <= endTime && this.constant >= startTime;
        }

        @Override
        public boolean containStartEndTime(long startTime, long endTime) {
            return this.constant == startTime && this.constant == endTime;
        }

        @Override
        public List<TimeRange> getTimeRanges() {
            return Collections.singletonList(new TimeRange(this.constant, this.constant));
        }

        @Override
        public Filter reverse() {
            return new TimeNotEq(this.constant);
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.TIME_EQ;
        }
    }

    static abstract class TimeColumnCompareFilter
    extends TimeFilter {
        protected final long constant;

        protected TimeColumnCompareFilter(long constant) {
            this.constant = constant;
        }

        protected TimeColumnCompareFilter(ByteBuffer buffer) {
            this.constant = ReadWriteIOUtils.readLong(buffer);
        }

        @Override
        public void serialize(DataOutputStream outputStream) throws IOException {
            super.serialize(outputStream);
            ReadWriteIOUtils.write(this.constant, (OutputStream)outputStream);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeColumnCompareFilter that = (TimeColumnCompareFilter)o;
            return this.constant == that.constant;
        }

        public int hashCode() {
            return Objects.hash(this.constant);
        }

        public String toString() {
            return String.format(TimeFilterOperators.OPERATOR_TO_STRING_FORMAT, this.getOperatorType().getSymbol(), this.constant);
        }
    }
}

