/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.iotdb.tsfile.encoding.encoder.RLBE;

public class FloatRLBE
extends RLBE {
    private float[] DiffValue;
    private int[] Lengrle;
    private float previousvalue;

    public FloatRLBE() {
        this.DiffValue = new float[this.blockSize + 1];
        this.Lengrle = new int[this.blockSize + 1];
        this.reset();
    }

    protected void reset() {
        this.writeIndex = -1;
        this.LengthCode = new int[this.blockSize + 1];
        for (int i = 0; i < this.blockSize; ++i) {
            this.DiffValue[i] = 0.0f;
            this.LengthCode[i] = 0;
            this.byteBuffer = 0;
            this.numberLeftInBuffer = 0;
            this.Lengrle[i] = 0;
        }
    }

    private int calBinarylength(float v) {
        int i;
        int val = Float.floatToRawIntBits(v);
        if (val == 0) {
            return 1;
        }
        for (i = 32; (1 << i - 1 & val) == 0 && i > 0; --i) {
        }
        return i;
    }

    private int calBinarylength(int val) {
        int i;
        if (val == 0) {
            return 1;
        }
        for (i = 32; (1 << i - 1 & val) == 0 && i > 0; --i) {
        }
        return i;
    }

    public void encodeValue(float value, ByteArrayOutputStream out) {
        if (this.writeIndex == -1) {
            this.DiffValue[++this.writeIndex] = value;
            this.LengthCode[this.writeIndex] = this.calBinarylength(value);
            this.previousvalue = value;
            return;
        }
        this.DiffValue[++this.writeIndex] = value - this.previousvalue;
        this.LengthCode[this.writeIndex] = this.calBinarylength(this.DiffValue[this.writeIndex]);
        this.previousvalue = value;
        if (this.writeIndex == this.blockSize - 1) {
            this.flush(out);
        }
    }

    @Override
    public void encode(float value, ByteArrayOutputStream out) {
        this.encodeValue(value, out);
    }

    @Override
    public void flush(ByteArrayOutputStream out) {
        this.flushBlock(out);
    }

    protected int calcFibonacci(int val) {
        int[] Fib = new int[this.blockSize * 2 + 1];
        Fib[0] = 1;
        Fib[1] = 1;
        int i = 2;
        while (Fib[i - 1] <= val) {
            Fib[i] = Fib[i - 1] + Fib[i - 2];
            ++i;
        }
        --i;
        int valfib = 0;
        while (val > 0) {
            while (Fib[i] > val && i >= 1) {
                --i;
            }
            valfib |= 1 << i - 1;
            val -= Fib[i];
        }
        return valfib;
    }

    private void rleonlengthcode() {
        int i = 0;
        while (i <= this.writeIndex) {
            int j = i;
            int temprlecal = 0;
            while (this.LengthCode[j] == this.LengthCode[i] && j <= this.writeIndex) {
                ++j;
                ++temprlecal;
            }
            this.Lengrle[i] = temprlecal;
            i = j;
        }
    }

    protected void flushBlock(ByteArrayOutputStream out) {
        if (this.writeIndex == -1) {
            return;
        }
        this.writewriteIndex(out);
        this.rleonlengthcode();
        for (int i = 0; i <= this.writeIndex; ++i) {
            if (this.Lengrle[i] <= 0) continue;
            try {
                this.flushsegment(i, out);
                continue;
            }
            catch (IOException e) {
                logger.error("flush data to stream failed!", e);
            }
        }
        this.clearBuffer(out);
        this.reset();
    }

    private void flushsegment(int i, ByteArrayOutputStream out) throws IOException {
        int j;
        for (int j2 = 5; j2 >= 0; --j2) {
            if ((this.LengthCode[i] & 1 << j2) > 0) {
                this.writeBit(true, out);
                continue;
            }
            this.writeBit(false, out);
        }
        int fib = this.calcFibonacci(this.Lengrle[i]);
        int fiblen = this.calBinarylength(fib);
        for (j = 0; j < fiblen; ++j) {
            if ((fib & 1 << j) > 0) {
                this.writeBit(true, out);
                continue;
            }
            this.writeBit(false, out);
        }
        this.writeBit(true, out);
        j = i;
        do {
            int tempDifflen = this.calBinarylength(this.DiffValue[j]);
            int tempDiff = Float.floatToRawIntBits(this.DiffValue[j]);
            for (int k = tempDifflen - 1; k >= 0; --k) {
                if ((tempDiff & 1 << k) > 0) {
                    this.writeBit(true, out);
                    continue;
                }
                this.writeBit(false, out);
            }
        } while (this.Lengrle[++j] == 0 && j <= this.writeIndex);
    }

    @Override
    public int getOneItemMaxSize() {
        return 16;
    }

    @Override
    public long getMaxByteSize() {
        return 20 * this.blockSize;
    }

    protected void writeBit(boolean b, ByteArrayOutputStream out) {
        this.byteBuffer = (byte)(this.byteBuffer << 1);
        if (b) {
            this.byteBuffer = (byte)(this.byteBuffer | 1);
        }
        ++this.numberLeftInBuffer;
        if (this.numberLeftInBuffer == 8) {
            this.clearBuffer(out);
        }
    }

    protected void clearBuffer(ByteArrayOutputStream out) {
        if (this.numberLeftInBuffer == 0) {
            return;
        }
        if (this.numberLeftInBuffer > 0) {
            this.byteBuffer = (byte)(this.byteBuffer << 8 - this.numberLeftInBuffer);
        }
        out.write(this.byteBuffer);
        this.numberLeftInBuffer = 0;
        this.byteBuffer = 0;
    }

    private void writewriteIndex(ByteArrayOutputStream out) {
        for (int i = 31; i >= 0; --i) {
            if ((this.writeIndex + 1 & 1 << i) > 0) {
                this.writeBit(true, out);
                continue;
            }
            this.writeBit(false, out);
        }
    }
}

