/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TEndpointTransport;
import org.apache.thrift.transport.TTransportException;

public class ConfigurableTByteBuffer
extends TEndpointTransport {
    private final ByteBuffer byteBuffer;

    public ConfigurableTByteBuffer(ByteBuffer byteBuffer) throws TTransportException {
        this(byteBuffer, new TConfiguration());
    }

    public ConfigurableTByteBuffer(ByteBuffer byteBuffer, TConfiguration configuration) throws TTransportException {
        super(configuration);
        this.byteBuffer = byteBuffer;
        this.updateKnownMessageSize(byteBuffer.capacity());
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        this.checkReadBytesAvailable(len);
        int n = Math.min(this.byteBuffer.remaining(), len);
        if (n > 0) {
            try {
                this.byteBuffer.get(buf, off, n);
            }
            catch (BufferUnderflowException e) {
                throw new TTransportException("Unexpected end of input buffer", (Throwable)e);
            }
        }
        return n;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        try {
            this.byteBuffer.put(buf, off, len);
        }
        catch (BufferOverflowException e) {
            throw new TTransportException("Not enough room in output buffer", (Throwable)e);
        }
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public ConfigurableTByteBuffer clear() {
        this.byteBuffer.clear();
        return this;
    }

    public ConfigurableTByteBuffer flip() {
        this.byteBuffer.flip();
        return this;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.byteBuffer.remaining()];
        this.byteBuffer.slice().get(data);
        return data;
    }
}

