/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.sql.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.flink.sql.common.Options;
import org.apache.iotdb.flink.sql.common.Utils;
import org.apache.iotdb.flink.sql.exception.IllegalIoTDBPathException;
import org.apache.iotdb.flink.sql.wrapper.SchemaWrapper;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class IoTDBSinkFunction
implements SinkFunction<RowData> {
    private final List<Tuple2<String, DataType>> schema;
    private final List<String> nodeUrls;
    private final String user;
    private final String password;
    private final boolean aligned;
    private final Map<String, List<String>> deviceMeasurementMap;
    private final List<String> fields;
    private final List<TSDataType> dataTypes;
    private static final Map<DataType, TSDataType> TYPE_MAP = new HashMap<DataType, TSDataType>();
    private static Session session;

    public IoTDBSinkFunction(ReadableConfig options, SchemaWrapper schemaWrapper) {
        this.schema = schemaWrapper.getSchema();
        this.nodeUrls = Arrays.asList(((String)options.get(Options.NODE_URLS)).split(","));
        this.user = (String)options.get(Options.USER);
        this.password = (String)options.get(Options.PASSWORD);
        this.aligned = (Boolean)options.get(Options.ALIGNED);
        this.fields = this.schema.stream().map(field -> String.valueOf(field.f0)).collect(Collectors.toList());
        this.deviceMeasurementMap = this.parseFieldNames(this.fields);
        this.dataTypes = this.schema.stream().map(field -> TYPE_MAP.get(field.f1)).collect(Collectors.toList());
    }

    public void invoke(RowData rowData, SinkFunction.Context context) throws Exception {
        if (session == null) {
            session = new Session.Builder().nodeUrls(this.nodeUrls).username(this.user).password(this.password).build();
            session.open(false);
        }
        if (rowData.getRowKind().equals((Object)RowKind.INSERT) || rowData.getRowKind().equals((Object)RowKind.UPDATE_AFTER)) {
            long timestamp = rowData.getLong(0);
            for (Map.Entry<String, List<String>> entry : this.deviceMeasurementMap.entrySet()) {
                ArrayList<String> measurementsOfRow = new ArrayList<String>();
                ArrayList<TSDataType> dataTypesOfRow = new ArrayList<TSDataType>();
                ArrayList<Object> values = new ArrayList<Object>();
                for (String measurement : entry.getValue()) {
                    int indexInSchema = this.fields.indexOf(String.format("%s.%s", entry.getKey(), measurement));
                    Object value = Utils.getValue(rowData, (DataType)this.schema.get((int)indexInSchema).f1, indexInSchema + 1);
                    if (value == null) continue;
                    measurementsOfRow.add(measurement);
                    dataTypesOfRow.add(this.dataTypes.get(indexInSchema));
                    values.add(value);
                }
                if (this.aligned) {
                    session.insertAlignedRecord(entry.getKey(), timestamp, measurementsOfRow, dataTypesOfRow, values);
                    continue;
                }
                session.insertRecord(entry.getKey(), timestamp, measurementsOfRow, dataTypesOfRow, values);
            }
        } else if (rowData.getRowKind().equals((Object)RowKind.DELETE)) {
            session.deleteData(this.fields, rowData.getLong(0));
        }
    }

    public void finish() throws Exception {
        if (session != null) {
            session.close();
        }
    }

    private Map<String, List<String>> parseFieldNames(List<String> fieldNames) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        for (String fieldName : fieldNames) {
            try {
                String[] nodes = PathUtils.splitPathToDetachedNodes(fieldName);
                String measurement = nodes[nodes.length - 1];
                String device = StringUtils.join((Object[])Arrays.copyOfRange(nodes, 0, nodes.length - 1), '.');
                resultMap.putIfAbsent(device, new ArrayList());
                resultMap.get(device).add(measurement);
            }
            catch (IllegalPathException e) {
                throw new IllegalIoTDBPathException(e.getMessage());
            }
        }
        return resultMap;
    }

    static {
        TYPE_MAP.put(DataTypes.INT(), TSDataType.INT32);
        TYPE_MAP.put(DataTypes.BIGINT(), TSDataType.INT64);
        TYPE_MAP.put(DataTypes.FLOAT(), TSDataType.FLOAT);
        TYPE_MAP.put(DataTypes.DOUBLE(), TSDataType.DOUBLE);
        TYPE_MAP.put(DataTypes.BOOLEAN(), TSDataType.BOOLEAN);
        TYPE_MAP.put(DataTypes.STRING(), TSDataType.TEXT);
    }
}

