/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public abstract class UDTFValueTrend
implements UDTF {
    protected boolean hasPrevious = false;
    protected int previousInt = 0;
    protected long previousLong = 0L;
    protected float previousFloat = 0.0f;
    protected double previousDouble = 0.0;
    protected TSDataType dataType;

    @Override
    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
    }

    protected void updatePreviousValue(Row row) throws UDFInputSeriesDataTypeNotValidException, IOException {
        switch (this.dataType) {
            case INT32: {
                this.previousInt = row.getInt(0);
                break;
            }
            case INT64: {
                this.previousLong = row.getLong(0);
                break;
            }
            case FLOAT: {
                this.previousFloat = row.getFloat(0);
                break;
            }
            case DOUBLE: {
                this.previousDouble = row.getDouble(0);
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
            }
        }
    }

    protected abstract void doTransform(Row var1, PointCollector var2) throws UDFInputSeriesDataTypeNotValidException, IOException;
}

