/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFOnOff
implements UDTF {
    protected double threshold;
    private TSDataType dataType;

    @Override
    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validateRequiredAttribute("threshold");
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws MetadataException {
        this.threshold = parameters.getDouble("threshold");
        this.dataType = UDFDataTypeTransformer.transformToTsDataType(parameters.getDataType(0));
        configurations.setAccessStrategy(new MappableRowByRowAccessStrategy()).setOutputDataType(Type.BOOLEAN);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws UDFInputSeriesDataTypeNotValidException, IOException {
        long time = row.getTime();
        switch (this.dataType) {
            case INT32: {
                collector.putBoolean(time, (double)row.getInt(0) >= this.threshold);
                break;
            }
            case INT64: {
                collector.putBoolean(time, (double)row.getLong(0) >= this.threshold);
                break;
            }
            case FLOAT: {
                collector.putBoolean(time, (double)row.getFloat(0) >= this.threshold);
                break;
            }
            case DOUBLE: {
                collector.putBoolean(time, row.getDouble(0) >= this.threshold);
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
            }
        }
    }

    @Override
    public Object transform(Row row) throws IOException {
        if (row.isNull(0)) {
            return null;
        }
        switch (this.dataType) {
            case INT32: {
                return (double)row.getInt(0) >= this.threshold;
            }
            case INT64: {
                return (double)row.getLong(0) >= this.threshold;
            }
            case FLOAT: {
                return (double)row.getFloat(0) >= this.threshold;
            }
            case DOUBLE: {
                return row.getDouble(0) >= this.threshold;
            }
        }
        throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
    }

    @Override
    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        switch (this.dataType) {
            case INT32: {
                this.transformInt(columns, builder);
                return;
            }
            case INT64: {
                this.transformLong(columns, builder);
                return;
            }
            case FLOAT: {
                this.transformFloat(columns, builder);
                return;
            }
            case DOUBLE: {
                this.transformDouble(columns, builder);
                return;
            }
        }
        throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
    }

    private void transformInt(Column[] columns, ColumnBuilder builder) {
        int[] inputs = columns[0].getInts();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            builder.writeBoolean((double)inputs[i] >= this.threshold);
        }
    }

    private void transformLong(Column[] columns, ColumnBuilder builder) {
        long[] inputs = columns[0].getLongs();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            builder.writeBoolean((double)inputs[i] >= this.threshold);
        }
    }

    private void transformFloat(Column[] columns, ColumnBuilder builder) {
        float[] inputs = columns[0].getFloats();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            builder.writeBoolean((double)inputs[i] >= this.threshold);
        }
    }

    private void transformDouble(Column[] columns, ColumnBuilder builder) {
        double[] inputs = columns[0].getDoubles();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            builder.writeBoolean(inputs[i] >= this.threshold);
        }
    }
}

