/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFContains
implements UDTF {
    private String s;

    @Override
    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateRequiredAttribute("s").validateInputSeriesDataType(0, Type.TEXT);
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        this.s = parameters.getString("s");
        configurations.setAccessStrategy(new MappableRowByRowAccessStrategy()).setOutputDataType(Type.BOOLEAN);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        collector.putBoolean(row.getTime(), row.getString(0).contains(this.s));
    }

    @Override
    public Object transform(Row row) throws IOException {
        if (row.isNull(0)) {
            return null;
        }
        return row.getString(0).contains(this.s);
    }

    @Override
    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        Binary[] inputs = columns[0].getBinaries();
        boolean[] isNulls = columns[0].isNull();
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (isNulls[i]) {
                builder.appendNull();
                continue;
            }
            String str = inputs[i].getStringValue(TSFileConfig.STRING_CHARSET);
            builder.writeBoolean(str.contains(this.s));
        }
    }
}

