/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin.String;

import java.io.IOException;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFConcat
implements UDTF {
    private boolean seriesBehind;
    private final StringBuilder concatTargets = new StringBuilder();

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        int size = validator.getParameters().getChildExpressions().size();
        for (int i = 0; i < size; ++i) {
            validator.validateInputSeriesDataType(i, Type.TEXT);
        }
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        parameters.getAttributes().forEach((key, value) -> {
            if (key.startsWith("target") && value != null) {
                this.concatTargets.append((String)value);
            }
        });
        this.seriesBehind = parameters.getBooleanOrDefault("series_behind", false);
        configurations.setAccessStrategy(new MappableRowByRowAccessStrategy()).setOutputDataType(Type.TEXT);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        StringBuilder concatSeries = new StringBuilder();
        for (int i = 0; i < row.size(); ++i) {
            if (row.isNull(i)) continue;
            concatSeries.append(row.getString(i));
        }
        collector.putString(row.getTime(), this.seriesBehind ? concatSeries.insert(0, this.concatTargets).toString() : concatSeries.append((CharSequence)this.concatTargets).toString());
    }

    @Override
    public Object transform(Row row) throws IOException {
        StringBuilder concatSeries = new StringBuilder();
        for (int i = 0; i < row.size(); ++i) {
            if (row.isNull(i)) continue;
            concatSeries.append(row.getString(i));
        }
        String res = this.seriesBehind ? concatSeries.insert(0, this.concatTargets).toString() : concatSeries.append((CharSequence)this.concatTargets).toString();
        return BytesUtils.valueOf(res);
    }

    @Override
    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        int colCount = columns.length;
        int rowCount = columns[0].getPositionCount();
        Binary[][] inputFrame = new Binary[colCount][rowCount];
        for (int i = 0; i < colCount; ++i) {
            inputFrame[i] = columns[i].getBinaries();
        }
        boolean[][] isNullFrame = new boolean[colCount][rowCount];
        for (int i = 0; i < colCount; ++i) {
            isNullFrame[i] = columns[i].isNull();
        }
        for (int row = 0; row < rowCount; ++row) {
            StringBuilder concatSeries = new StringBuilder();
            for (int col = 0; col < colCount; ++col) {
                if (isNullFrame[col][row]) continue;
                String str = inputFrame[col][row].getStringValue(TSFileConfig.STRING_CHARSET);
                concatSeries.append(str);
            }
            String res = this.seriesBehind ? concatSeries.insert(0, this.concatTargets).toString() : concatSeries.append((CharSequence)this.concatTargets).toString();
            builder.writeBinary(BytesUtils.valueOf(res));
        }
    }
}

