/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.service;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.AbstractThriftServiceThread;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.JMXService;
import org.apache.thrift.TProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThriftService
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(ThriftService.class);
    public static final String STATUS_UP = "UP";
    public static final String STATUS_DOWN = "DOWN";
    protected String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());
    protected AbstractThriftServiceThread thriftServiceThread;
    protected TProcessor processor;
    private CountDownLatch stopLatch;
    boolean setSyncedImpl = false;
    boolean setAsyncedImpl = false;

    public String getRPCServiceStatus() {
        if (this.thriftServiceThread == null) {
            logger.debug("Start latch is null when getting status");
        } else {
            logger.debug("Start status is {} when getting status", (Object)this.thriftServiceThread.isServing());
        }
        if (this.stopLatch == null) {
            logger.debug("Stop latch is null when getting status");
        } else {
            logger.debug("Stop latch is {} when getting status", (Object)this.stopLatch.getCount());
        }
        if (this.thriftServiceThread != null && this.thriftServiceThread.isServing()) {
            return STATUS_UP;
        }
        return STATUS_DOWN;
    }

    @Override
    public void start() throws StartupException {
        JMXService.registerMBean(this, this.mbeanName);
        this.startService();
    }

    @Override
    public void stop() {
        this.stopService();
        JMXService.deregisterMBean(this.mbeanName);
    }

    public void initSyncedServiceImpl(Object serviceImpl) {
        this.setSyncedImpl = true;
    }

    public void initAsyncedServiceImpl(Object serviceImpl) {
        this.setAsyncedImpl = true;
    }

    public abstract void initTProcessor() throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException;

    public abstract void initThriftServiceThread() throws IllegalAccessException, InstantiationException, ClassNotFoundException;

    public abstract String getBindIP();

    public abstract int getBindPort();

    public void startService() throws StartupException {
        if (STATUS_UP.equals(this.getRPCServiceStatus())) {
            logger.info("{}: {} has been already running now", (Object)"IoTDB", (Object)this.getID().getName());
            return;
        }
        logger.info("{}: start {}...", (Object)"IoTDB", (Object)this.getID().getName());
        try {
            this.reset();
            this.initTProcessor();
            if (!this.setSyncedImpl && !this.setAsyncedImpl) {
                throw new StartupException(this.getID().getName(), "At least one service implementation should be set.");
            }
            this.initThriftServiceThread();
            this.thriftServiceThread.setThreadStopLatch(this.stopLatch);
            this.thriftServiceThread.start();
            while (!this.thriftServiceThread.isServing()) {
                Thread.sleep(100L);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InterruptedException | NoSuchMethodException | InvocationTargetException e) {
            Thread.currentThread().interrupt();
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
        logger.info("{}: start {} successfully, listening on ip {} port {}", "IoTDB", this.getID().getName(), this.getBindIP(), this.getBindPort());
    }

    private void reset() {
        this.thriftServiceThread = null;
        this.stopLatch = new CountDownLatch(1);
    }

    public void restartService() throws StartupException {
        this.stopService();
        this.startService();
    }

    public void stopService() {
        if (STATUS_DOWN.equals(this.getRPCServiceStatus())) {
            logger.info("{}: {} isn't running now", (Object)"IoTDB", (Object)this.getID().getName());
            return;
        }
        logger.info("{}: closing {}...", (Object)"IoTDB", (Object)this.getID().getName());
        if (this.thriftServiceThread != null) {
            this.thriftServiceThread.close();
        }
        try {
            this.stopLatch.await();
            this.reset();
            logger.info("{}: close {} successfully", (Object)"IoTDB", (Object)this.getID().getName());
        }
        catch (InterruptedException e) {
            logger.error("{}: close {} failed because: ", "IoTDB", this.getID().getName(), e);
            Thread.currentThread().interrupt();
        }
    }
}

