/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.view.viewExpression.ternary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpressionType;
import org.apache.iotdb.commons.schema.view.viewExpression.ternary.TernaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class BetweenViewExpression
extends TernaryViewExpression {
    private final boolean isNotBetween;

    public BetweenViewExpression(ViewExpression firstExpression, ViewExpression secondExpression, ViewExpression thirdExpression, boolean isNotBetween) {
        super(firstExpression, secondExpression, thirdExpression);
        this.isNotBetween = isNotBetween;
    }

    public BetweenViewExpression(ViewExpression firstExpression, ViewExpression secondExpression, ViewExpression thirdExpression) {
        super(firstExpression, secondExpression, thirdExpression);
        this.isNotBetween = false;
    }

    public BetweenViewExpression(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.isNotBetween = ReadWriteIOUtils.readBool(byteBuffer);
    }

    public BetweenViewExpression(InputStream inputStream) {
        super(inputStream);
        try {
            this.isNotBetween = ReadWriteIOUtils.readBool(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R, C> R accept(ViewExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitBetweenExpression(this, context);
    }

    @Override
    public ViewExpressionType getExpressionType() {
        return ViewExpressionType.BETWEEN;
    }

    @Override
    public String toString(boolean isRoot) {
        String basicString = this.firstExpression.toString(true) + " BETWEEN " + this.secondExpression.toString(false) + " AND " + this.secondExpression.toString(false);
        if (isRoot) {
            return basicString;
        }
        return "(" + basicString + ")";
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isNotBetween, byteBuffer);
    }

    @Override
    protected void serialize(OutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.isNotBetween, stream);
    }

    public boolean isNotBetween() {
        return this.isNotBetween;
    }
}

