/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.view.viewExpression;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpressionType;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.arithmetic.AdditionViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.arithmetic.DivisionViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.arithmetic.ModuloViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.arithmetic.MultiplicationViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.arithmetic.SubtractionViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.compare.EqualToViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.compare.GreaterEqualViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.compare.GreaterThanViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.compare.LessEqualViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.compare.LessThanViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.compare.NonEqualViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.logic.LogicAndViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.binary.logic.LogicOrViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.ConstantViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.NullViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.TimeSeriesViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.leaf.TimestampViewOperand;
import org.apache.iotdb.commons.schema.view.viewExpression.multi.FunctionViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.ternary.BetweenViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.InViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.IsNullViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.LikeViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.LogicNotViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.NegationViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.RegularViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class ViewExpression {
    protected int serSize = -1;

    public <R, C> R accept(ViewExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitExpression(this, context);
    }

    public abstract ViewExpressionType getExpressionType();

    public final boolean isLeafOperand() {
        return this.isLeafOperandInternal();
    }

    protected abstract boolean isLeafOperandInternal();

    public abstract List<ViewExpression> getChildViewExpressions();

    public final boolean isSourceForAliasSeries() {
        return this.getExpressionType().getExpressionTypeInShortEnum() == ViewExpressionType.TIMESERIES.getExpressionTypeInShortEnum();
    }

    public String toString() {
        return this.toString(true);
    }

    public abstract String toString(boolean var1);

    protected abstract void serialize(ByteBuffer var1);

    protected abstract void serialize(OutputStream var1) throws IOException;

    public static void serialize(ViewExpression expression, ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write(expression.getExpressionType().getExpressionTypeInShortEnum(), byteBuffer);
        expression.serialize(byteBuffer);
    }

    public static void serialize(ViewExpression expression, OutputStream stream) throws IOException {
        ReadWriteIOUtils.write(expression.getExpressionType().getExpressionTypeInShortEnum(), stream);
        expression.serialize(stream);
    }

    public static int getSerializeSize(ViewExpression expression) {
        if (expression.serSize == -1) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ViewExpression.serialize(expression, baos);
                expression.serSize = baos.toByteArray().length;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return expression.serSize;
    }

    public static ViewExpression deserialize(ByteBuffer byteBuffer) {
        ViewExpression expression;
        short type = ReadWriteIOUtils.readShort(byteBuffer);
        switch (type) {
            case -4: {
                expression = new ConstantViewOperand(byteBuffer);
                break;
            }
            case -3: {
                expression = new TimestampViewOperand(byteBuffer);
                break;
            }
            case -2: {
                expression = new TimeSeriesViewOperand(byteBuffer);
                break;
            }
            case -1: {
                expression = new FunctionViewExpression(byteBuffer);
                break;
            }
            case 0: {
                expression = new NegationViewExpression(byteBuffer);
                break;
            }
            case 1: {
                expression = new LogicNotViewExpression(byteBuffer);
                break;
            }
            case 2: {
                expression = new MultiplicationViewExpression(byteBuffer);
                break;
            }
            case 3: {
                expression = new DivisionViewExpression(byteBuffer);
                break;
            }
            case 4: {
                expression = new ModuloViewExpression(byteBuffer);
                break;
            }
            case 5: {
                expression = new AdditionViewExpression(byteBuffer);
                break;
            }
            case 6: {
                expression = new SubtractionViewExpression(byteBuffer);
                break;
            }
            case 7: {
                expression = new EqualToViewExpression(byteBuffer);
                break;
            }
            case 8: {
                expression = new NonEqualViewExpression(byteBuffer);
                break;
            }
            case 9: {
                expression = new GreaterEqualViewExpression(byteBuffer);
                break;
            }
            case 10: {
                expression = new GreaterThanViewExpression(byteBuffer);
                break;
            }
            case 11: {
                expression = new LessEqualViewExpression(byteBuffer);
                break;
            }
            case 12: {
                expression = new LessThanViewExpression(byteBuffer);
                break;
            }
            case 13: {
                expression = new LikeViewExpression(byteBuffer);
                break;
            }
            case 14: {
                expression = new RegularViewExpression(byteBuffer);
                break;
            }
            case 15: {
                expression = new IsNullViewExpression(byteBuffer);
                break;
            }
            case 16: {
                expression = new BetweenViewExpression(byteBuffer);
                break;
            }
            case 17: {
                expression = new InViewExpression(byteBuffer);
                break;
            }
            case 18: {
                expression = new LogicAndViewExpression(byteBuffer);
                break;
            }
            case 19: {
                expression = new LogicOrViewExpression(byteBuffer);
                break;
            }
            case 20: {
                expression = new NullViewOperand();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid viewExpression type: " + type);
            }
        }
        return expression;
    }

    public static ViewExpression deserialize(InputStream inputStream) {
        try {
            ViewExpression expression;
            short type = ReadWriteIOUtils.readShort(inputStream);
            switch (type) {
                case -4: {
                    expression = new ConstantViewOperand(inputStream);
                    break;
                }
                case -3: {
                    expression = new TimestampViewOperand(inputStream);
                    break;
                }
                case -2: {
                    expression = new TimeSeriesViewOperand(inputStream);
                    break;
                }
                case -1: {
                    expression = new FunctionViewExpression(inputStream);
                    break;
                }
                case 0: {
                    expression = new NegationViewExpression(inputStream);
                    break;
                }
                case 1: {
                    expression = new LogicNotViewExpression(inputStream);
                    break;
                }
                case 2: {
                    expression = new MultiplicationViewExpression(inputStream);
                    break;
                }
                case 3: {
                    expression = new DivisionViewExpression(inputStream);
                    break;
                }
                case 4: {
                    expression = new ModuloViewExpression(inputStream);
                    break;
                }
                case 5: {
                    expression = new AdditionViewExpression(inputStream);
                    break;
                }
                case 6: {
                    expression = new SubtractionViewExpression(inputStream);
                    break;
                }
                case 7: {
                    expression = new EqualToViewExpression(inputStream);
                    break;
                }
                case 8: {
                    expression = new NonEqualViewExpression(inputStream);
                    break;
                }
                case 9: {
                    expression = new GreaterEqualViewExpression(inputStream);
                    break;
                }
                case 10: {
                    expression = new GreaterThanViewExpression(inputStream);
                    break;
                }
                case 11: {
                    expression = new LessEqualViewExpression(inputStream);
                    break;
                }
                case 12: {
                    expression = new LessThanViewExpression(inputStream);
                    break;
                }
                case 13: {
                    expression = new LikeViewExpression(inputStream);
                    break;
                }
                case 14: {
                    expression = new RegularViewExpression(inputStream);
                    break;
                }
                case 15: {
                    expression = new IsNullViewExpression(inputStream);
                    break;
                }
                case 16: {
                    expression = new BetweenViewExpression(inputStream);
                    break;
                }
                case 17: {
                    expression = new InViewExpression(inputStream);
                    break;
                }
                case 18: {
                    expression = new LogicAndViewExpression(inputStream);
                    break;
                }
                case 19: {
                    expression = new LogicOrViewExpression(inputStream);
                    break;
                }
                case 20: {
                    expression = new NullViewOperand();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid viewExpression type: " + type);
                }
            }
            return expression;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

