/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.task.meta;

import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.tsfile.utils.PublicBAOS;

public class PipeMeta {
    private final PipeStaticMeta staticMeta;
    private final PipeRuntimeMeta runtimeMeta;

    public PipeMeta(PipeStaticMeta staticMeta, PipeRuntimeMeta runtimeMeta) {
        this.staticMeta = staticMeta;
        this.runtimeMeta = runtimeMeta;
    }

    public PipeStaticMeta getStaticMeta() {
        return this.staticMeta;
    }

    public PipeRuntimeMeta getRuntimeMeta() {
        return this.runtimeMeta;
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(DataOutputStream outputStream) throws IOException {
        this.staticMeta.serialize(outputStream);
        this.runtimeMeta.serialize(outputStream);
    }

    public void serialize(FileOutputStream outputStream) throws IOException {
        this.staticMeta.serialize(outputStream);
        this.runtimeMeta.serialize(outputStream);
    }

    public static PipeMeta deserialize(FileInputStream fileInputStream) throws IOException {
        PipeStaticMeta staticMeta = PipeStaticMeta.deserialize(fileInputStream);
        PipeRuntimeMeta runtimeMeta = PipeRuntimeMeta.deserialize(fileInputStream);
        return new PipeMeta(staticMeta, runtimeMeta);
    }

    public static PipeMeta deserialize(ByteBuffer byteBuffer) {
        PipeStaticMeta staticMeta = PipeStaticMeta.deserialize(byteBuffer);
        PipeRuntimeMeta runtimeMeta = PipeRuntimeMeta.deserialize(byteBuffer);
        return new PipeMeta(staticMeta, runtimeMeta);
    }

    public String coreReportMessage() {
        return "PipeName=" + this.staticMeta.getPipeName() + ", CreationTime=" + this.staticMeta.getCreationTime() + ", ProgressIndex={" + this.runtimeMeta.getConsensusGroupId2TaskMetaMap().entrySet().stream().map(entry -> "ConsensusGroupId=" + entry.getKey() + ", ProgressIndex=" + ((PipeTaskMeta)entry.getValue()).getProgressIndex()).reduce((s1, s2) -> s1 + "; " + s2).orElse("") + "}, Exceptions={" + this.runtimeMeta.getConsensusGroupId2TaskMetaMap().entrySet().stream().filter(entry -> ((PipeTaskMeta)entry.getValue()).hasExceptionMessages()).map(entry -> "ConsensusGroupId=" + entry.getKey() + ", ExceptionMessage=" + ((PipeTaskMeta)entry.getValue()).getExceptionMessagesString()).reduce((s1, s2) -> s1 + "; " + s2).orElse("") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeMeta pipeMeta = (PipeMeta)o;
        return Objects.equals(this.staticMeta, pipeMeta.staticMeta) && Objects.equals(this.runtimeMeta, pipeMeta.runtimeMeta);
    }

    public int hashCode() {
        return Objects.hash(this.staticMeta, this.runtimeMeta);
    }

    public String toString() {
        return "PipeMeta{staticMeta=" + this.staticMeta + ", runtimeMeta=" + this.runtimeMeta + '}';
    }
}

