/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.plugin.builtin.connector.iotdb.thrift;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBThriftSyncConnectorClient;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.iotdb.IoTDBConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBMetaConnector
extends IoTDBConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBMetaConnector.class);
    private static final PipeConfig PIPE_CONFIG = PipeConfig.getInstance();
    private boolean enableSchemaSync = false;
    private boolean enableTtlSync = false;
    private boolean enableFunctionSync = false;
    private boolean enableTriggerSync = false;
    private boolean enableModelSync = false;
    private boolean enableAuthoritySync = false;
    private boolean atLeastOneEnable = false;
    private final List<IoTDBThriftSyncConnectorClient> clients = new ArrayList<IoTDBThriftSyncConnectorClient>();
    private final List<Boolean> isClientAlive = new ArrayList<Boolean>();
    private long currentClientIndex = 0L;

    @Override
    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        validator.validate(arg -> {
            HashSet<String> inclusionList = new HashSet<String>(Arrays.asList(((String)arg).replace(" ", "").split(",")));
            if (inclusionList.contains("schema")) {
                this.enableSchemaSync = true;
            }
            if (inclusionList.contains("ttl")) {
                this.enableTtlSync = true;
            }
            if (inclusionList.contains("function")) {
                this.enableFunctionSync = true;
            }
            if (inclusionList.contains("trigger")) {
                this.enableTriggerSync = true;
            }
            if (inclusionList.contains("model")) {
                this.enableModelSync = true;
            }
            if (inclusionList.contains("authority")) {
                this.enableAuthoritySync = true;
            }
            this.atLeastOneEnable = this.enableSchemaSync || this.enableTtlSync || this.enableFunctionSync || this.enableTriggerSync || this.enableModelSync || this.enableAuthoritySync;
            return this.atLeastOneEnable || inclusionList.contains("data");
        }, String.format("At least one of %s, %s, %s, %s, %s, %s, %s should be present in %s.", "data", "schema", "ttl", "function", "trigger", "model", "authority", "source.inclusion"), (Object)validator.getParameters().getStringOrDefault(Arrays.asList("extractor.inclusion", "source.inclusion"), "data, schema"));
    }

    @Override
    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        if (!this.atLeastOneEnable) {
            return;
        }
        super.customize(parameters, configuration);
        for (int i = 0; i < this.nodeUrls.size(); ++i) {
            this.isClientAlive.add(false);
            this.clients.add(null);
        }
    }

    @Override
    public void handshake() throws Exception {
        int i;
        if (!this.atLeastOneEnable) {
            return;
        }
        for (i = 0; i < this.clients.size(); ++i) {
            if (Boolean.TRUE.equals(this.isClientAlive.get(i))) continue;
            String ip = ((TEndPoint)this.nodeUrls.get(i)).getIp();
            int port = ((TEndPoint)this.nodeUrls.get(i)).getPort();
            if (this.clients.get(i) != null) {
                try {
                    ((IoTDBThriftSyncConnectorClient)this.clients.set(i, null)).close();
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to close client with target server ip: {}, port: {}, because: {}. Ignore it.", ip, port, e.getMessage());
                }
            }
            try {
                this.clients.set(i, new IoTDBThriftSyncConnectorClient(new ThriftClientProperty.Builder().setConnectionTimeoutMs((int)PIPE_CONFIG.getPipeConnectorHandshakeTimeoutMs()).setRpcThriftCompressionEnabled(PIPE_CONFIG.isPipeConnectorRPCThriftCompressionEnabled()).build(), ip, port, false, null, null));
            }
            catch (TTransportException e) {
                throw new PipeConnectionException(String.format("Error occurred while connecting to receiver %s:%s, please check network connectivity or SSL configurations when enable SSL transmission", ip, port), e);
            }
            this.isClientAlive.set(i, true);
            this.clients.get(i).setTimeout((int)PipeConfig.getInstance().getPipeConnectorTransferTimeoutMs());
            LOGGER.info("Handshake success. Target server ip: {}, port: {}", (Object)ip, (Object)port);
        }
        for (i = 0; i < this.clients.size(); ++i) {
            if (!Boolean.TRUE.equals(this.isClientAlive.get(i))) continue;
            return;
        }
        throw new PipeConnectionException(String.format("All target servers %s are not available.", this.nodeUrls));
    }

    @Override
    public void heartbeat() throws Exception {
        if (!this.atLeastOneEnable) {
            return;
        }
    }

    @Override
    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBSchemaConnector can't transfer TabletInsertionEvent.");
    }

    @Override
    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBSchemaConnector can't transfer TsFileInsertionEvent.");
    }

    @Override
    public void transfer(Event event) throws Exception {
        if (!this.atLeastOneEnable) {
            return;
        }
    }

    private int nextClientIndex() {
        int clientSize = this.clients.size();
        for (int tryCount = 0; tryCount < clientSize; ++tryCount) {
            int clientIndex;
            if (!Boolean.TRUE.equals(this.isClientAlive.get(clientIndex = (int)(this.currentClientIndex++ % (long)clientSize)))) continue;
            return clientIndex;
        }
        throw new PipeConnectionException("All clients are dead, please check the connection to the receiver.");
    }

    @Override
    public void close() {
        for (int i = 0; i < this.clients.size(); ++i) {
            try {
                if (this.clients.get(i) == null) continue;
                ((IoTDBThriftSyncConnectorClient)this.clients.set(i, null)).close();
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close client {}.", (Object)i, (Object)e);
                continue;
            }
            finally {
                this.isClientAlive.set(i, false);
            }
        }
    }
}

