/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.execution.executor;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.pipe.execution.scheduler.PipeSubtaskScheduler;
import org.apache.iotdb.commons.pipe.task.subtask.PipeSubtask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeSubtaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeSubtaskExecutor.class);
    private static final ExecutorService subtaskCallbackListeningExecutor = IoTDBThreadPoolFactory.newSingleThreadExecutor(ThreadName.PIPE_SUBTASK_CALLBACK_EXECUTOR_POOL.getName());
    private final ListeningExecutorService subtaskWorkerThreadPoolExecutor;
    private final Map<String, PipeSubtask> registeredIdSubtaskMapper;
    private final int corePoolSize;
    private int runningSubtaskNumber;

    protected PipeSubtaskExecutor(int corePoolSize, ThreadName threadName) {
        this.subtaskWorkerThreadPoolExecutor = MoreExecutors.listeningDecorator(IoTDBThreadPoolFactory.newFixedThreadPool(corePoolSize, threadName.getName()));
        this.registeredIdSubtaskMapper = new ConcurrentHashMap<String, PipeSubtask>();
        this.corePoolSize = corePoolSize;
        this.runningSubtaskNumber = 0;
    }

    public final synchronized void register(PipeSubtask subtask) {
        if (this.registeredIdSubtaskMapper.containsKey(subtask.getTaskID())) {
            LOGGER.warn("The subtask {} is already registered.", (Object)subtask.getTaskID());
            return;
        }
        this.registeredIdSubtaskMapper.put(subtask.getTaskID(), subtask);
        subtask.bindExecutors(this.subtaskWorkerThreadPoolExecutor, subtaskCallbackListeningExecutor, new PipeSubtaskScheduler(this));
    }

    public final synchronized void start(String subTaskID) {
        if (!this.registeredIdSubtaskMapper.containsKey(subTaskID)) {
            LOGGER.warn("The subtask {} is not registered.", (Object)subTaskID);
            return;
        }
        PipeSubtask subtask = this.registeredIdSubtaskMapper.get(subTaskID);
        if (subtask.isSubmittingSelf()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The subtask {} is already running.", (Object)subTaskID);
            }
        } else {
            subtask.allowSubmittingSelf();
            subtask.submitSelf();
            ++this.runningSubtaskNumber;
            LOGGER.info("The subtask {} is started to submit self.", (Object)subTaskID);
        }
    }

    public final synchronized void stop(String subTaskID) {
        if (!this.registeredIdSubtaskMapper.containsKey(subTaskID)) {
            LOGGER.warn("The subtask {} is not registered.", (Object)subTaskID);
            return;
        }
        if (this.registeredIdSubtaskMapper.get(subTaskID).disallowSubmittingSelf()) {
            --this.runningSubtaskNumber;
        }
    }

    public final synchronized void deregister(String subTaskID) {
        this.stop(subTaskID);
        PipeSubtask subtask = this.registeredIdSubtaskMapper.remove(subTaskID);
        if (subtask != null) {
            try {
                subtask.close();
                LOGGER.info("The subtask {} is closed successfully.", (Object)subTaskID);
            }
            catch (Exception e) {
                LOGGER.error("Failed to close the subtask {}.", (Object)subTaskID, (Object)e);
            }
        }
    }

    public final boolean isRegistered(String subTaskID) {
        return this.registeredIdSubtaskMapper.containsKey(subTaskID);
    }

    public final int getRegisteredSubtaskNumber() {
        return this.registeredIdSubtaskMapper.size();
    }

    public final synchronized void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        for (PipeSubtask subtask : this.registeredIdSubtaskMapper.values()) {
            subtask.disallowSubmittingSelf();
        }
        this.subtaskWorkerThreadPoolExecutor.shutdown();
    }

    public final boolean isShutdown() {
        return this.subtaskWorkerThreadPoolExecutor.isShutdown();
    }

    public final int getCorePoolSize() {
        return this.corePoolSize;
    }

    public final int getRunningSubtaskNumber() {
        return this.runningSubtaskNumber;
    }
}

