/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.payload.response;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferSnapshotPieceResp
extends TPipeTransferResp {
    public static final long ERROR_END_OFFSET = -1L;
    private long endWritingOffset;

    private PipeTransferSnapshotPieceResp() {
    }

    public long getEndWritingOffset() {
        return this.endWritingOffset;
    }

    public static PipeTransferSnapshotPieceResp toTPipeTransferResp(TSStatus status, long endWritingOffset) throws IOException {
        PipeTransferSnapshotPieceResp snapshotPieceResp = new PipeTransferSnapshotPieceResp();
        snapshotPieceResp.status = status;
        snapshotPieceResp.endWritingOffset = endWritingOffset;
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);){
            ReadWriteIOUtils.write(endWritingOffset, (OutputStream)outputStream);
            snapshotPieceResp.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return snapshotPieceResp;
    }

    public static PipeTransferSnapshotPieceResp toTPipeTransferResp(TSStatus status) {
        PipeTransferSnapshotPieceResp snapshotPieceResp = new PipeTransferSnapshotPieceResp();
        snapshotPieceResp.status = status;
        return snapshotPieceResp;
    }

    public static PipeTransferSnapshotPieceResp fromTPipeTransferResp(TPipeTransferResp transferResp) {
        PipeTransferSnapshotPieceResp snapshotPieceResp = new PipeTransferSnapshotPieceResp();
        snapshotPieceResp.status = transferResp.status;
        if (transferResp.isSetBody()) {
            snapshotPieceResp.endWritingOffset = ReadWriteIOUtils.readLong(transferResp.body);
            snapshotPieceResp.body = transferResp.body;
        }
        return snapshotPieceResp;
    }
}

