/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.pipe.task.PipeTask;
import org.apache.iotdb.commons.pipe.task.PipeTaskManager;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeMetaKeeper;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaRespExceptionMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeTaskAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTaskAgent.class);
    protected static final String MESSAGE_UNKNOWN_PIPE_STATUS = "Unknown pipe status %s for pipe %s";
    protected static final String MESSAGE_UNEXPECTED_PIPE_STATUS = "Unexpected pipe status %s: ";
    protected final PipeMetaKeeper pipeMetaKeeper = new PipeMetaKeeper();
    protected final PipeTaskManager pipeTaskManager = new PipeTaskManager();

    protected void acquireReadLock() {
        this.pipeMetaKeeper.acquireReadLock();
    }

    protected boolean tryReadLockWithTimeOut(long timeOutInSeconds) {
        try {
            return this.pipeMetaKeeper.tryReadLock(timeOutInSeconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Interruption during requiring pipeMetaKeeper read lock.", e);
            return false;
        }
    }

    protected void releaseReadLock() {
        this.pipeMetaKeeper.releaseReadLock();
    }

    protected void acquireWriteLock() {
        this.pipeMetaKeeper.acquireWriteLock();
    }

    protected boolean tryWriteLockWithTimeOut(long timeOutInSeconds) {
        try {
            return this.pipeMetaKeeper.tryWriteLock(timeOutInSeconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Interruption during requiring pipeMetaKeeper write lock.", e);
            return false;
        }
    }

    protected void releaseWriteLock() {
        this.pipeMetaKeeper.releaseWriteLock();
    }

    public TPushPipeMetaRespExceptionMessage handleSinglePipeMetaChanges(PipeMeta pipeMetaFromCoordinator) {
        this.acquireWriteLock();
        try {
            TPushPipeMetaRespExceptionMessage tPushPipeMetaRespExceptionMessage = this.handleSinglePipeMetaChangesInternal(pipeMetaFromCoordinator);
            return tPushPipeMetaRespExceptionMessage;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected TPushPipeMetaRespExceptionMessage handleSinglePipeMetaChangesInternal(PipeMeta pipeMetaFromCoordinator) {
        if (this.isShutdown()) {
            return null;
        }
        try {
            this.executeSinglePipeMetaChanges(pipeMetaFromCoordinator);
            return null;
        }
        catch (Exception e) {
            String pipeName = pipeMetaFromCoordinator.getStaticMeta().getPipeName();
            String errorMessage = String.format("Failed to handle single pipe meta changes for %s, because %s", pipeName, e.getMessage());
            LOGGER.warn("Failed to handle single pipe meta changes for {}", (Object)pipeName, (Object)e);
            return new TPushPipeMetaRespExceptionMessage(pipeName, errorMessage, System.currentTimeMillis());
        }
    }

    protected abstract boolean isShutdown();

    private void executeSinglePipeMetaChanges(PipeMeta metaFromCoordinator) {
        PipeStaticMeta staticMetaFromCoordinator;
        String pipeName = metaFromCoordinator.getStaticMeta().getPipeName();
        PipeMeta metaInAgent = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (metaInAgent == null) {
            if (this.createPipe(metaFromCoordinator)) {
                this.startPipe(pipeName, metaFromCoordinator.getStaticMeta().getCreationTime());
            }
            return;
        }
        PipeStaticMeta staticMetaInAgent = metaInAgent.getStaticMeta();
        if (!staticMetaInAgent.equals(staticMetaFromCoordinator = metaFromCoordinator.getStaticMeta())) {
            this.dropPipe(pipeName);
            if (this.createPipe(metaFromCoordinator)) {
                this.startPipe(pipeName, metaFromCoordinator.getStaticMeta().getCreationTime());
            }
            return;
        }
        PipeRuntimeMeta runtimeMetaInAgent = metaInAgent.getRuntimeMeta();
        PipeRuntimeMeta runtimeMetaFromCoordinator = metaFromCoordinator.getRuntimeMeta();
        this.executeSinglePipeRuntimeMetaChanges(staticMetaFromCoordinator, runtimeMetaFromCoordinator, runtimeMetaInAgent);
    }

    private void executeSinglePipeRuntimeMetaChanges(PipeStaticMeta pipeStaticMeta, PipeRuntimeMeta runtimeMetaFromCoordinator, PipeRuntimeMeta runtimeMetaInAgent) {
        PipeStatus statusInAgent;
        PipeTaskMeta taskMetaFromCoordinator;
        Map<TConsensusGroupId, PipeTaskMeta> consensusGroupIdToTaskMetaMapFromCoordinator = runtimeMetaFromCoordinator.getConsensusGroupId2TaskMetaMap();
        Map<TConsensusGroupId, PipeTaskMeta> consensusGroupIdToTaskMetaMapInAgent = runtimeMetaInAgent.getConsensusGroupId2TaskMetaMap();
        for (Map.Entry<TConsensusGroupId, PipeTaskMeta> entryFromCoordinator : consensusGroupIdToTaskMetaMapFromCoordinator.entrySet()) {
            int nodeIdInAgent;
            TConsensusGroupId consensusGroupIdFromCoordinator = entryFromCoordinator.getKey();
            taskMetaFromCoordinator = entryFromCoordinator.getValue();
            PipeTaskMeta taskMetaInAgent = consensusGroupIdToTaskMetaMapInAgent.get(consensusGroupIdFromCoordinator);
            if (taskMetaInAgent == null) {
                this.createPipeTask(consensusGroupIdFromCoordinator, pipeStaticMeta, taskMetaFromCoordinator);
                if (runtimeMetaInAgent.getStatus().get() != PipeStatus.RUNNING) continue;
                this.startPipeTask(consensusGroupIdFromCoordinator, pipeStaticMeta);
                continue;
            }
            int nodeIdFromCoordinator = taskMetaFromCoordinator.getLeaderDataNodeId();
            if (nodeIdFromCoordinator == (nodeIdInAgent = taskMetaInAgent.getLeaderDataNodeId())) continue;
            this.dropPipeTask(consensusGroupIdFromCoordinator, pipeStaticMeta);
            this.createPipeTask(consensusGroupIdFromCoordinator, pipeStaticMeta, taskMetaFromCoordinator);
            if (runtimeMetaInAgent.getStatus().get() != PipeStatus.RUNNING) continue;
            this.startPipeTask(consensusGroupIdFromCoordinator, pipeStaticMeta);
        }
        for (Map.Entry<TConsensusGroupId, PipeTaskMeta> entryInAgent : consensusGroupIdToTaskMetaMapInAgent.entrySet()) {
            TConsensusGroupId consensusGroupIdInAgent = entryInAgent.getKey();
            taskMetaFromCoordinator = consensusGroupIdToTaskMetaMapFromCoordinator.get(consensusGroupIdInAgent);
            if (taskMetaFromCoordinator != null) continue;
            this.dropPipeTask(consensusGroupIdInAgent, pipeStaticMeta);
        }
        PipeStatus statusFromCoordinator = runtimeMetaFromCoordinator.getStatus().get();
        if (statusFromCoordinator == (statusInAgent = runtimeMetaInAgent.getStatus().get())) {
            return;
        }
        switch (statusFromCoordinator) {
            case RUNNING: {
                if (Objects.requireNonNull(statusInAgent) == PipeStatus.STOPPED) {
                    this.startPipe(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime());
                    break;
                }
                throw new IllegalStateException(String.format(MESSAGE_UNKNOWN_PIPE_STATUS, new Object[]{statusInAgent, pipeStaticMeta.getPipeName()}));
            }
            case STOPPED: {
                if (Objects.requireNonNull(statusInAgent) == PipeStatus.RUNNING) {
                    this.stopPipe(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime());
                    break;
                }
                throw new IllegalStateException(String.format(MESSAGE_UNKNOWN_PIPE_STATUS, new Object[]{statusInAgent, pipeStaticMeta.getPipeName()}));
            }
            case DROPPED: {
                this.dropPipe(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime());
                break;
            }
            default: {
                throw new IllegalStateException(String.format(MESSAGE_UNKNOWN_PIPE_STATUS, new Object[]{statusFromCoordinator, pipeStaticMeta.getPipeName()}));
            }
        }
    }

    public TPushPipeMetaRespExceptionMessage handleDropPipe(String pipeName) {
        this.acquireWriteLock();
        try {
            TPushPipeMetaRespExceptionMessage tPushPipeMetaRespExceptionMessage = this.handleDropPipeInternal(pipeName);
            return tPushPipeMetaRespExceptionMessage;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected TPushPipeMetaRespExceptionMessage handleDropPipeInternal(String pipeName) {
        if (this.isShutdown()) {
            return null;
        }
        try {
            this.dropPipe(pipeName);
            return null;
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to drop pipe %s, because %s", pipeName, e.getMessage());
            LOGGER.warn("Failed to drop pipe {}", (Object)pipeName, (Object)e);
            return new TPushPipeMetaRespExceptionMessage(pipeName, errorMessage, System.currentTimeMillis());
        }
    }

    public List<TPushPipeMetaRespExceptionMessage> handlePipeMetaChanges(List<PipeMeta> pipeMetaListFromCoordinator) {
        this.acquireWriteLock();
        try {
            List<TPushPipeMetaRespExceptionMessage> list = this.handlePipeMetaChangesInternal(pipeMetaListFromCoordinator);
            return list;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private List<TPushPipeMetaRespExceptionMessage> handlePipeMetaChangesInternal(List<PipeMeta> pipeMetaListFromCoordinator) {
        String pipeName;
        if (this.isShutdown()) {
            return Collections.emptyList();
        }
        ArrayList<TPushPipeMetaRespExceptionMessage> exceptionMessages = new ArrayList<TPushPipeMetaRespExceptionMessage>();
        for (PipeMeta metaFromCoordinator : pipeMetaListFromCoordinator) {
            try {
                this.executeSinglePipeMetaChanges(metaFromCoordinator);
            }
            catch (Exception e) {
                pipeName = metaFromCoordinator.getStaticMeta().getPipeName();
                String errorMessage = String.format("Failed to handle pipe meta changes for %s, because %s", pipeName, e.getMessage());
                LOGGER.warn("Failed to handle pipe meta changes for {}", (Object)pipeName, (Object)e);
                exceptionMessages.add(new TPushPipeMetaRespExceptionMessage(pipeName, errorMessage, System.currentTimeMillis()));
            }
        }
        Set pipeNamesFromCoordinator = pipeMetaListFromCoordinator.stream().map(meta -> meta.getStaticMeta().getPipeName()).collect(Collectors.toSet());
        for (PipeMeta metaInAgent : this.pipeMetaKeeper.getPipeMetaList()) {
            pipeName = metaInAgent.getStaticMeta().getPipeName();
            try {
                if (pipeNamesFromCoordinator.contains(pipeName)) continue;
                this.dropPipe(metaInAgent.getStaticMeta().getPipeName());
            }
            catch (Exception e) {
                String errorMessage = String.format("Failed to handle pipe meta changes for %s, because %s", pipeName, e.getMessage());
                LOGGER.warn("Failed to handle pipe meta changes for {}", (Object)pipeName, (Object)e);
                exceptionMessages.add(new TPushPipeMetaRespExceptionMessage(pipeName, errorMessage, System.currentTimeMillis()));
            }
        }
        return exceptionMessages;
    }

    public void dropAllPipeTasks() {
        this.acquireWriteLock();
        try {
            this.dropAllPipeTasksInternal();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void dropAllPipeTasksInternal() {
        for (PipeMeta pipeMeta : this.pipeMetaKeeper.getPipeMetaList()) {
            try {
                this.dropPipe(pipeMeta.getStaticMeta().getPipeName(), pipeMeta.getStaticMeta().getCreationTime());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to drop pipe {} with creation time {}", pipeMeta.getStaticMeta().getPipeName(), pipeMeta.getStaticMeta().getCreationTime(), e);
            }
        }
    }

    private boolean createPipe(PipeMeta pipeMetaFromCoordinator) {
        String pipeName = pipeMetaFromCoordinator.getStaticMeta().getPipeName();
        long creationTime = pipeMetaFromCoordinator.getStaticMeta().getCreationTime();
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (existedPipeMeta != null) {
            if (!this.checkBeforeCreatePipe(existedPipeMeta, pipeName, creationTime)) {
                return false;
            }
            this.dropPipe(pipeName, existedPipeMeta.getStaticMeta().getCreationTime());
        }
        Map<TConsensusGroupId, PipeTask> pipeTasks = this.buildPipeTasks(pipeMetaFromCoordinator);
        long startTime = System.currentTimeMillis();
        pipeTasks.values().parallelStream().forEach(PipeTask::create);
        LOGGER.info("Create all pipe tasks on Pipe {} successfully within {} ms", (Object)pipeName, (Object)(System.currentTimeMillis() - startTime));
        this.pipeTaskManager.addPipeTasks(pipeMetaFromCoordinator.getStaticMeta(), pipeTasks);
        AtomicReference<PipeStatus> pipeStatusFromCoordinator = pipeMetaFromCoordinator.getRuntimeMeta().getStatus();
        boolean needToStartPipe = pipeStatusFromCoordinator.get() == PipeStatus.RUNNING;
        pipeStatusFromCoordinator.set(PipeStatus.STOPPED);
        this.pipeMetaKeeper.addPipeMeta(pipeName, pipeMetaFromCoordinator);
        return needToStartPipe;
    }

    protected abstract Map<TConsensusGroupId, PipeTask> buildPipeTasks(PipeMeta var1);

    private void dropPipe(String pipeName, long creationTime) {
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (!this.checkBeforeDropPipe(existedPipeMeta, pipeName, creationTime)) {
            return;
        }
        existedPipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.DROPPED);
        Map<TConsensusGroupId, PipeTask> pipeTasks = this.pipeTaskManager.removePipeTasks(existedPipeMeta.getStaticMeta());
        if (pipeTasks == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip dropping.", (Object)pipeName, (Object)creationTime);
            return;
        }
        long startTime = System.currentTimeMillis();
        pipeTasks.values().parallelStream().forEach(PipeTask::drop);
        LOGGER.info("Drop all pipe tasks on Pipe {} successfully within {} ms", (Object)pipeName, (Object)(System.currentTimeMillis() - startTime));
        this.pipeMetaKeeper.removePipeMeta(pipeName);
    }

    private void dropPipe(String pipeName) {
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (!this.checkBeforeDropPipe(existedPipeMeta, pipeName)) {
            return;
        }
        existedPipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.DROPPED);
        Map<TConsensusGroupId, PipeTask> pipeTasks = this.pipeTaskManager.removePipeTasks(existedPipeMeta.getStaticMeta());
        if (pipeTasks == null) {
            LOGGER.info("Pipe {} has already been dropped or has not been created. Skip dropping.", (Object)pipeName);
            return;
        }
        long startTime = System.currentTimeMillis();
        pipeTasks.values().parallelStream().forEach(PipeTask::drop);
        LOGGER.info("Drop all pipe tasks on Pipe {} successfully within {} ms", (Object)pipeName, (Object)(System.currentTimeMillis() - startTime));
        this.pipeMetaKeeper.removePipeMeta(pipeName);
    }

    private void startPipe(String pipeName, long creationTime) {
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (!this.checkBeforeStartPipe(existedPipeMeta, pipeName, creationTime)) {
            return;
        }
        Map<TConsensusGroupId, PipeTask> pipeTasks = this.pipeTaskManager.getPipeTasks(existedPipeMeta.getStaticMeta());
        if (pipeTasks == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip starting.", (Object)pipeName, (Object)creationTime);
            return;
        }
        long startTime = System.currentTimeMillis();
        pipeTasks.values().parallelStream().forEach(PipeTask::start);
        LOGGER.info("Start all pipe tasks on Pipe {} successfully within {} ms", (Object)pipeName, (Object)(System.currentTimeMillis() - startTime));
        existedPipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.RUNNING);
        existedPipeMeta.getRuntimeMeta().getConsensusGroupId2TaskMetaMap().values().forEach(PipeTaskMeta::clearExceptionMessages);
    }

    protected void stopPipe(String pipeName, long creationTime) {
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (!this.checkBeforeStopPipe(existedPipeMeta, pipeName, creationTime)) {
            return;
        }
        Map<TConsensusGroupId, PipeTask> pipeTasks = this.pipeTaskManager.getPipeTasks(existedPipeMeta.getStaticMeta());
        if (pipeTasks == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip stopping.", (Object)pipeName, (Object)creationTime);
            return;
        }
        long startTime = System.currentTimeMillis();
        pipeTasks.values().parallelStream().forEach(PipeTask::stop);
        LOGGER.info("Stop all pipe tasks on Pipe {} successfully within {} ms", (Object)pipeName, (Object)(System.currentTimeMillis() - startTime));
        existedPipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.STOPPED);
    }

    protected boolean checkBeforeCreatePipe(PipeMeta existedPipeMeta, String pipeName, long creationTime) throws IllegalStateException {
        if (existedPipeMeta.getStaticMeta().getCreationTime() == creationTime) {
            PipeStatus status = existedPipeMeta.getRuntimeMeta().getStatus().get();
            switch (status) {
                case RUNNING: 
                case STOPPED: {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Pipe {} (creation time = {}) has already been created. Current status = {}. Skip creating.", pipeName, creationTime, status.name());
                    }
                    return false;
                }
                case DROPPED: {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Pipe {} (creation time = {}) has already been dropped, but the pipe task meta has not been cleaned up. Current status = {}. Try dropping the pipe and recreating it.", pipeName, creationTime, status.name());
                    }
                    return true;
                }
            }
            throw new IllegalStateException(MESSAGE_UNEXPECTED_PIPE_STATUS + existedPipeMeta.getRuntimeMeta().getStatus().get().name());
        }
        return true;
    }

    protected boolean checkBeforeStartPipe(PipeMeta existedPipeMeta, String pipeName, long creationTime) throws IllegalStateException {
        if (existedPipeMeta == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip starting.", (Object)pipeName, (Object)creationTime);
            return false;
        }
        if (existedPipeMeta.getStaticMeta().getCreationTime() != creationTime) {
            LOGGER.info("Pipe {} (creation time = {}) has been created but does not match the creation time ({}) in startPipe request. Skip starting.", pipeName, existedPipeMeta.getStaticMeta().getCreationTime(), creationTime);
            return false;
        }
        PipeStatus status = existedPipeMeta.getRuntimeMeta().getStatus().get();
        switch (status) {
            case STOPPED: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has been created. Current status = {}. Starting.", pipeName, creationTime, status.name());
                }
                return true;
            }
            case RUNNING: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has already been started. Current status = {}. Skip starting.", pipeName, creationTime, status.name());
                }
                return false;
            }
            case DROPPED: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has already been dropped. Current status = {}. Skip starting.", pipeName, creationTime, status.name());
                }
                return false;
            }
        }
        throw new IllegalStateException(MESSAGE_UNEXPECTED_PIPE_STATUS + existedPipeMeta.getRuntimeMeta().getStatus().get().name());
    }

    protected boolean checkBeforeStopPipe(PipeMeta existedPipeMeta, String pipeName, long creationTime) throws IllegalStateException {
        if (existedPipeMeta == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip stopping.", (Object)pipeName, (Object)creationTime);
            return false;
        }
        if (existedPipeMeta.getStaticMeta().getCreationTime() != creationTime) {
            LOGGER.info("Pipe {} (creation time = {}) has been created but does not match the creation time ({}) in stopPipe request. Skip stopping.", pipeName, existedPipeMeta.getStaticMeta().getCreationTime(), creationTime);
            return false;
        }
        PipeStatus status = existedPipeMeta.getRuntimeMeta().getStatus().get();
        switch (status) {
            case STOPPED: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has already been stopped. Current status = {}. Skip stopping.", pipeName, creationTime, status.name());
                }
                return false;
            }
            case RUNNING: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has been started. Current status = {}. Stopping.", pipeName, creationTime, status.name());
                }
                return true;
            }
            case DROPPED: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has already been dropped. Current status = {}. Skip stopping.", pipeName, creationTime, status.name());
                }
                return false;
            }
        }
        throw new IllegalStateException(MESSAGE_UNEXPECTED_PIPE_STATUS + status.name());
    }

    protected boolean checkBeforeDropPipe(PipeMeta existedPipeMeta, String pipeName, long creationTime) throws IllegalStateException {
        if (existedPipeMeta == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip dropping.", (Object)pipeName, (Object)creationTime);
            return false;
        }
        if (existedPipeMeta.getStaticMeta().getCreationTime() != creationTime) {
            LOGGER.info("Pipe {} (creation time = {}) has been created but does not match the creation time ({}) in dropPipe request. Skip dropping.", pipeName, existedPipeMeta.getStaticMeta().getCreationTime(), creationTime);
            return false;
        }
        return true;
    }

    protected boolean checkBeforeDropPipe(PipeMeta existedPipeMeta, String pipeName) throws IllegalStateException {
        if (existedPipeMeta == null) {
            LOGGER.info("Pipe {} has already been dropped or has not been created. Skip dropping.", (Object)pipeName);
            return false;
        }
        return true;
    }

    protected abstract void createPipeTask(TConsensusGroupId var1, PipeStaticMeta var2, PipeTaskMeta var3);

    private void dropPipeTask(TConsensusGroupId consensusGroupId, PipeStaticMeta pipeStaticMeta) {
        this.pipeMetaKeeper.getPipeMeta(pipeStaticMeta.getPipeName()).getRuntimeMeta().getConsensusGroupId2TaskMetaMap().remove(consensusGroupId);
        PipeTask pipeTask = this.pipeTaskManager.removePipeTask(pipeStaticMeta, consensusGroupId);
        if (pipeTask != null) {
            pipeTask.drop();
        }
    }

    private void startPipeTask(TConsensusGroupId consensusGroupId, PipeStaticMeta pipeStaticMeta) {
        PipeTask pipeTask = this.pipeTaskManager.getPipeTask(pipeStaticMeta, consensusGroupId);
        if (pipeTask != null) {
            pipeTask.start();
        }
    }
}

