/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.plugin;

import java.util.Map;
import org.apache.iotdb.commons.pipe.agent.plugin.PipePluginConstructor;
import org.apache.iotdb.commons.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskTemporaryRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMetaKeeper;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipePluginAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePluginAgent.class);
    private final PipePluginConstructor pipeExtractorConstructor;
    private final PipePluginConstructor pipeProcessorConstructor;
    private final PipePluginConstructor pipeConnectorConstructor;

    protected PipePluginAgent(PipePluginMetaKeeper pipePluginMetaKeeper) {
        this.pipeExtractorConstructor = this.createPipeExtractorConstructor(pipePluginMetaKeeper);
        this.pipeProcessorConstructor = this.createPipeProcessorConstructor(pipePluginMetaKeeper);
        this.pipeConnectorConstructor = this.createPipeConnectorConstructor(pipePluginMetaKeeper);
    }

    protected abstract PipePluginConstructor createPipeExtractorConstructor(PipePluginMetaKeeper var1);

    protected abstract PipePluginConstructor createPipeProcessorConstructor(PipePluginMetaKeeper var1);

    protected abstract PipePluginConstructor createPipeConnectorConstructor(PipePluginMetaKeeper var1);

    public final PipeExtractor reflectExtractor(PipeParameters extractorParameters) {
        return (PipeExtractor)this.pipeExtractorConstructor.reflectPlugin(extractorParameters);
    }

    public final PipeProcessor reflectProcessor(PipeParameters processorParameters) {
        return (PipeProcessor)this.pipeProcessorConstructor.reflectPlugin(processorParameters);
    }

    public final PipeConnector reflectConnector(PipeParameters connectorParameters) {
        return (PipeConnector)this.pipeConnectorConstructor.reflectPlugin(connectorParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(String pipeName, Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes) throws Exception {
        PipeParameters extractorParameters = new PipeParameters(extractorAttributes);
        PipeExtractor temporaryExtractor = this.reflectExtractor(extractorParameters);
        try {
            temporaryExtractor.validate(new PipeParameterValidator(extractorParameters));
        }
        finally {
            try {
                temporaryExtractor.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close temporary extractor: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        PipeParameters processorParameters = new PipeParameters(processorAttributes);
        PipeProcessor temporaryProcessor = this.reflectProcessor(processorParameters);
        try {
            temporaryProcessor.validate(new PipeParameterValidator(processorParameters));
        }
        finally {
            try {
                temporaryProcessor.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close temporary processor: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        PipeParameters connectorParameters = new PipeParameters(connectorAttributes);
        PipeConnector temporaryConnector = this.reflectConnector(connectorParameters);
        try {
            temporaryConnector.validate(new PipeParameterValidator(connectorParameters));
            temporaryConnector.customize(connectorParameters, new PipeTaskRuntimeConfiguration(new PipeTaskTemporaryRuntimeEnvironment(pipeName)));
            temporaryConnector.handshake();
        }
        finally {
            try {
                temporaryConnector.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close temporary connector: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

