/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternNode;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.tsfile.utils.PublicBAOS;

public class PathPatternTree {
    private PathPatternNode<Void, PathPatternNode.VoidSerializer> root = new PathPatternNode("root", PathPatternNode.VoidSerializer.getInstance());
    private List<PartialPath> pathPatternList = new LinkedList<PartialPath>();
    private boolean useWildcard = true;
    private boolean containWildcard = false;
    private boolean containFullPath = false;

    public PathPatternTree(boolean useWildcard) {
        this();
        this.useWildcard = useWildcard;
    }

    public PathPatternTree() {
    }

    public boolean isContainWildcard() {
        return this.containWildcard;
    }

    public boolean isContainFullPath() {
        return this.containFullPath;
    }

    public PathPatternNode<Void, PathPatternNode.VoidSerializer> getRoot() {
        return this.root;
    }

    public void setRoot(PathPatternNode<Void, PathPatternNode.VoidSerializer> root) {
        this.root = root;
    }

    public void appendFullPath(PartialPath fullPath) {
        this.appendBranchWithoutPrune(this.root, fullPath.getNodes(), 0);
    }

    public void appendFullPath(PartialPath devicePath, String measurement) {
        int deviceNodeLength = devicePath.getNodeLength();
        String[] pathNodes = new String[deviceNodeLength + 1];
        System.arraycopy(devicePath.getNodes(), 0, pathNodes, 0, deviceNodeLength);
        pathNodes[deviceNodeLength] = measurement;
        this.appendBranchWithoutPrune(this.root, pathNodes, 0);
    }

    public void appendPathPattern(PartialPath pathPattern) {
        if (this.useWildcard) {
            boolean isExist = false;
            for (PartialPath path : this.pathPatternList) {
                if (!path.include(pathPattern)) continue;
                isExist = true;
                break;
            }
            if (!isExist) {
                this.pathPatternList.removeIf(pathPattern::include);
                this.pathPatternList.add(pathPattern);
            }
        } else {
            this.appendBranchWithoutPrune(this.root, pathPattern.getNodes(), 0);
        }
    }

    public void constructTree() {
        for (PartialPath path : this.pathPatternList) {
            this.appendBranchWithoutPrune(this.root, path.getNodes(), 0);
        }
        this.pathPatternList.clear();
    }

    private void appendBranchWithoutPrune(PathPatternNode<Void, PathPatternNode.VoidSerializer> curNode, String[] pathNodes, int pos) {
        if (pos == pathNodes.length - 1) {
            curNode.markPathPattern(true);
            return;
        }
        PathPatternNode<Void, PathPatternNode.VoidSerializer> nextNode = curNode.getChildren(pathNodes[pos + 1]);
        if (nextNode != null) {
            this.appendBranchWithoutPrune(nextNode, pathNodes, pos + 1);
        } else {
            this.constructBranch(curNode, pathNodes, pos + 1);
        }
    }

    private void constructBranch(PathPatternNode<Void, PathPatternNode.VoidSerializer> curNode, String[] pathNodes, int pos) {
        for (int i = pos; i < pathNodes.length; ++i) {
            PathPatternNode newNode = new PathPatternNode(pathNodes[i], PathPatternNode.VoidSerializer.getInstance());
            curNode.addChild(newNode);
            this.processNodeName(pathNodes[i]);
            curNode = newNode;
        }
        curNode.markPathPattern(true);
    }

    private void processNodeName(String nodeName) {
        if (!this.containWildcard) {
            this.containWildcard = PathPatternUtil.hasWildcard(nodeName);
        }
        if (!this.containFullPath) {
            this.containFullPath = !PathPatternUtil.hasWildcard(nodeName);
        }
    }

    public boolean isEmpty() {
        return !(this.root.getChildren() != null && !this.root.getChildren().isEmpty() || this.pathPatternList != null && !this.pathPatternList.isEmpty());
    }

    public List<String> getAllDevicePatterns() {
        ArrayList<String> nodes = new ArrayList<String>();
        HashSet<String> results = new HashSet<String>();
        this.searchDevicePattern(this.root, nodes, results);
        return new ArrayList<String>(results);
    }

    public List<PartialPath> getAllDevicePaths() {
        ArrayList<String> nodes = new ArrayList<String>();
        HashSet<List<String>> resultNodesSet = new HashSet<List<String>>();
        this.searchDevicePath(this.root, nodes, resultNodesSet);
        HashSet<PartialPath> resultPaths = new HashSet<PartialPath>();
        for (List list : resultNodesSet) {
            resultPaths.add(new PartialPath(list.toArray(new String[0])));
        }
        return new ArrayList<PartialPath>(resultPaths);
    }

    private void searchDevicePattern(PathPatternNode<Void, PathPatternNode.VoidSerializer> curNode, List<String> nodes, Set<String> results) {
        nodes.add(curNode.getName());
        if (curNode.isPathPattern()) {
            if (!curNode.getName().equals("**")) {
                results.add(nodes.size() == 1 ? "" : this.convertNodesToString(nodes.subList(0, nodes.size() - 1)));
            } else {
                if (nodes.size() > 2) {
                    results.add(this.convertNodesToString(nodes.subList(0, nodes.size() - 1)));
                }
                results.add(this.convertNodesToString(nodes));
            }
            if (curNode.isLeaf()) {
                nodes.remove(nodes.size() - 1);
                return;
            }
        }
        for (PathPatternNode<Void, PathPatternNode.VoidSerializer> childNode : curNode.getChildren().values()) {
            this.searchDevicePattern(childNode, nodes, results);
        }
        nodes.remove(nodes.size() - 1);
    }

    private void searchDevicePath(PathPatternNode<Void, PathPatternNode.VoidSerializer> curNode, List<String> nodes, Set<List<String>> resultNodesSet) {
        nodes.add(curNode.getName());
        if (curNode.isPathPattern()) {
            if (!curNode.getName().equals("**")) {
                resultNodesSet.add(nodes.size() == 1 ? new ArrayList() : new ArrayList<String>(nodes.subList(0, nodes.size() - 1)));
            } else {
                if (nodes.size() > 2) {
                    resultNodesSet.add(new ArrayList<String>(nodes.subList(0, nodes.size() - 1)));
                }
                resultNodesSet.add(new ArrayList<String>(nodes));
            }
            if (curNode.isLeaf()) {
                nodes.remove(nodes.size() - 1);
                return;
            }
        }
        for (PathPatternNode<Void, PathPatternNode.VoidSerializer> childNode : curNode.getChildren().values()) {
            this.searchDevicePath(childNode, nodes, resultNodesSet);
        }
        nodes.remove(nodes.size() - 1);
    }

    public List<PartialPath> getAllPathPatterns() {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        ArrayDeque<String> ancestors = new ArrayDeque<String>();
        this.searchPathPattern(this.root, ancestors, result);
        return result;
    }

    private void searchPathPattern(PathPatternNode<Void, PathPatternNode.VoidSerializer> node, Deque<String> ancestors, List<PartialPath> fullPaths) {
        if (node.isPathPattern()) {
            fullPaths.add(this.convertNodesToPartialPath(node, ancestors));
            if (node.isLeaf()) {
                return;
            }
        }
        ancestors.push(node.getName());
        for (PathPatternNode<Void, PathPatternNode.VoidSerializer> child : node.getChildren().values()) {
            this.searchPathPattern(child, ancestors, fullPaths);
        }
        ancestors.pop();
    }

    public List<PartialPath> getOverlappedPathPatterns(PartialPath pattern) {
        if (this.pathPatternList.isEmpty()) {
            this.pathPatternList = this.getAllPathPatterns();
        }
        ArrayList<PartialPath> results = new ArrayList<PartialPath>();
        for (PartialPath path : this.pathPatternList) {
            if (!pattern.overlapWith(path)) continue;
            results.add(path);
        }
        return results;
    }

    private String convertNodesToString(List<String> nodes) {
        StringBuilder fullPathBuilder = new StringBuilder(nodes.get(0));
        for (int i = 1; i < nodes.size(); ++i) {
            fullPathBuilder.append(".").append(nodes.get(i));
        }
        return fullPathBuilder.toString();
    }

    private PartialPath convertNodesToPartialPath(PathPatternNode<Void, PathPatternNode.VoidSerializer> node, Deque<String> ancestors) {
        Iterator<String> iterator = ancestors.descendingIterator();
        ArrayList<String> nodeList = new ArrayList<String>(ancestors.size() + 1);
        while (iterator.hasNext()) {
            nodeList.add(iterator.next());
        }
        nodeList.add(node.getName());
        return new PartialPath(nodeList.toArray(new String[0]));
    }

    public boolean isOverlapWith(PathPatternTree patternTree) {
        for (PartialPath pathPattern : this.getAllPathPatterns()) {
            if (patternTree.getOverlappedPathPatterns(pathPattern).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void serialize(PublicBAOS outputStream) throws IOException {
        this.constructTree();
        this.root.serialize(outputStream);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        this.constructTree();
        this.root.serialize(stream);
    }

    public void serialize(ByteBuffer buffer) {
        this.constructTree();
        this.root.serialize(buffer);
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS baos = new PublicBAOS();
        this.serialize(baos);
        ByteBuffer serializedPatternTree = ByteBuffer.allocate(baos.size());
        serializedPatternTree.put(baos.getBuf(), 0, baos.size());
        serializedPatternTree.flip();
        return serializedPatternTree;
    }

    public static PathPatternTree deserialize(ByteBuffer buffer) {
        PathPatternTree deserializedPatternTree = new PathPatternTree();
        PathPatternNode<Void, PathPatternNode.VoidSerializer> root = PathPatternNode.deserializeNode(buffer, PathPatternNode.VoidSerializer.getInstance(), deserializedPatternTree::processNodeName);
        deserializedPatternTree.setRoot(root);
        return deserializedPatternTree;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathPatternTree that = (PathPatternTree)o;
        return Objects.equals(this.root, that.root);
    }

    public int hashCode() {
        return Objects.hash(this.root);
    }
}

