/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.exception.pipe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeConnectorCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeOutOfMemoryCriticalException;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMetaVersion;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public enum PipeRuntimeExceptionType {
    NON_CRITICAL_EXCEPTION(1),
    CRITICAL_EXCEPTION(2),
    CONNECTOR_CRITICAL_EXCEPTION(3),
    OUT_OF_MEMORY_CRITICAL_EXCEPTION(4);

    private final short type;

    private PipeRuntimeExceptionType(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write(this.type, byteBuffer);
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write(this.type, stream);
    }

    public static PipeRuntimeException deserializeFrom(PipeRuntimeMetaVersion version, ByteBuffer byteBuffer) {
        short type = ReadWriteIOUtils.readShort(byteBuffer);
        switch (type) {
            case 1: {
                return PipeRuntimeNonCriticalException.deserializeFrom(version, byteBuffer);
            }
            case 2: {
                return PipeRuntimeCriticalException.deserializeFrom(version, byteBuffer);
            }
            case 3: {
                return PipeRuntimeConnectorCriticalException.deserializeFrom(version, byteBuffer);
            }
            case 4: {
                return PipeRuntimeOutOfMemoryCriticalException.deserializeFrom(version, byteBuffer);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported PipeRuntimeException type %s.", type));
    }

    public static PipeRuntimeException deserializeFrom(PipeRuntimeMetaVersion version, InputStream stream) throws IOException {
        short type = ReadWriteIOUtils.readShort(stream);
        switch (type) {
            case 1: {
                return PipeRuntimeNonCriticalException.deserializeFrom(version, stream);
            }
            case 2: {
                return PipeRuntimeCriticalException.deserializeFrom(version, stream);
            }
            case 3: {
                return PipeRuntimeConnectorCriticalException.deserializeFrom(version, stream);
            }
            case 4: {
                return PipeRuntimeOutOfMemoryCriticalException.deserializeFrom(version, stream);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported PipeRuntimeException type %s.", type));
    }
}

