/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.authorizer;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.authorizer.IAuthorizer;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.auth.role.IRoleManager;
import org.apache.iotdb.commons.auth.user.IUserManager;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicAuthorizer
implements IAuthorizer,
IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicAuthorizer.class);
    private static final String NO_SUCH_ROLE_EXCEPTION = "No such role : %s";
    private static final String NO_SUCH_USER_EXCEPTION = "No such user : %s";
    IUserManager userManager;
    IRoleManager roleManager;

    @Override
    public void checkUserPathPrivilege() {
        this.userManager.checkAndRefreshPathPri();
        this.roleManager.checkAndRefreshPathPri();
        this.userManager.setPreVersion(false);
        this.roleManager.setPreVersion(false);
    }

    BasicAuthorizer(IUserManager userManager, IRoleManager roleManager) throws AuthException {
        this.userManager = userManager;
        this.roleManager = roleManager;
    }

    protected void init() throws AuthException {
        this.userManager.reset();
        this.roleManager.reset();
        LOGGER.info("Initialization of Authorizer completes");
    }

    public static IAuthorizer getInstance() throws AuthException {
        if (InstanceHolder.instance == null) {
            throw new AuthException(TSStatusCode.INIT_AUTH_ERROR, "Authorizer uninitialized");
        }
        return InstanceHolder.instance;
    }

    abstract boolean isAdmin(String var1);

    @Override
    public boolean login(String username, String password) throws AuthException {
        User user = this.userManager.getUser(username);
        return user != null && password != null && AuthUtils.validatePassword(password, user.getPassword());
    }

    @Override
    public void createUser(String username, String password) throws AuthException {
        if (!this.userManager.createUser(username, password, true)) {
            throw new AuthException(TSStatusCode.USER_ALREADY_EXIST, String.format("User %s already exists", username));
        }
    }

    @Override
    public void createUserWithoutCheck(String username, String password) throws AuthException {
        if (!this.userManager.createUser(username, password, false)) {
            throw new AuthException(TSStatusCode.USER_ALREADY_EXIST, String.format("User %s already exists", username));
        }
    }

    @Override
    public void deleteUser(String username) throws AuthException {
        if (this.isAdmin(username)) {
            throw new AuthException(TSStatusCode.NO_PERMISSION, "Default administrator cannot be deleted");
        }
        if (!this.userManager.deleteUser(username)) {
            throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format("User %s does not exist", username));
        }
    }

    @Override
    public void grantPrivilegeToUser(String username, PartialPath path, int privilegeId, boolean grantOpt) throws AuthException {
        if (this.isAdmin(username)) {
            throw new AuthException(TSStatusCode.NO_PERMISSION, "Invalid operation, administrator already has all privileges");
        }
        this.userManager.grantPrivilegeToUser(username, path, privilegeId, grantOpt);
    }

    @Override
    public void revokePrivilegeFromUser(String username, PartialPath path, int privilegeId) throws AuthException {
        if (this.isAdmin(username)) {
            throw new AuthException(TSStatusCode.NO_PERMISSION, "Invalid operation, administrator must have all privileges");
        }
        if (!this.userManager.revokePrivilegeFromUser(username, path, privilegeId)) {
            throw new AuthException(TSStatusCode.NOT_HAS_PRIVILEGE, String.format("User %s does not have %s on %s", new Object[]{username, PrivilegeType.values()[privilegeId], path != null ? path : "system"}));
        }
    }

    @Override
    public void createRole(String roleName) throws AuthException {
        if (!this.roleManager.createRole(roleName)) {
            LOGGER.error("Role {} already exists", (Object)roleName);
            throw new AuthException(TSStatusCode.ROLE_ALREADY_EXIST, String.format("Role %s already exists", roleName));
        }
    }

    @Override
    public void deleteRole(String roleName) throws AuthException {
        boolean success = this.roleManager.deleteRole(roleName);
        if (!success) {
            throw new AuthException(TSStatusCode.ROLE_NOT_EXIST, String.format("Role %s does not exist", roleName));
        }
        List<String> users = this.userManager.listAllUsers();
        for (String user : users) {
            try {
                this.userManager.revokeRoleFromUser(roleName, user);
            }
            catch (AuthException e) {
                LOGGER.warn("Error encountered when revoking a role {} from user {} after deletion", roleName, user, e);
            }
        }
    }

    @Override
    public void grantPrivilegeToRole(String roleName, PartialPath path, int privilegeId, boolean grantOpt) throws AuthException {
        this.roleManager.grantPrivilegeToRole(roleName, path, privilegeId, grantOpt);
    }

    @Override
    public void revokePrivilegeFromRole(String roleName, PartialPath path, int privilegeId) throws AuthException {
        if (!this.roleManager.revokePrivilegeFromRole(roleName, path, privilegeId)) {
            throw new AuthException(TSStatusCode.NOT_HAS_PRIVILEGE, String.format("Role %s does not have %s on %s", new Object[]{roleName, PrivilegeType.values()[privilegeId], path}));
        }
    }

    @Override
    public void grantRoleToUser(String roleName, String username) throws AuthException {
        if (this.isAdmin(username)) {
            throw new AuthException(TSStatusCode.NO_PERMISSION, "Invalid operation, cannot grant role to administrator ");
        }
        Role role = this.roleManager.getRole(roleName);
        if (role == null) {
            throw new AuthException(TSStatusCode.ROLE_NOT_EXIST, String.format(NO_SUCH_ROLE_EXCEPTION, roleName));
        }
        boolean success = this.userManager.grantRoleToUser(roleName, username);
        if (success) {
            role = this.roleManager.getRole(roleName);
            if (role == null) {
                throw new AuthException(TSStatusCode.ROLE_NOT_EXIST, String.format(NO_SUCH_ROLE_EXCEPTION, roleName));
            }
        } else {
            throw new AuthException(TSStatusCode.USER_ALREADY_HAS_ROLE, String.format("User %s already has role %s", username, roleName));
        }
    }

    @Override
    public void revokeRoleFromUser(String roleName, String username) throws AuthException {
        if (this.isAdmin(username)) {
            throw new AuthException(TSStatusCode.NO_PERMISSION, "Invalid operation, cannot revoke role from administrator ");
        }
        Role role = this.roleManager.getRole(roleName);
        if (role == null) {
            throw new AuthException(TSStatusCode.ROLE_NOT_EXIST, String.format(NO_SUCH_ROLE_EXCEPTION, roleName));
        }
        if (!this.userManager.revokeRoleFromUser(roleName, username)) {
            throw new AuthException(TSStatusCode.USER_NOT_HAS_ROLE, String.format("User %s does not have role %s", username, roleName));
        }
    }

    @Override
    public Set<Integer> getPrivileges(String username, PartialPath path) throws AuthException {
        User user = this.userManager.getUser(username);
        if (user == null) {
            throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_EXCEPTION, username));
        }
        Set<Integer> privileges = user.getPathPrivileges(path);
        for (String roleName : user.getRoleList()) {
            Role role = this.roleManager.getRole(roleName);
            if (role == null) continue;
            privileges.addAll(role.getPathPrivileges(path));
        }
        return privileges;
    }

    @Override
    public void updateUserPassword(String username, String newPassword) throws AuthException {
        if (!this.userManager.updateUserPassword(username, newPassword)) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "password " + newPassword + " is illegal");
        }
    }

    @Override
    public boolean checkUserPrivileges(String username, PartialPath path, int privilegeId) throws AuthException {
        if (this.isAdmin(username)) {
            return true;
        }
        User user = this.userManager.getUser(username);
        if (user == null) {
            throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format(NO_SUCH_USER_EXCEPTION, username));
        }
        if (path != null) {
            if (user.checkPathPrivilege(path, privilegeId)) {
                return true;
            }
            for (String roleName : user.getRoleList()) {
                Role role = this.roleManager.getRole(roleName);
                if (!role.checkPathPrivilege(path, privilegeId)) continue;
                return true;
            }
        } else {
            if (user.checkSysPrivilege(privilegeId)) {
                return true;
            }
            for (String roleName : user.getRoleList()) {
                Role role = this.roleManager.getRole(roleName);
                if (!role.checkSysPrivilege(privilegeId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Boolean> getAllUserWaterMarkStatus() {
        HashMap<String, Boolean> userWaterMarkStatus = new HashMap<String, Boolean>();
        List<String> allUsers = this.listAllUsers();
        for (String user : allUsers) {
            try {
                userWaterMarkStatus.put(user, this.isUserUseWaterMark(user));
            }
            catch (AuthException e) {
                LOGGER.error("No such user: {}", (Object)user);
            }
        }
        return userWaterMarkStatus;
    }

    @Override
    public Map<String, User> getAllUsers() {
        HashMap<String, User> allUsers = new HashMap<String, User>();
        List<String> userNames = this.listAllUsers();
        for (String userName : userNames) {
            try {
                allUsers.put(userName, this.getUser(userName));
            }
            catch (AuthException e) {
                LOGGER.error("get all users failed, No such user: {}", (Object)userName);
            }
        }
        return allUsers;
    }

    @Override
    public Map<String, Role> getAllRoles() {
        HashMap<String, Role> allRoles = new HashMap<String, Role>();
        List<String> roleNames = this.listAllRoles();
        for (String roleName : roleNames) {
            try {
                allRoles.put(roleName, this.getRole(roleName));
            }
            catch (AuthException e) {
                LOGGER.error("get all roles failed, No such role: {}", (Object)roleName);
            }
        }
        return allRoles;
    }

    @Override
    public void reset() throws AuthException {
        this.init();
    }

    @Override
    public void start() throws StartupException {
        try {
            this.init();
        }
        catch (AuthException e) {
            throw new StartupException(e);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public ServiceType getID() {
        return ServiceType.AUTHORIZATION_SERVICE;
    }

    @Override
    public List<String> listAllUsers() {
        return this.userManager.listAllUsers();
    }

    @Override
    public List<String> listAllRoles() {
        return this.roleManager.listAllRoles();
    }

    @Override
    public Role getRole(String roleName) throws AuthException {
        return this.roleManager.getRole(roleName);
    }

    @Override
    public User getUser(String username) throws AuthException {
        return this.userManager.getUser(username);
    }

    @Override
    public boolean isUserUseWaterMark(String userName) throws AuthException {
        return this.userManager.isUserUseWaterMark(userName);
    }

    @Override
    public void setUserUseWaterMark(String userName, boolean useWaterMark) throws AuthException {
        this.userManager.setUserUseWaterMark(userName, useWaterMark);
    }

    @Override
    public void replaceAllUsers(Map<String, User> users) throws AuthException {
        this.userManager.replaceAllUsers(users);
    }

    @Override
    public void replaceAllRoles(Map<String, Role> roles) throws AuthException {
        this.roleManager.replaceAllRoles(roles);
    }

    @Override
    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        return this.userManager.processTakeSnapshot(snapshotDir) && this.roleManager.processTakeSnapshot(snapshotDir);
    }

    @Override
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        this.userManager.processLoadSnapshot(snapshotDir);
        this.roleManager.processLoadSnapshot(snapshotDir);
    }

    @Override
    public void setUserForPreVersion(boolean preVersion) {
        this.userManager.setPreVersion(preVersion);
    }

    @Override
    public void setRoleForPreVersion(boolean preVersion) {
        this.roleManager.setPreVersion(preVersion);
    }

    @Override
    public boolean forUserPreVersion() {
        return this.userManager.preVersion();
    }

    @Override
    public boolean forRolePreVersion() {
        return this.roleManager.preVersion();
    }

    private static class InstanceHolder {
        private static final IAuthorizer instance;

        private InstanceHolder() {
        }

        static {
            try {
                Class<?> c = Class.forName(CommonDescriptor.getInstance().getConfig().getAuthorizerProvider());
                LOGGER.info("Authorizer provider class: {}", (Object)CommonDescriptor.getInstance().getConfig().getAuthorizerProvider());
                instance = (IAuthorizer)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Authorizer could not be initialized!", e);
            }
        }
    }
}

