/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.jexl3.parser.Token;

public final class NumberParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Number literal = null;
    private Class<? extends Number> clazz = null;
    static final DecimalFormat BIGDF = new DecimalFormat("0.0b", new DecimalFormatSymbols(Locale.ENGLISH));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.literal == null || this.clazz == null || Double.isNaN(this.literal.doubleValue())) {
            return "NaN";
        }
        if (BigDecimal.class.equals(this.clazz)) {
            DecimalFormat decimalFormat = BIGDF;
            synchronized (decimalFormat) {
                return BIGDF.format(this.literal);
            }
        }
        StringBuilder strb = new StringBuilder(this.literal.toString());
        if (Float.class.equals(this.clazz)) {
            strb.append('f');
        } else if (Double.class.equals(this.clazz)) {
            strb.append('d');
        } else if (BigInteger.class.equals(this.clazz)) {
            strb.append('h');
        } else if (Long.class.equals(this.clazz)) {
            strb.append('l');
        }
        return strb.toString();
    }

    Class<? extends Number> getLiteralClass() {
        return this.clazz;
    }

    boolean isInteger() {
        return Integer.class.equals(this.clazz);
    }

    Number getLiteralValue() {
        return this.literal;
    }

    private static boolean isNegative(Token token) {
        return token != null && "-".equals(token.image);
    }

    static Number parseInteger(Token negative, Token s2) {
        return new NumberParser().assignNatural(NumberParser.isNegative(negative), s2.image).getLiteralValue();
    }

    static Number parseDouble(Token negative, Token s2) {
        return new NumberParser().assignReal(NumberParser.isNegative(negative), s2.image).getLiteralValue();
    }

    NumberParser assignNatural(String str) {
        String s2;
        boolean negative;
        switch (str.charAt(0)) {
            case '-': {
                negative = true;
                s2 = str.substring(1);
                break;
            }
            case '+': {
                negative = false;
                s2 = str.substring(1);
                break;
            }
            default: {
                negative = false;
                s2 = str;
            }
        }
        return this.assignNatural(negative, s2);
    }

    NumberParser assignNatural(boolean negative, String natural) {
        Number result;
        Class rclass;
        int base;
        String s2 = natural;
        if (s2.charAt(0) == '0') {
            if (s2.length() > 1 && (s2.charAt(1) == 'x' || s2.charAt(1) == 'X')) {
                base = 16;
                s2 = s2.substring(2);
            } else {
                base = 8;
            }
        } else {
            base = 10;
        }
        int last = s2.length() - 1;
        switch (s2.charAt(last)) {
            case 'L': 
            case 'l': {
                rclass = Long.class;
                long l = Long.parseLong(s2.substring(0, last), base);
                result = negative ? -l : l;
                break;
            }
            case 'H': 
            case 'h': {
                rclass = BigInteger.class;
                BigInteger bi = new BigInteger(s2.substring(0, last), base);
                result = negative ? bi.negate() : bi;
                break;
            }
            default: {
                rclass = Integer.class;
                try {
                    int i = Integer.parseInt(s2, base);
                    result = negative ? -i : i;
                    break;
                }
                catch (NumberFormatException take2) {
                    try {
                        long l = Long.parseLong(s2, base);
                        result = negative ? -l : l;
                        break;
                    }
                    catch (NumberFormatException take3) {
                        BigInteger bi = new BigInteger(s2, base);
                        result = negative ? bi.negate() : bi;
                    }
                }
            }
        }
        this.literal = result;
        this.clazz = rclass;
        return this;
    }

    NumberParser assignReal(String str) {
        String s2;
        boolean negative;
        switch (str.charAt(0)) {
            case '-': {
                negative = true;
                s2 = str.substring(1);
                break;
            }
            case '+': {
                negative = false;
                s2 = str.substring(1);
                break;
            }
            default: {
                negative = false;
                s2 = str;
            }
        }
        return this.assignReal(negative, s2);
    }

    NumberParser assignReal(boolean negative, String s2) {
        Class rclass;
        Number result;
        if ("#NaN".equals(s2) || "NaN".equals(s2)) {
            result = Double.NaN;
            rclass = Double.class;
        } else {
            int last = s2.length() - 1;
            switch (s2.charAt(last)) {
                case 'B': 
                case 'b': {
                    rclass = BigDecimal.class;
                    BigDecimal bd = new BigDecimal(s2.substring(0, last));
                    result = negative ? bd.negate() : bd;
                    break;
                }
                case 'F': 
                case 'f': {
                    rclass = Float.class;
                    float f4 = Float.parseFloat(s2.substring(0, last));
                    result = Float.valueOf(negative ? -f4 : f4);
                    break;
                }
                case 'D': 
                case 'd': {
                    rclass = Double.class;
                    double f8 = Double.parseDouble(s2.substring(0, last));
                    result = negative ? -f8 : f8;
                    break;
                }
                default: {
                    rclass = Double.class;
                    try {
                        double d = Double.parseDouble(s2);
                        result = negative ? -d : d;
                        break;
                    }
                    catch (NumberFormatException take3) {
                        BigDecimal bd = new BigDecimal(s2);
                        result = negative ? bd.negate() : bd;
                    }
                }
            }
        }
        this.literal = result;
        this.clazz = rclass;
        return this;
    }
}

