/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceList;
import org.apache.iotdb.db.storageengine.rescon.memory.TsFileResourceManager;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class TsFileManager {
    private final String storageGroupName;
    private String dataRegionId;
    private final String storageGroupDir;
    private final ReadWriteLock resourceListLock = new ReentrantReadWriteLock();
    private String writeLockHolder;
    private final TreeMap<Long, TsFileResourceList> sequenceFiles = new TreeMap();
    private final TreeMap<Long, TsFileResourceList> unsequenceFiles = new TreeMap();
    private boolean allowCompaction = true;
    private final AtomicLong currentCompactionTaskSerialId = new AtomicLong(0L);

    public TsFileManager(String storageGroupName, String dataRegionId, String storageGroupDir) {
        this.storageGroupName = storageGroupName;
        this.storageGroupDir = storageGroupDir;
        this.dataRegionId = dataRegionId;
    }

    public List<TsFileResource> getTsFileList(boolean sequence) {
        return this.getTsFileList(sequence, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TsFileResource> getTsFileList(boolean sequence, List<Long> timePartitions, Filter timeFilter) {
        this.readLock();
        try {
            TreeMap<Long, TsFileResourceList> chosenMap;
            ArrayList<TsFileResource> allResources = new ArrayList<TsFileResource>();
            TreeMap<Long, TsFileResourceList> treeMap = chosenMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            if (timePartitions == null) {
                for (Map.Entry entry : chosenMap.entrySet()) {
                    if (!TimePartitionUtils.satisfyTimePartition((Filter)timeFilter, (long)((Long)entry.getKey()))) continue;
                    allResources.addAll(((TsFileResourceList)entry.getValue()).getArrayList());
                }
            } else {
                for (Long l : timePartitions) {
                    TsFileResourceList tsFileResources = (TsFileResourceList)chosenMap.get(l);
                    if (tsFileResources == null) continue;
                    allResources.addAll(tsFileResources.getArrayList());
                }
            }
            ArrayList<TsFileResource> arrayList = allResources;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TsFileResource> getTsFileListSnapshot(long timePartition, boolean sequence) {
        this.readLock();
        try {
            TreeMap<Long, TsFileResourceList> chosenMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            ArrayList<TsFileResource> arrayList = new ArrayList<TsFileResource>(chosenMap.getOrDefault(timePartition, new TsFileResourceList()));
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TsFileResource> getTsFileList(boolean sequence, long startTime, long endTime) {
        this.readLock();
        try {
            ArrayList<TsFileResource> allResources = new ArrayList<TsFileResource>();
            TreeMap<Long, TsFileResourceList> chosenMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            for (Map.Entry entry : chosenMap.entrySet()) {
                if (!TimePartitionUtils.satisfyPartitionId((long)startTime, (long)endTime, (long)((Long)entry.getKey()))) continue;
                allResources.addAll(((TsFileResourceList)entry.getValue()).getArrayList());
            }
            ArrayList<TsFileResource> arrayList = allResources;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TsFileResourceList getOrCreateSequenceListByTimePartition(long timePartition) {
        this.writeLock("getOrCreateSequenceListByTimePartition");
        try {
            TsFileResourceList tsFileResourceList = this.sequenceFiles.computeIfAbsent(timePartition, l -> new TsFileResourceList());
            return tsFileResourceList;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TsFileResourceList getOrCreateUnsequenceListByTimePartition(long timePartition) {
        this.writeLock("getOrCreateUnsequenceListByTimePartition");
        try {
            TsFileResourceList tsFileResourceList = this.unsequenceFiles.computeIfAbsent(timePartition, l -> new TsFileResourceList());
            return tsFileResourceList;
        }
        finally {
            this.writeUnlock();
        }
    }

    public Iterator<TsFileResource> getIterator(boolean sequence) {
        this.readLock();
        try {
            Iterator<TsFileResource> iterator = this.getTsFileList(sequence).iterator();
            return iterator;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TsFileResource tsFileResource, boolean sequence) {
        this.writeLock("remove");
        try {
            TreeMap<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            for (Map.Entry entry : selectedMap.entrySet()) {
                if (!((TsFileResourceList)entry.getValue()).contains(tsFileResource)) continue;
                ((TsFileResourceList)entry.getValue()).remove(tsFileResource);
                TsFileResourceManager.getInstance().removeTsFileResource(tsFileResource);
                break;
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        this.writeLock("removeAll");
        try {
            for (TsFileResource resource : tsFileResourceList) {
                this.remove(resource, sequence);
                TsFileResourceManager.getInstance().removeTsFileResource(resource);
            }
        }
        finally {
            this.writeLock("removeAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertToPartitionFileList(TsFileResource tsFileResource, long timePartition, boolean sequence, int insertPos) {
        this.writeLock("add");
        try {
            TreeMap<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            TsFileResourceList tsFileResources = selectedMap.computeIfAbsent(timePartition, o -> new TsFileResourceList());
            tsFileResources.set(insertPos, tsFileResource);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TsFileResource tsFileResource, boolean sequence) {
        this.writeLock("add");
        try {
            TreeMap<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            selectedMap.computeIfAbsent(tsFileResource.getTimePartition(), o -> new TsFileResourceList()).add(tsFileResource);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepOrderInsert(TsFileResource tsFileResource, boolean sequence) throws IOException {
        this.writeLock("keepOrderInsert");
        try {
            TreeMap<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            selectedMap.computeIfAbsent(tsFileResource.getTimePartition(), o -> new TsFileResourceList()).keepOrderInsert(tsFileResource);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        this.writeLock("add");
        try {
            for (TsFileResource resource : tsFileResourceList) {
                this.add(resource, sequence);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(List<TsFileResource> seqFileResources, List<TsFileResource> unseqFileResources, List<TsFileResource> targetFileResources, long timePartition) throws IOException {
        this.writeLock("replace");
        try {
            for (TsFileResource tsFileResource : seqFileResources) {
                if (!this.sequenceFiles.get(timePartition).remove(tsFileResource)) continue;
                TsFileResourceManager.getInstance().removeTsFileResource(tsFileResource);
            }
            for (TsFileResource tsFileResource : unseqFileResources) {
                if (!this.unsequenceFiles.get(timePartition).remove(tsFileResource)) continue;
                TsFileResourceManager.getInstance().removeTsFileResource(tsFileResource);
            }
            for (TsFileResource resource : targetFileResources) {
                if (resource.isDeleted()) continue;
                TsFileResourceManager.getInstance().registerSealedTsFileResource(resource);
                if (resource.isSeq()) {
                    this.sequenceFiles.computeIfAbsent(timePartition, t -> new TsFileResourceList()).keepOrderInsert(resource);
                    continue;
                }
                this.unsequenceFiles.computeIfAbsent(timePartition, t -> new TsFileResourceList()).keepOrderInsert(resource);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(TsFileResource tsFileResource, boolean sequence) {
        this.readLock();
        try {
            TreeMap<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            TsFileResourceList list = selectedMap.getOrDefault(tsFileResource.getTimePartition(), null);
            boolean bl = list != null && list.contains(tsFileResource);
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    public void clear() {
        this.writeLock("clear");
        try {
            this.sequenceFiles.clear();
            this.unsequenceFiles.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(boolean sequence) {
        this.readLock();
        try {
            TreeMap<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            for (Map.Entry entry : selectedMap.entrySet()) {
                if (((TsFileResourceList)entry.getValue()).isEmpty()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(boolean sequence) {
        this.readLock();
        try {
            int totalSize = 0;
            TreeMap<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            for (Map.Entry entry : selectedMap.entrySet()) {
                totalSize += ((TsFileResourceList)entry.getValue()).size();
            }
            int n = totalSize;
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    public void readLock() {
        this.resourceListLock.readLock().lock();
    }

    public void readUnlock() {
        this.resourceListLock.readLock().unlock();
    }

    public void writeLock(String holder) {
        this.resourceListLock.writeLock().lock();
        this.writeLockHolder = holder;
    }

    public void writeUnlock() {
        this.resourceListLock.writeLock().unlock();
        this.writeLockHolder = "";
    }

    public String getStorageGroupName() {
        return this.storageGroupName;
    }

    public String getStorageGroupDir() {
        return this.storageGroupDir;
    }

    public Set<Long> getTimePartitions() {
        this.readLock();
        try {
            HashSet<Long> timePartitions = new HashSet<Long>(this.sequenceFiles.keySet());
            timePartitions.addAll(this.unsequenceFiles.keySet());
            HashSet<Long> hashSet = timePartitions;
            return hashSet;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean isAllowCompaction() {
        return this.allowCompaction;
    }

    public void setAllowCompaction(boolean allowCompaction) {
        this.allowCompaction = allowCompaction;
    }

    public String getDataRegionId() {
        return this.dataRegionId;
    }

    public void setDataRegionId(String dataRegionId) {
        this.dataRegionId = dataRegionId;
    }

    public long getNextCompactionTaskId() {
        return this.currentCompactionTaskSerialId.getAndIncrement();
    }

    public boolean hasNextTimePartition(long timePartition, boolean sequence) {
        try {
            return sequence ? this.sequenceFiles.higherKey(timePartition) != null : this.unsequenceFiles.higherKey(timePartition) != null;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public boolean isLatestTimePartition(long timePartitionId) {
        return this.sequenceFiles.higherKey(timePartitionId) == null && this.unsequenceFiles.higherKey(timePartitionId) == null;
    }
}

